/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ReplayingDecoder;
import io.netty.util.CharsetUtil;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.Version;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.NumericVersion;
import org.infinispan.container.versioning.NumericVersionGenerator;
import org.infinispan.container.versioning.VersionGenerator;
import org.infinispan.context.Flag;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.metadata.Metadata;
import org.infinispan.server.core.transport.ExtendedByteBuf;
import org.infinispan.server.core.transport.NettyTransport;
import org.infinispan.server.memcached.CacheUnavailableException;
import org.infinispan.server.memcached.MemcachedDecoderState;
import org.infinispan.server.memcached.MemcachedException;
import org.infinispan.server.memcached.MemcachedMetadata;
import org.infinispan.server.memcached.MemcachedOperation;
import org.infinispan.server.memcached.MemcachedParameters;
import org.infinispan.server.memcached.OperationContext;
import org.infinispan.server.memcached.RequestHeader;
import org.infinispan.server.memcached.ResponseEntry;
import org.infinispan.server.memcached.TextProtocolUtil;
import org.infinispan.server.memcached.UnknownOperationException;
import org.infinispan.server.memcached.logging.Log;
import org.infinispan.stats.Stats;
import org.infinispan.util.KeyValuePair;

public class MemcachedDecoder
extends ReplayingDecoder<MemcachedDecoderState> {
    private final AdvancedCache<byte[], byte[]> cache;
    private final ScheduledExecutorService scheduler;
    protected final NettyTransport transport;
    protected final Predicate<? super String> ignoreCache;
    private final TimeService timeService;
    private static final Log log = (Log)LogFactory.getLog(MemcachedDecoder.class, Log.class);
    public static final int SecondsInAMonth = 2592000;
    long defaultLifespanTime;
    long defaultMaxIdleTime;
    protected byte[] key;
    protected byte[] rawValue;
    protected Configuration cacheConfiguration;
    protected MemcachedParameters params;
    private final boolean isStatsEnabled;
    private final AtomicLong incrMisses = new AtomicLong();
    private final AtomicLong incrHits = new AtomicLong();
    private final AtomicLong decrMisses = new AtomicLong();
    private final AtomicLong decrHits = new AtomicLong();
    private final AtomicLong replaceIfUnmodifiedMisses = new AtomicLong();
    private final AtomicLong replaceIfUnmodifiedHits = new AtomicLong();
    private final AtomicLong replaceIfUnmodifiedBadval = new AtomicLong();
    private final ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream();
    protected RequestHeader header;
    ResponseEntry lastResponse;

    public MemcachedDecoder(AdvancedCache<byte[], byte[]> memcachedCache, ScheduledExecutorService scheduler, NettyTransport transport, Predicate<? super String> ignoreCache, MediaType valuePayload) {
        super((Object)MemcachedDecoderState.DECODE_HEADER);
        this.cache = memcachedCache.withMediaType(MediaType.TEXT_PLAIN, valuePayload);
        this.scheduler = scheduler;
        this.transport = transport;
        this.ignoreCache = ignoreCache;
        this.isStatsEnabled = this.cache.getCacheConfiguration().statistics().enabled();
        this.timeService = memcachedCache.getComponentRegistry().getTimeService();
    }

    private static MemcachedException wrapBadFormat(Throwable throwable) {
        return new MemcachedException("CLIENT_ERROR bad command line format: " + throwable.getMessage(), throwable);
    }

    private static MemcachedException wrapServerError(Throwable throwable) {
        return new MemcachedException("SERVER_ERROR " + throwable.getMessage(), throwable);
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        try {
            if (log.isTraceEnabled()) {
                log.tracef("Decode using instance @%x", System.identityHashCode((Object)this));
            }
            MemcachedDecoderState state = (MemcachedDecoderState)((Object)this.state());
            switch (state) {
                case DECODE_HEADER: {
                    this.decodeHeader(ctx, in, out);
                    break;
                }
                case DECODE_KEY: {
                    this.decodeKey(ctx, in);
                    break;
                }
                case DECODE_PARAMETERS: {
                    this.decodeParameters(ctx, in);
                    break;
                }
                case DECODE_VALUE: {
                    this.decodeValue(ctx, in);
                }
            }
        }
        catch (IOException | NumberFormatException e) {
            ctx.pipeline().fireExceptionCaught((Throwable)MemcachedDecoder.wrapBadFormat(e));
            this.resetParams();
        }
        catch (Exception e) {
            ctx.pipeline().fireExceptionCaught((Throwable)MemcachedDecoder.wrapServerError(e));
            this.resetParams();
        }
    }

    void decodeHeader(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> out) throws CacheUnavailableException, IOException {
        if (log.isTraceEnabled()) {
            log.tracef("Decode header using instance @%x", System.identityHashCode((Object)this));
        }
        this.header = new RequestHeader();
        boolean endOfOp = this.readHeader(buffer, this.header);
        Channel ch = ctx.channel();
        String cacheName = this.cache.getName();
        if (this.ignoreCache.test(cacheName)) {
            throw new CacheUnavailableException(cacheName);
        }
        this.cacheConfiguration = this.getCacheConfiguration();
        this.defaultLifespanTime = this.cacheConfiguration.expiration().lifespan();
        this.defaultMaxIdleTime = this.cacheConfiguration.expiration().maxIdle();
        if (endOfOp) {
            if (this.header.operation == MemcachedOperation.StatsRequest) {
                this.sendResponseOrdered(ch, CompletableFuture.completedFuture(this.createStatsResponse()));
            } else {
                this.customDecodeHeader(ctx, buffer);
            }
        } else {
            this.checkpoint((Object)MemcachedDecoderState.DECODE_KEY);
        }
    }

    void decodeKey(ChannelHandlerContext ctx, ByteBuf buffer) throws IOException {
        if (log.isTraceEnabled()) {
            log.tracef("Decoding key using instance @%x", System.identityHashCode((Object)this));
        }
        Channel ch = ctx.channel();
        switch (this.header.operation) {
            case GetRequest: 
            case GetWithVersionRequest: {
                this.get(buffer, ch);
                break;
            }
            case PutRequest: 
            case TouchRequest: 
            case RemoveRequest: 
            case PutIfAbsentRequest: 
            case ReplaceRequest: 
            case ReplaceIfUnmodifiedRequest: {
                this.handleModification(ch, buffer);
                break;
            }
            default: {
                this.customDecodeKey(ctx, buffer);
            }
        }
    }

    private void decodeParameters(ChannelHandlerContext ctx, ByteBuf buffer) throws IOException {
        boolean endOfOp;
        if (log.isTraceEnabled()) {
            log.tracef("Decoding parameters using instance @%x", System.identityHashCode((Object)this));
        }
        if (!(endOfOp = this.readParameters(buffer)) && this.params.valueLength > 0) {
            this.rawValue = new byte[this.params.valueLength];
            this.checkpoint((Object)MemcachedDecoderState.DECODE_VALUE);
        } else if (this.params.valueLength == 0) {
            this.rawValue = Util.EMPTY_BYTE_ARRAY;
            this.decodeValue(ctx, buffer);
        } else {
            this.decodeValue(ctx, buffer);
        }
    }

    private void decodeValue(ChannelHandlerContext ctx, ByteBuf buffer) {
        if (log.isTraceEnabled()) {
            log.tracef("Decoding value using instance @%x", System.identityHashCode((Object)this));
        }
        Channel ch = ctx.channel();
        switch (this.header.operation) {
            case PutRequest: {
                this.readValue(buffer);
                this.put(ch);
                break;
            }
            case TouchRequest: {
                this.touch(ch);
                break;
            }
            case PutIfAbsentRequest: {
                this.readValue(buffer);
                this.putIfAbsent(ch);
                break;
            }
            case ReplaceRequest: {
                this.readValue(buffer);
                this.replace(ch);
                break;
            }
            case ReplaceIfUnmodifiedRequest: {
                this.readValue(buffer);
                this.replaceIfUnmodified(ch);
                break;
            }
            case RemoveRequest: {
                this.remove(ch);
                break;
            }
            default: {
                this.customDecodeValue(ctx, buffer);
            }
        }
    }

    protected void replace(Channel ch) {
        try {
            OperationContext ctx = this.createOperationContext();
            this.sendResponseOrdered(ch, ((CompletableFuture)this.cache.withFlags(Flag.SKIP_LISTENER_NOTIFICATION).getAsync((Object)ctx.key).thenCompose(prev -> prev == null ? CompletableFutures.completedNull() : this.cache.replaceAsync((Object)ctx.key, (Object)ctx.value, this.buildMetadata(ctx)))).thenApply(prev -> prev == null ? this.createNotExecutedResponse(ctx) : this.createSuccessResponse(ctx)));
        }
        finally {
            this.resetParams();
        }
    }

    protected void replaceIfUnmodified(Channel ch) {
        try {
            OperationContext ctx = this.createOperationContext();
            this.sendResponseOrdered(ch, this.cache.withFlags(Flag.SKIP_LISTENER_NOTIFICATION).getCacheEntryAsync((Object)ctx.key).thenCompose(entry -> {
                if (entry == null) {
                    return CompletableFuture.completedFuture(this.createNotExistResponse(ctx));
                }
                NumericVersion streamVersion = new NumericVersion(ctx.parameters.streamVersion);
                if (!entry.getMetadata().version().equals((Object)streamVersion)) {
                    return CompletableFuture.completedFuture(this.createNotExecutedResponse(ctx));
                }
                byte[] prev = (byte[])entry.getValue();
                return this.cache.replaceAsync((Object)ctx.key, (Object)prev, (Object)ctx.value, this.buildMetadata(ctx)).thenApply(replaced -> replaced != false ? this.createSuccessResponse(ctx) : this.createNotExecutedResponse(ctx));
            }));
        }
        finally {
            this.resetParams();
        }
    }

    private void touch(Channel ch) {
        try {
            OperationContext ctx = this.createOperationContext();
            this.sendResponseOrdered(ch, this.cache.getCacheEntryAsync((Object)ctx.key).thenCompose(cacheEntry -> {
                if (cacheEntry == null) {
                    return CompletableFuture.completedFuture(this.createNotExistResponse(ctx));
                }
                return this.cache.replaceAsync((Object)((byte[])cacheEntry.getKey()), (Object)((byte[])cacheEntry.getValue()), this.touchMetadata(ctx, (CacheEntry<?, ?>)cacheEntry)).thenApply(bytes -> MemcachedDecoder.createTouchedResponse(ctx));
            }));
        }
        finally {
            this.resetParams();
        }
    }

    private void putIfAbsent(Channel ch) {
        try {
            OperationContext ctx = this.createOperationContext();
            this.sendResponseOrdered(ch, ((CompletableFuture)this.cache.getAsync((Object)ctx.key).thenCompose(prev -> prev == null ? this.cache.putIfAbsentAsync((Object)ctx.key, (Object)ctx.value, this.buildMetadata(ctx)) : CompletableFuture.completedFuture(prev))).thenApply(prev -> prev == null ? this.createSuccessResponse(ctx) : this.createNotExecutedResponse(ctx)));
        }
        finally {
            this.resetParams();
        }
    }

    private void put(Channel ch) {
        try {
            OperationContext ctx = this.createOperationContext();
            this.sendResponseOrdered(ch, this.cache.withFlags(Flag.IGNORE_RETURN_VALUES).putAsync((Object)ctx.key, (Object)ctx.value, this.buildMetadata(ctx)).thenApply(unused -> this.createSuccessResponse(ctx)));
        }
        finally {
            this.resetParams();
        }
    }

    protected void remove(Channel ch) {
        try {
            OperationContext ctx = this.createOperationContext();
            this.sendResponseOrdered(ch, this.cache.removeAsync((Object)ctx.key).thenApply(prev -> prev == null ? this.createNotExistResponse(ctx) : this.createSuccessResponse(ctx)));
        }
        finally {
            this.resetParams();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void get(ByteBuf buffer, Channel ch) throws StreamCorruptedException {
        List<byte[]> keys = TextProtocolUtil.extractKeys(buffer);
        int numberOfKeys = keys.size();
        try {
            if (numberOfKeys > 1) {
                Map<byte[], CacheEntry<byte[], byte[]>> map = Collections.synchronizedMap(new LinkedHashMap());
                CompletionStage<Void> lastStage = this.doGetMultipleKeys(MemcachedDecoder.checkKeyLength(keys.get(0), true, buffer), map);
                for (int i = 1; i < numberOfKeys; ++i) {
                    byte[] key = MemcachedDecoder.checkKeyLength(keys.get(i), true, buffer);
                    lastStage = lastStage.thenCompose(unused -> this.doGetMultipleKeys(key, map));
                }
                this.sendResponseOrdered(ch, lastStage.thenApply(unused -> MemcachedDecoder.createMultiGetResponse(map)));
            } else {
                byte[] key = MemcachedDecoder.checkKeyLength(keys.get(0), true, buffer);
                boolean requiresVersion = this.header.operation == MemcachedOperation.GetWithVersionRequest;
                this.sendResponseOrdered(ch, this.cache.getCacheEntryAsync((Object)key).thenApply(entry -> MemcachedDecoder.createGetResponse(key, (CacheEntry<byte[], byte[]>)entry, requiresVersion)));
            }
        }
        finally {
            this.resetParams();
        }
    }

    private CompletionStage<Void> doGetMultipleKeys(byte[] key, Map<byte[], CacheEntry<byte[], byte[]>> responses) {
        try {
            return this.cache.getCacheEntryAsync((Object)key).thenAccept(cacheEntry -> {
                if (cacheEntry != null) {
                    responses.put(key, (CacheEntry<byte[], byte[]>)cacheEntry);
                }
            });
        }
        catch (Throwable t) {
            return CompletableFuture.failedFuture(t);
        }
    }

    private boolean readHeader(ByteBuf buffer, RequestHeader header) throws IOException {
        this.byteBuffer.reset();
        boolean endOfOp = TextProtocolUtil.readElement(buffer, this.byteBuffer);
        String streamOp = TextProtocolUtil.extractString(this.byteBuffer);
        MemcachedOperation op = this.toRequest(streamOp, endOfOp, buffer);
        if (op == MemcachedOperation.StatsRequest && !endOfOp) {
            String line = TextProtocolUtil.readDiscardedLine(buffer).trim();
            if (!line.isEmpty()) {
                throw new StreamCorruptedException("Stats command does not accept arguments: " + line);
            }
            endOfOp = true;
        }
        if (op == MemcachedOperation.VerbosityRequest) {
            if (!endOfOp) {
                TextProtocolUtil.skipLine(buffer);
            }
            throw new StreamCorruptedException("Memcached 'verbosity' command is unsupported");
        }
        header.operation = op;
        return endOfOp;
    }

    private KeyValuePair<byte[], Boolean> readKey(ByteBuf b) throws IOException {
        this.byteBuffer.reset();
        boolean endOfOp = TextProtocolUtil.readElement(b, this.byteBuffer);
        byte[] keyBytes = this.byteBuffer.toByteArray();
        byte[] k = MemcachedDecoder.checkKeyLength(keyBytes, endOfOp, b);
        return new KeyValuePair((Object)k, (Object)endOfOp);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        Object errorResponse;
        Channel ch = ctx.channel();
        log.debug("Exception caught", cause);
        if (!(cause instanceof IOException) && (errorResponse = this.createErrorResponse(cause)) != null) {
            if (errorResponse instanceof byte[]) {
                ch.writeAndFlush((Object)ExtendedByteBuf.wrappedBuffer((byte[][])new byte[][]{(byte[])errorResponse}), ch.voidPromise());
            } else if (errorResponse instanceof CharSequence) {
                ch.writeAndFlush((Object)Unpooled.copiedBuffer((CharSequence)((CharSequence)errorResponse), (Charset)TextProtocolUtil.CHARSET), ch.voidPromise());
            } else {
                ch.writeAndFlush(errorResponse, ch.voidPromise());
            }
        }
    }

    private static byte[] checkKeyLength(byte[] k, boolean endOfOp, ByteBuf b) throws StreamCorruptedException {
        CharBuffer keyCharBuffer = StandardCharsets.UTF_8.decode(ByteBuffer.wrap(k));
        if (keyCharBuffer.length() > 250) {
            if (!endOfOp) {
                TextProtocolUtil.skipLine(b);
            }
            throw new StreamCorruptedException("Key length over the 250 character limit");
        }
        return k;
    }

    private boolean readParameters(ByteBuf b) throws IOException {
        List<String> args = TextProtocolUtil.readSplitLine(b);
        boolean endOfOp = false;
        if (args.size() != 0) {
            if (log.isTraceEnabled()) {
                log.tracef("Operation parameters: %s", args);
            }
            try {
                switch (this.header.operation) {
                    case TouchRequest: {
                        endOfOp = true;
                        this.params = this.readTouchParameters(args);
                        break;
                    }
                    case RemoveRequest: {
                        this.params = this.readRemoveParameters(args);
                        break;
                    }
                    case IncrementRequest: 
                    case DecrementRequest: {
                        endOfOp = true;
                        this.params = this.readIncrDecrParameters(args);
                        break;
                    }
                    case FlushAllRequest: {
                        this.params = this.readFlushAllParameters(args);
                        break;
                    }
                    default: {
                        this.params = this.readStorageParameters(args);
                        break;
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IOException("Missing content in command line " + String.valueOf(args));
            }
        }
        if (log.isTraceEnabled()) {
            log.tracef("Operation parameters decoded: %s", this.params);
        }
        return endOfOp;
    }

    private MemcachedParameters readTouchParameters(List<String> args) throws StreamCorruptedException, EOFException {
        int streamLifespan = this.getLifespan(args.get(0));
        int lifespan = streamLifespan <= 0 ? -1 : this.getLifespan(args.get(0));
        boolean noReply = this.parseNoReply(1, args);
        return new MemcachedParameters(0, lifespan, -1, -1L, noReply, 0L, "", 0);
    }

    private MemcachedParameters readRemoveParameters(List<String> args) throws StreamCorruptedException {
        int delayedDeleteTime = this.parseDelayedDeleteTime(args);
        boolean noReply = delayedDeleteTime == -1 && this.parseNoReply(0, args);
        return new MemcachedParameters(-1, -1, -1, -1L, noReply, 0L, "", 0);
    }

    private MemcachedParameters readIncrDecrParameters(List<String> args) throws StreamCorruptedException {
        String delta = args.get(0);
        return new MemcachedParameters(-1, -1, -1, -1L, this.parseNoReply(1, args), 0L, delta, 0);
    }

    private MemcachedParameters readFlushAllParameters(List<String> args) throws StreamCorruptedException {
        int flushDelay;
        boolean noReplyFound = false;
        try {
            flushDelay = this.friendlyMaxIntCheck(args.get(0), "Flush delay");
        }
        catch (NumberFormatException n) {
            if (n.getMessage().contains("noreply")) {
                noReplyFound = true;
                flushDelay = 0;
            }
            throw n;
        }
        boolean noReply = noReplyFound || this.parseNoReply(1, args);
        return new MemcachedParameters(-1, -1, -1, -1L, noReply, 0L, "", flushDelay);
    }

    private MemcachedParameters readStorageParameters(List<String> args) throws StreamCorruptedException, EOFException {
        int length;
        int streamLifespan;
        int index = 0;
        long flags = this.getFlags(args.get(index));
        if (flags < 0L) {
            throw new StreamCorruptedException("Flags cannot be negative: " + flags);
        }
        int lifespan = (streamLifespan = this.getLifespan(args.get(++index))) <= 0 ? -1 : this.getLifespan(args.get(index));
        if ((length = this.getLength(args.get(++index))) < 0) {
            throw new StreamCorruptedException("Negative bytes length provided: " + length);
        }
        long streamVersion = this.header.operation == MemcachedOperation.ReplaceIfUnmodifiedRequest ? this.getVersion(args.get(++index)) : 1L;
        boolean noReply = this.parseNoReply(++index, args);
        return new MemcachedParameters(length, lifespan, -1, streamVersion, noReply, flags, "", 0);
    }

    private EntryVersion generateVersion() {
        ComponentRegistry registry = this.getCacheRegistry();
        VersionGenerator cacheVersionGenerator = (VersionGenerator)registry.getComponent(VersionGenerator.class);
        if (cacheVersionGenerator == null) {
            NumericVersionGenerator newVersionGenerator = new NumericVersionGenerator();
            registry.registerComponent((Object)newVersionGenerator, VersionGenerator.class);
            return newVersionGenerator.generateNew();
        }
        return cacheVersionGenerator.generateNew();
    }

    private void readValue(ByteBuf b) {
        b.readBytes(this.rawValue);
        TextProtocolUtil.skipLine(b);
    }

    private long getFlags(String flags) throws EOFException {
        if (flags == null) {
            throw new EOFException("No flags passed");
        }
        try {
            return this.numericLimitCheck(flags, 0xFFFFFFFFL, "Flags");
        }
        catch (NumberFormatException n) {
            return this.numericLimitCheck(flags, 0xFFFFFFFFL, "Flags", n);
        }
    }

    private int getLifespan(String lifespan) throws EOFException {
        if (lifespan == null) {
            throw new EOFException("No expiry passed");
        }
        return this.friendlyMaxIntCheck(lifespan, "Lifespan");
    }

    private int getLength(String length) throws EOFException {
        if (length == null) {
            throw new EOFException("No bytes passed");
        }
        return this.friendlyMaxIntCheck(length, "The number of bytes");
    }

    private long getVersion(String version) throws EOFException {
        if (version == null) {
            throw new EOFException("No cas passed");
        }
        return Long.parseLong(version);
    }

    private boolean parseNoReply(int expectedIndex, List<String> args) throws StreamCorruptedException {
        if (args.size() > expectedIndex) {
            if ("noreply".equals(args.get(expectedIndex))) {
                return true;
            }
            throw new StreamCorruptedException("Unable to parse noreply optional argument");
        }
        return false;
    }

    private int parseDelayedDeleteTime(List<String> args) {
        if (args.size() > 0) {
            try {
                return Integer.parseInt(args.get(0));
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
        return 0;
    }

    private Configuration getCacheConfiguration() {
        return this.cache.getCacheConfiguration();
    }

    private ComponentRegistry getCacheRegistry() {
        return this.cache.getComponentRegistry();
    }

    private void customDecodeHeader(ChannelHandlerContext ctx, ByteBuf buffer) throws IOException {
        Channel ch = ctx.channel();
        switch (this.header.operation) {
            case FlushAllRequest: {
                this.flushAll(buffer, ch, false);
                break;
            }
            case VersionRequest: {
                StringBuilder ret = new StringBuilder().append("VERSION ").append(Version.getVersion()).append("\r\n");
                this.sendResponseOrdered(ch, CompletableFuture.completedFuture(ret));
                break;
            }
            case QuitRequest: {
                ch.close();
                break;
            }
            default: {
                throw new IllegalArgumentException("Operation " + String.valueOf((Object)this.header.operation) + " not supported!");
            }
        }
    }

    protected void customDecodeKey(ChannelHandlerContext ctx, ByteBuf buffer) throws IOException {
        switch (this.header.operation) {
            case IncrementRequest: 
            case DecrementRequest: 
            case AppendRequest: 
            case PrependRequest: {
                this.key = (byte[])this.readKey(buffer).getKey();
                this.checkpoint((Object)MemcachedDecoderState.DECODE_PARAMETERS);
                break;
            }
            case FlushAllRequest: {
                this.flushAll(buffer, ctx.channel(), true);
                break;
            }
            default: {
                throw new IllegalArgumentException("Operation " + String.valueOf((Object)this.header.operation) + " not supported!");
            }
        }
    }

    protected void customDecodeValue(ChannelHandlerContext ctx, ByteBuf buffer) {
        Channel ch = ctx.channel();
        switch (this.header.operation) {
            case AppendRequest: 
            case PrependRequest: {
                this.readValue(buffer);
                this.prependOrAppendData(ch);
                break;
            }
            case IncrementRequest: 
            case DecrementRequest: {
                this.incrDecr(ch);
                break;
            }
            default: {
                throw new IllegalArgumentException("Operation " + String.valueOf((Object)this.header.operation) + " not supported!");
            }
        }
    }

    private void prependOrAppendData(Channel ch) {
        try {
            OperationContext ctx = this.createOperationContext();
            this.sendResponseOrdered(ch, this.cache.getAsync((Object)ctx.key).thenCompose(prev -> {
                if (prev == null) {
                    return CompletableFuture.completedFuture(ctx.isNoReply() ? null : TextProtocolUtil.NOT_STORED);
                }
                byte[] concatenated = ctx.isOperation(MemcachedOperation.AppendRequest) ? TextProtocolUtil.concat(prev, ctx.value) : TextProtocolUtil.concat(ctx.value, prev);
                return this.cache.replaceAsync((Object)ctx.key, prev, (Object)concatenated, this.buildMetadata(ctx)).thenApply(replaced -> replaced.booleanValue() ? (ctx.isNoReply() ? null : TextProtocolUtil.STORED) : (byte[])(ctx.isNoReply() ? null : TextProtocolUtil.NOT_STORED));
            }));
        }
        finally {
            this.resetParams();
        }
    }

    private void incrDecr(Channel ch) {
        try {
            OperationContext ctx = this.createOperationContext();
            this.sendResponseOrdered(ch, this.cache.getAsync((Object)ctx.key).thenCompose(prev -> {
                BigInteger candidateCounter;
                boolean isIncrement = ctx.isOperation(MemcachedOperation.IncrementRequest);
                if (prev == null) {
                    if (this.isStatsEnabled) {
                        if (isIncrement) {
                            this.incrMisses.incrementAndGet();
                        } else {
                            this.decrMisses.incrementAndGet();
                        }
                    }
                    return CompletableFuture.completedFuture(ctx.isNoReply() ? null : TextProtocolUtil.NOT_FOUND);
                }
                BigInteger prevCounter = new BigInteger(new String((byte[])prev));
                BigInteger delta = this.validateDelta(ctx.parameters.delta);
                candidateCounter = isIncrement ? ((candidateCounter = prevCounter.add(delta)).compareTo(TextProtocolUtil.MAX_UNSIGNED_LONG) > 0 ? TextProtocolUtil.MIN_UNSIGNED : candidateCounter) : ((candidateCounter = prevCounter.subtract(delta)).compareTo(TextProtocolUtil.MIN_UNSIGNED) < 0 ? TextProtocolUtil.MIN_UNSIGNED : candidateCounter);
                String counterString = candidateCounter.toString();
                return this.cache.replaceAsync((Object)ctx.key, prev, (Object)counterString.getBytes(), this.buildMetadata(ctx)).thenApply(replaced -> {
                    if (!replaced.booleanValue()) {
                        throw CompletableFutures.asCompletionException((Throwable)new CacheException("Value modified since we retrieved from the cache, old value was " + String.valueOf(prevCounter)));
                    }
                    if (this.isStatsEnabled) {
                        if (isIncrement) {
                            this.incrHits.incrementAndGet();
                        } else {
                            this.decrHits.incrementAndGet();
                        }
                    }
                    return ctx.isNoReply() ? null : counterString + "\r\n";
                });
            }));
        }
        finally {
            this.resetParams();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushAll(ByteBuf b, Channel ch, boolean isReadParams) throws IOException {
        if (isReadParams) {
            this.readParameters(b);
        }
        try {
            byte[] response;
            int flushDelay = this.params == null ? 0 : this.params.flushDelay;
            Object object = response = (Object)(this.params != null && this.params.noReply ? null : TextProtocolUtil.OK);
            if (flushDelay == 0) {
                this.sendResponseOrdered(ch, this.cache.clearAsync().thenApply(unused -> response));
                return;
            }
            this.scheduler.schedule(() -> this.cache.clear(), this.toMillis(flushDelay), TimeUnit.MILLISECONDS);
            this.sendResponseOrdered(ch, CompletableFuture.completedFuture(response));
        }
        finally {
            this.resetParams();
        }
    }

    private BigInteger validateDelta(String delta) {
        BigInteger bigIntDelta = new BigInteger(delta);
        if (bigIntDelta.compareTo(TextProtocolUtil.MAX_UNSIGNED_LONG) > 0) {
            throw CompletableFutures.asCompletionException((Throwable)new StreamCorruptedException("Increment or decrement delta sent (" + delta + ") exceeds unsigned limit (" + String.valueOf(TextProtocolUtil.MAX_UNSIGNED_LONG) + ")"));
        }
        if (bigIntDelta.compareTo(TextProtocolUtil.MIN_UNSIGNED) < 0) {
            throw CompletableFutures.asCompletionException((Throwable)new StreamCorruptedException("Increment or decrement delta cannot be negative: " + delta));
        }
        return bigIntDelta;
    }

    private Object createSuccessResponse(OperationContext context) {
        if (this.isStatsEnabled && context.isOperation(MemcachedOperation.ReplaceIfUnmodifiedRequest)) {
            this.replaceIfUnmodifiedHits.incrementAndGet();
        }
        if (context.isNoReply()) {
            return null;
        }
        if (context.isOperation(MemcachedOperation.RemoveRequest)) {
            return TextProtocolUtil.DELETED;
        }
        return TextProtocolUtil.STORED;
    }

    Object createNotExecutedResponse(OperationContext context) {
        if (this.isStatsEnabled && context.isOperation(MemcachedOperation.ReplaceIfUnmodifiedRequest)) {
            this.replaceIfUnmodifiedBadval.incrementAndGet();
        }
        if (context.isNoReply()) {
            return null;
        }
        if (context.isOperation(MemcachedOperation.ReplaceIfUnmodifiedRequest)) {
            return TextProtocolUtil.EXISTS;
        }
        return TextProtocolUtil.NOT_STORED;
    }

    Object createNotExistResponse(OperationContext context) {
        if (this.isStatsEnabled && context.isOperation(MemcachedOperation.ReplaceIfUnmodifiedRequest)) {
            this.replaceIfUnmodifiedMisses.incrementAndGet();
        }
        return context.isNoReply() ? null : TextProtocolUtil.NOT_FOUND;
    }

    private static Object createGetResponse(byte[] k, CacheEntry<byte[], byte[]> entry, boolean requiresVersions) {
        if (entry == null) {
            return TextProtocolUtil.END;
        }
        return requiresVersions ? MemcachedDecoder.buildSingleGetWithVersionResponse(k, entry) : MemcachedDecoder.buildSingleGetResponse(k, entry);
    }

    private static Object createTouchedResponse(OperationContext context) {
        return context.isNoReply() ? null : TextProtocolUtil.TOUCHED;
    }

    private static ByteBuf buildSingleGetResponse(byte[] k, CacheEntry<byte[], byte[]> entry) {
        ByteBuf buf = MemcachedDecoder.buildGetHeaderBegin(k, entry, TextProtocolUtil.END_SIZE);
        MemcachedDecoder.writeGetHeaderData((byte[])entry.getValue(), buf);
        return MemcachedDecoder.writeGetHeaderEnd(buf);
    }

    private static Object createMultiGetResponse(Map<byte[], CacheEntry<byte[], byte[]>> pairs) {
        Stream.Builder<ByteBuf> elements = Stream.builder();
        pairs.forEach((k, v) -> elements.add(MemcachedDecoder.buildGetResponse(k, (CacheEntry<byte[], byte[]>)v)));
        elements.add(ExtendedByteBuf.wrappedBuffer((byte[][])new byte[][]{TextProtocolUtil.END}));
        return elements.build().toArray(ByteBuf[]::new);
    }

    void handleModification(Channel ch, ByteBuf buf) throws IOException {
        KeyValuePair<byte[], Boolean> pair = this.readKey(buf);
        this.key = (byte[])pair.getKey();
        if (((Boolean)pair.getValue()).booleanValue()) {
            this.remove(ch);
        } else {
            this.checkpoint((Object)MemcachedDecoderState.DECODE_PARAMETERS);
        }
    }

    private void resetParams() {
        if (log.isTraceEnabled()) {
            log.tracef("Resetting parameters using instance @%x", System.identityHashCode((Object)this));
        }
        this.checkpoint((Object)MemcachedDecoderState.DECODE_HEADER);
        this.params = null;
        this.rawValue = null;
        this.key = null;
    }

    private Object createErrorResponse(Throwable t) {
        StringBuilder sb = new StringBuilder();
        if (t instanceof MemcachedException) {
            Throwable cause = t.getCause();
            if (cause instanceof UnknownOperationException) {
                log.exceptionReported(cause);
                return TextProtocolUtil.ERROR;
            }
            if (cause instanceof ClosedChannelException) {
                log.exceptionReported(cause);
                return null;
            }
            if (cause instanceof IOException || cause instanceof NumberFormatException || cause instanceof IllegalStateException) {
                return this.logAndCreateErrorMessage(sb, (MemcachedException)t);
            }
            return sb.append(t.getMessage()).append("\r\n");
        }
        if (t instanceof ClosedChannelException) {
            log.exceptionReported(t);
            return null;
        }
        return sb.append("SERVER_ERROR ").append(t.getMessage()).append("\r\n");
    }

    private Metadata buildMetadata(OperationContext context) {
        return new MemcachedMetadata.Builder().flags(context.parameters.flags).version(this.generateVersion()).lifespan(context.parameters.lifespan > 0 ? this.toMillis(context.parameters.lifespan) : -1L).build();
    }

    private Metadata touchMetadata(OperationContext context, CacheEntry<?, ?> entry) {
        return new MemcachedMetadata.Builder().merge(entry.getMetadata()).lifespan(context.parameters.lifespan > 0 ? this.toMillis(context.parameters.lifespan) : -1L).build();
    }

    private StringBuilder logAndCreateErrorMessage(StringBuilder sb, MemcachedException m) {
        log.exceptionReported(m.getCause());
        return sb.append(m.getMessage()).append("\r\n");
    }

    private long toMillis(int lifespan) {
        if (lifespan > 2592000) {
            long unixTimeExpiry = TimeUnit.SECONDS.toMillis(lifespan) - this.timeService.wallClockTime();
            return unixTimeExpiry < 0L ? 0L : unixTimeExpiry;
        }
        return TimeUnit.SECONDS.toMillis(lifespan);
    }

    protected void writeResponseOrThrowable(Channel ch, Object response, Throwable throwable) {
        if (throwable != null) {
            Throwable cause = CompletableFutures.extractException((Throwable)throwable);
            cause = cause instanceof IOException || cause instanceof NumberFormatException ? MemcachedDecoder.wrapBadFormat(cause) : MemcachedDecoder.wrapServerError(cause);
            ch.pipeline().fireExceptionCaught(cause);
        } else {
            this.writeResponse(ch, response);
        }
    }

    private void writeResponse(Channel ch, Object response) {
        if (response != null) {
            if (log.isTraceEnabled()) {
                log.tracef("Write response using instance @%x: %s", System.identityHashCode((Object)this), Util.toStr((Object)response));
            }
            if (response instanceof ByteBuf[]) {
                for (ByteBuf buf : (ByteBuf[])response) {
                    ch.write((Object)buf, ch.voidPromise());
                    ch.flush();
                }
            } else if (response instanceof byte[]) {
                ch.writeAndFlush((Object)ExtendedByteBuf.wrappedBuffer((byte[][])new byte[][]{(byte[])response}), ch.voidPromise());
            } else if (response instanceof CharSequence) {
                ch.writeAndFlush((Object)Unpooled.copiedBuffer((CharSequence)((CharSequence)response), (Charset)CharsetUtil.UTF_8), ch.voidPromise());
            } else {
                ch.writeAndFlush(response, ch.voidPromise());
            }
        }
    }

    Object createStatsResponse() {
        Stats stats = this.cache.getAdvancedCache().getStats();
        StringBuilder sb = new StringBuilder();
        return new ByteBuf[]{this.buildStat("pid", 0, sb), this.buildStat("uptime", stats.getTimeSinceStart(), sb), this.buildStat("time", TimeUnit.MILLISECONDS.toSeconds(this.timeService.wallClockTime()), sb), this.buildStat("version", this.cache.getVersion(), sb), this.buildStat("pointer_size", 0, sb), this.buildStat("rusage_user", 0, sb), this.buildStat("rusage_system", 0, sb), this.buildStat("curr_items", stats.getApproximateEntries(), sb), this.buildStat("total_items", stats.getStores(), sb), this.buildStat("bytes", 0, sb), this.buildStat("curr_connections", 0, sb), this.buildStat("total_connections", 0, sb), this.buildStat("connection_structures", 0, sb), this.buildStat("cmd_get", stats.getRetrievals(), sb), this.buildStat("cmd_set", stats.getStores(), sb), this.buildStat("get_hits", stats.getHits(), sb), this.buildStat("get_misses", stats.getMisses(), sb), this.buildStat("delete_misses", stats.getRemoveMisses(), sb), this.buildStat("delete_hits", stats.getRemoveHits(), sb), this.buildStat("incr_misses", this.incrMisses, sb), this.buildStat("incr_hits", this.incrHits, sb), this.buildStat("decr_misses", this.decrMisses, sb), this.buildStat("decr_hits", this.decrHits, sb), this.buildStat("cas_misses", this.replaceIfUnmodifiedMisses, sb), this.buildStat("cas_hits", this.replaceIfUnmodifiedHits, sb), this.buildStat("cas_badval", this.replaceIfUnmodifiedBadval, sb), this.buildStat("auth_cmds", 0, sb), this.buildStat("auth_errors", 0, sb), this.buildStat("evictions", stats.getEvictions(), sb), this.buildStat("bytes_read", this.transport.getTotalBytesRead(), sb), this.buildStat("bytes_written", this.transport.getTotalBytesWritten(), sb), this.buildStat("limit_maxbytes", 0, sb), this.buildStat("threads", 0, sb), this.buildStat("conn_yields", 0, sb), this.buildStat("reclaimed", 0, sb), ExtendedByteBuf.wrappedBuffer((byte[][])new byte[][]{TextProtocolUtil.END})};
    }

    private ByteBuf buildStat(String stat, Object value, StringBuilder sb) {
        sb.append("STAT").append(' ').append(stat).append(' ').append(value).append("\r\n");
        ByteBuf buffer = ExtendedByteBuf.wrappedBuffer((byte[][])new byte[][]{sb.toString().getBytes()});
        sb.setLength(0);
        return buffer;
    }

    private ByteBuf buildStat(String stat, int value, StringBuilder sb) {
        sb.append("STAT").append(' ').append(stat).append(' ').append(value).append("\r\n");
        ByteBuf buffer = ExtendedByteBuf.wrappedBuffer((byte[][])new byte[][]{sb.toString().getBytes()});
        sb.setLength(0);
        return buffer;
    }

    private ByteBuf buildStat(String stat, long value, StringBuilder sb) {
        sb.append("STAT").append(' ').append(stat).append(' ').append(value).append("\r\n");
        ByteBuf buffer = ExtendedByteBuf.wrappedBuffer((byte[][])new byte[][]{sb.toString().getBytes()});
        sb.setLength(0);
        return buffer;
    }

    private static ByteBuf buildGetResponse(byte[] k, CacheEntry<byte[], byte[]> entry) {
        ByteBuf buf = MemcachedDecoder.buildGetHeaderBegin(k, entry, 0);
        return MemcachedDecoder.writeGetHeaderData((byte[])entry.getValue(), buf);
    }

    private static ByteBuf buildGetHeaderBegin(byte[] key, CacheEntry<byte[], byte[]> entry, int extraSpace) {
        byte[] flags;
        byte[] data = (byte[])entry.getValue();
        byte[] dataSize = String.valueOf(data.length).getBytes();
        Metadata metadata = entry.getMetadata();
        if (metadata instanceof MemcachedMetadata) {
            long metaFlags = ((MemcachedMetadata)metadata).flags;
            flags = String.valueOf(metaFlags).getBytes();
        } else {
            flags = TextProtocolUtil.ZERO;
        }
        int flagsSize = flags.length;
        ByteBuf buf = ExtendedByteBuf.buffer((int)(TextProtocolUtil.VALUE_SIZE + key.length + data.length + flagsSize + dataSize.length + 6 + extraSpace));
        buf.writeBytes(TextProtocolUtil.VALUE);
        buf.writeBytes(key);
        buf.writeByte(32);
        buf.writeBytes(flags);
        buf.writeByte(32);
        buf.writeBytes(dataSize);
        return buf;
    }

    private static ByteBuf writeGetHeaderData(byte[] data, ByteBuf buf) {
        buf.writeBytes(TextProtocolUtil.CRLFBytes);
        buf.writeBytes(data);
        buf.writeBytes(TextProtocolUtil.CRLFBytes);
        return buf;
    }

    private static ByteBuf writeGetHeaderEnd(ByteBuf buf) {
        buf.writeBytes(TextProtocolUtil.END);
        return buf;
    }

    private static ByteBuf buildSingleGetWithVersionResponse(byte[] k, CacheEntry<byte[], byte[]> entry) {
        byte[] v = (byte[])entry.getValue();
        byte[] version = String.valueOf(((NumericVersion)entry.getMetadata().version()).getVersion()).getBytes();
        ByteBuf buf = MemcachedDecoder.buildGetHeaderBegin(k, entry, version.length + 1 + TextProtocolUtil.END_SIZE);
        buf.writeByte(32);
        buf.writeBytes(version);
        MemcachedDecoder.writeGetHeaderData(v, buf);
        return MemcachedDecoder.writeGetHeaderEnd(buf);
    }

    private int friendlyMaxIntCheck(String number, String message) {
        try {
            return Integer.parseInt(number);
        }
        catch (NumberFormatException e) {
            return this.numericLimitCheck(number, Integer.MAX_VALUE, message, e);
        }
    }

    private int numericLimitCheck(String number, long maxValue, String message, NumberFormatException n) {
        if (Long.parseLong(number) > maxValue) {
            throw new NumberFormatException(message + " sent (" + number + ") exceeds the limit (" + maxValue + ")");
        }
        throw n;
    }

    private long numericLimitCheck(String number, long maxValue, String message) {
        long numeric = Long.parseLong(number);
        if (numeric > maxValue) {
            throw new NumberFormatException(message + " sent (" + number + ") exceeds the limit (" + maxValue + ")");
        }
        return numeric;
    }

    private MemcachedOperation toRequest(String commandName, Boolean endOfOp, ByteBuf buffer) throws UnknownOperationException {
        if (log.isTraceEnabled()) {
            log.tracef("Operation: '%s'", commandName);
        }
        switch (commandName) {
            case "get": {
                return MemcachedOperation.GetRequest;
            }
            case "set": {
                return MemcachedOperation.PutRequest;
            }
            case "touch": {
                return MemcachedOperation.TouchRequest;
            }
            case "add": {
                return MemcachedOperation.PutIfAbsentRequest;
            }
            case "delete": {
                return MemcachedOperation.RemoveRequest;
            }
            case "replace": {
                return MemcachedOperation.ReplaceRequest;
            }
            case "cas": {
                return MemcachedOperation.ReplaceIfUnmodifiedRequest;
            }
            case "append": {
                return MemcachedOperation.AppendRequest;
            }
            case "prepend": {
                return MemcachedOperation.PrependRequest;
            }
            case "gets": {
                return MemcachedOperation.GetWithVersionRequest;
            }
            case "incr": {
                return MemcachedOperation.IncrementRequest;
            }
            case "decr": {
                return MemcachedOperation.DecrementRequest;
            }
            case "flush_all": {
                return MemcachedOperation.FlushAllRequest;
            }
            case "version": {
                return MemcachedOperation.VersionRequest;
            }
            case "stats": {
                return MemcachedOperation.StatsRequest;
            }
            case "verbosity": {
                return MemcachedOperation.VerbosityRequest;
            }
            case "quit": {
                return MemcachedOperation.QuitRequest;
            }
        }
        if (!endOfOp.booleanValue()) {
            String line = TextProtocolUtil.readDiscardedLine(buffer);
            log.debugf("Unexpected operation '%s', rest of line contains: %s", commandName, line);
        }
        throw new UnknownOperationException("Unknown operation: " + commandName);
    }

    private OperationContext createOperationContext() {
        return new OperationContext(this.header, this.params, this.key, this.rawValue);
    }

    private void sendResponseOrdered(Channel ch, CompletionStage<Object> rsp) {
        new ResponseEntry(this, ch).queueResponse(rsp);
    }
}

