/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.scripting.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.scripting.impl.ScriptMetadata;
import org.infinispan.scripting.impl.ScriptTask;
import org.infinispan.scripting.impl.ScriptingManagerImpl;
import org.infinispan.tasks.Task;
import org.infinispan.tasks.TaskContext;
import org.infinispan.tasks.TaskExecutionMode;
import org.infinispan.tasks.manager.spi.NonBlockingTaskEngine;
import org.infinispan.util.concurrent.BlockingManager;

public class ScriptingTaskEngine
implements NonBlockingTaskEngine {
    private final ScriptingManagerImpl scriptingManager;

    public ScriptingTaskEngine(ScriptingManagerImpl scriptingManager) {
        this.scriptingManager = scriptingManager;
    }

    public String getName() {
        return "Script";
    }

    public List<Task> getTasks() {
        ArrayList<Task> tasks = new ArrayList<Task>();
        this.scriptingManager.getScriptNames().forEach(s -> {
            ScriptMetadata scriptMetadata = this.scriptingManager.getScriptMetadata((String)s);
            tasks.add(new ScriptTask((String)s, scriptMetadata.mode().isClustered() ? TaskExecutionMode.ALL_NODES : TaskExecutionMode.ONE_NODE, scriptMetadata.parameters()));
        });
        return tasks;
    }

    public CompletionStage<List<Task>> getTasksAsync() {
        BlockingManager blockingManager = (BlockingManager)GlobalComponentRegistry.componentOf((EmbeddedCacheManager)this.scriptingManager.cacheManager, BlockingManager.class);
        return blockingManager.supplyBlocking(this::getTasks, (Object)"ScriptingTaskEngine - getTasksAsync");
    }

    public <T> CompletableFuture<T> runTask(String taskName, TaskContext context, BlockingManager blockingManager) {
        return this.scriptingManager.runScript(taskName, context).toCompletableFuture();
    }

    public boolean handles(String taskName) {
        return this.scriptingManager.containsScript(taskName);
    }

    public CompletionStage<Boolean> handlesAsync(String taskName) {
        return this.scriptingManager.containsScriptAsync(taskName);
    }
}

