/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.dataconversion.ByteArrayWrapper;
import org.infinispan.objectfilter.impl.ProtobufMatcher;
import org.infinispan.objectfilter.impl.syntax.parser.IckleParsingResult;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.query.core.impl.eventfilter.IckleFilterAndConverter;
import org.infinispan.query.dsl.embedded.impl.QueryEngine;
import org.infinispan.query.impl.QueryDefinition;
import org.infinispan.query.remote.impl.ObjectRemoteQueryEngine;
import org.infinispan.query.remote.impl.ProtobufWrapper;
import org.infinispan.query.remote.impl.RemoteQueryManager;
import org.infinispan.query.remote.impl.filter.IckleProtobufFilterAndConverter;
import org.infinispan.util.function.SerializableFunction;

final class RemoteQueryEngine
extends ObjectRemoteQueryEngine {
    private static final SerializableFunction<AdvancedCache<?, ?>, QueryEngine<?>> queryEngineProvider = (SerializableFunction & Serializable)c -> ((RemoteQueryManager)c.getComponentRegistry().getComponent(RemoteQueryManager.class)).getQueryEngine((AdvancedCache<?, ?>)c);

    RemoteQueryEngine(AdvancedCache<?, ?> cache, boolean isIndexed) {
        super(isIndexed ? cache.withStorageMediaType().withWrapping(ByteArrayWrapper.class, ProtobufWrapper.class) : cache.withStorageMediaType(), isIndexed, ProtobufMatcher.class);
    }

    protected QueryEngine.RowProcessor makeProjectionProcessor(Class<?>[] projectedTypes, Object[] projectedNullMarkers) {
        int[] booleanPositions = new int[projectedTypes.length];
        int booleanColumnsNumber = 0;
        for (int i = 0; i < projectedTypes.length; ++i) {
            if (projectedTypes[i] != Boolean.class) continue;
            booleanPositions[booleanColumnsNumber++] = i;
        }
        boolean hasNullMarkers = false;
        if (projectedNullMarkers != null) {
            for (Object projectedNullMarker : projectedNullMarkers) {
                if (projectedNullMarker == null) continue;
                hasNullMarkers = true;
                break;
            }
        }
        if (booleanColumnsNumber == 0 && !hasNullMarkers) {
            return null;
        }
        boolean hasNullMarkers_ = hasNullMarkers;
        int[] booleanColumns = booleanColumnsNumber < booleanPositions.length ? Arrays.copyOf(booleanPositions, booleanColumnsNumber) : booleanPositions;
        return row -> {
            if (hasNullMarkers_) {
                for (int i = 0; i < projectedNullMarkers.length; ++i) {
                    if (row[i] == null || !row[i].equals(projectedNullMarkers[i])) continue;
                    row[i] = null;
                }
            }
            return row;
        };
    }

    protected QueryDefinition buildQueryDefinition(String q) {
        return new QueryDefinition(q, queryEngineProvider);
    }

    protected IckleFilterAndConverter createFilter(String queryString, Map<String, Object> namedParameters) {
        return this.isIndexed ? new IckleProtobufFilterAndConverter(queryString, namedParameters) : super.createFilter(queryString, namedParameters);
    }

    protected Class<?> getTargetedClass(IckleParsingResult<?> parsingResult) {
        return byte[].class;
    }

    protected String getTargetedNamedType(IckleParsingResult<?> parsingResult) {
        Descriptor targetEntityMetadata = (Descriptor)parsingResult.getTargetEntityMetadata();
        return targetEntityMetadata.getFullName();
    }
}

