/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.objectfilter.impl.syntax.parser;

import java.lang.invoke.MethodHandles;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.infinispan.commons.util.Util;
import org.infinispan.query.objectfilter.impl.logging.Log;
import org.infinispan.query.objectfilter.impl.ql.PropertyPath;
import org.infinispan.query.objectfilter.impl.ql.QueryRendererDelegate;
import org.infinispan.query.objectfilter.impl.syntax.AggregationExpr;
import org.infinispan.query.objectfilter.impl.syntax.AndExpr;
import org.infinispan.query.objectfilter.impl.syntax.BetweenExpr;
import org.infinispan.query.objectfilter.impl.syntax.BooleanExpr;
import org.infinispan.query.objectfilter.impl.syntax.ComparisonExpr;
import org.infinispan.query.objectfilter.impl.syntax.ConstantBooleanExpr;
import org.infinispan.query.objectfilter.impl.syntax.ConstantValueExpr;
import org.infinispan.query.objectfilter.impl.syntax.FullTextBoostExpr;
import org.infinispan.query.objectfilter.impl.syntax.FullTextOccurExpr;
import org.infinispan.query.objectfilter.impl.syntax.FullTextRangeExpr;
import org.infinispan.query.objectfilter.impl.syntax.FullTextRegexpExpr;
import org.infinispan.query.objectfilter.impl.syntax.FullTextTermExpr;
import org.infinispan.query.objectfilter.impl.syntax.IsNullExpr;
import org.infinispan.query.objectfilter.impl.syntax.KnnPredicate;
import org.infinispan.query.objectfilter.impl.syntax.LikeExpr;
import org.infinispan.query.objectfilter.impl.syntax.NestedExpr;
import org.infinispan.query.objectfilter.impl.syntax.NotExpr;
import org.infinispan.query.objectfilter.impl.syntax.OrExpr;
import org.infinispan.query.objectfilter.impl.syntax.PropertyValueExpr;
import org.infinispan.query.objectfilter.impl.syntax.SpatialWithinBoxExpr;
import org.infinispan.query.objectfilter.impl.syntax.SpatialWithinCircleExpr;
import org.infinispan.query.objectfilter.impl.syntax.SpatialWithinPolygonExpr;
import org.infinispan.query.objectfilter.impl.syntax.ValueExpr;
import org.infinispan.query.objectfilter.impl.syntax.parser.AggregationPropertyPath;
import org.infinispan.query.objectfilter.impl.syntax.parser.ObjectPropertyHelper;
import org.infinispan.query.objectfilter.impl.syntax.parser.TypeDescriptor;
import org.jboss.logging.Logger;

final class ExpressionBuilder<TypeMetadata> {
    private static final Log log = (Log)Logger.getMessageLogger((MethodHandles.Lookup)MethodHandles.lookup(), Log.class, (String)ExpressionBuilder.class.getName());
    private final ObjectPropertyHelper<TypeMetadata> propertyHelper;
    private TypeMetadata entityType;
    private final Map<String, NestedExpr> nestedExprMap = new HashMap<String, NestedExpr>();
    private final Deque<LazyBooleanExpr> stack = new ArrayDeque<LazyBooleanExpr>();

    ExpressionBuilder(ObjectPropertyHelper<TypeMetadata> propertyHelper) {
        this.propertyHelper = propertyHelper;
    }

    public void setEntityType(TypeMetadata entityType) {
        this.entityType = entityType;
        this.stack.push(new LazyRootBooleanExpr());
    }

    public void addFullTextTerm(PropertyPath<?> propertyPath, Object comparisonObject, Integer fuzzySlop) {
        this.push(new FullTextTermExpr(this.makePropertyValueExpr(propertyPath), comparisonObject, fuzzySlop));
    }

    public void addFullTextRegexp(PropertyPath<?> propertyPath, String regexp) {
        this.push(new FullTextRegexpExpr(this.makePropertyValueExpr(propertyPath), regexp));
    }

    public void addFullTextRange(PropertyPath<?> propertyPath, boolean includeLower, Object lower, Object upper, boolean includeUpper) {
        this.push(new FullTextRangeExpr(this.makePropertyValueExpr(propertyPath), includeLower, lower, upper, includeUpper));
    }

    public void addKnnPredicate(PropertyPath<?> propertyPath, Class<?> expectedType, List<Object> vector, Object knn) {
        this.push(new KnnPredicate((ValueExpr)this.makePropertyValueExpr(propertyPath), expectedType, vector, knn));
    }

    public void addKnnPredicate(PropertyPath<?> propertyPath, Class<?> expectedType, ConstantValueExpr.ParamPlaceholder vector, Object knn) {
        this.push(new KnnPredicate((ValueExpr)this.makePropertyValueExpr(propertyPath), expectedType, vector, knn));
    }

    public void addComparison(PropertyPath<?> propertyPath, ComparisonExpr.Type comparisonType, Object value) {
        Comparable typedValue = (Comparable)this.propertyHelper.convertToBackendType(this.entityType, propertyPath.asArrayPath(), value);
        ComparisonExpr comparisonExpr = new ComparisonExpr(this.makePropertyValueExpr(propertyPath), new ConstantValueExpr(typedValue), comparisonType);
        this.push(comparisonExpr);
    }

    public void addNestedComparison(PropertyPath<?> propertyPath, ComparisonExpr.Type comparisonType, Object value, String joinAlias, PropertyPath<TypeDescriptor<TypeMetadata>> embeddedPath) {
        if (!this.propertyHelper.isNestedIndexStructure(this.entityType, embeddedPath.getNodeNamesWithoutAlias().toArray(Util.EMPTY_STRING_ARRAY))) {
            log.warn("NestedExpr currently only supported on NESTED embedded fields. Falling back to ComparisonExpr");
            this.addComparison(propertyPath, comparisonType, value);
            return;
        }
        Comparable typedValue = (Comparable)this.propertyHelper.convertToBackendType(this.entityType, propertyPath.asArrayPath(), value);
        ComparisonExpr comparisonExpr = new ComparisonExpr(this.makePropertyValueExpr(propertyPath), new ConstantValueExpr(typedValue), comparisonType);
        if (!this.nestedExprMap.containsKey(joinAlias)) {
            this.nestedExprMap.put(joinAlias, new NestedExpr(this.getNestedPath(propertyPath), new BooleanExpr[0]));
            this.push(this.nestedExprMap.get(joinAlias));
        } else if (this.stack.peek() instanceof LazyNegationExpr) {
            this.push(this.nestedExprMap.get(joinAlias));
        }
        this.nestedExprMap.get(joinAlias).add(comparisonExpr);
    }

    private String getNestedPath(PropertyPath<?> propertyPath) {
        String stringPath;
        return stringPath.substring(0, (stringPath = propertyPath.asStringPath()).contains(".") ? stringPath.lastIndexOf(".") : stringPath.length());
    }

    public void addRange(PropertyPath<?> propertyPath, Object lower, Object upper) {
        Comparable lowerValue = (Comparable)this.propertyHelper.convertToBackendType(this.entityType, propertyPath.asArrayPath(), lower);
        Comparable upperValue = (Comparable)this.propertyHelper.convertToBackendType(this.entityType, propertyPath.asArrayPath(), upper);
        this.push(new BetweenExpr(this.makePropertyValueExpr(propertyPath), new ConstantValueExpr(lowerValue), new ConstantValueExpr(upperValue)));
    }

    public void addSpatialWithinCircle(PropertyPath<?> propertyPath, Object lat, Object lon, Object radius, Object unit) {
        this.push(new SpatialWithinCircleExpr(this.makePropertyValueExpr(propertyPath), new ConstantValueExpr((Comparable)lat), new ConstantValueExpr((Comparable)lon), new ConstantValueExpr((Comparable)radius), new ConstantValueExpr((Comparable)unit)));
    }

    public void addSpatialWithinBox(PropertyPath<?> propertyPath, Object tlLat, Object tlLon, Object brLat, Object brLon) {
        this.push(new SpatialWithinBoxExpr(this.makePropertyValueExpr(propertyPath), new ConstantValueExpr((Comparable)tlLat), new ConstantValueExpr((Comparable)tlLon), new ConstantValueExpr((Comparable)brLat), new ConstantValueExpr((Comparable)brLon)));
    }

    public void addSpatialWithinPolygon(PropertyPath<?> propertyPath, List<Object> vector) {
        this.push(new SpatialWithinPolygonExpr(this.makePropertyValueExpr(propertyPath), vector.stream().map(item -> new ConstantValueExpr((Comparable)item)).toList()));
    }

    public void addIn(PropertyPath<?> propertyPath, List<Object> values) {
        PropertyValueExpr valueExpr = this.makePropertyValueExpr(propertyPath);
        ArrayList<BooleanExpr> children = new ArrayList<BooleanExpr>(values.size());
        for (Object element : values) {
            Comparable typedValue = (Comparable)this.propertyHelper.convertToBackendType(this.entityType, propertyPath.asArrayPath(), element);
            ComparisonExpr booleanExpr = new ComparisonExpr(valueExpr, new ConstantValueExpr(typedValue), ComparisonExpr.Type.EQUAL);
            children.add(booleanExpr);
        }
        if (children.size() == 1) {
            this.push((BooleanExpr)children.get(0));
        } else {
            this.push(new OrExpr(children));
        }
    }

    public void addLike(PropertyPath<?> propertyPath, Object patternValue, Character escapeCharacter) {
        this.push(new LikeExpr(this.makePropertyValueExpr(propertyPath), patternValue));
    }

    public void addIsNull(PropertyPath<?> propertyPath) {
        this.push(new IsNullExpr(this.makePropertyValueExpr(propertyPath)));
    }

    public void pushAnd() {
        this.push(new LazyAndExpr());
    }

    public void pushOr() {
        this.push(new LazyOrExpr());
    }

    public void pushNot() {
        this.push(new LazyNegationExpr());
    }

    public void pushFullTextBoost(float boost) {
        this.push(new LazyFTBoostExpr(boost));
    }

    public void pushFullTextOccur(QueryRendererDelegate.Occur occur) {
        this.push(new LazyFTOccurExpr(occur));
    }

    private void push(BooleanExpr expr) {
        this.push(new LazyLeafBooleanExpr(expr));
    }

    private void push(LazyBooleanExpr expr) {
        this.stack.peek().addChild(expr);
        if (expr.isParent()) {
            this.stack.push(expr);
        }
    }

    public void pop() {
        this.stack.pop();
        if (!this.nestedExprMap.isEmpty() && this.stack.peek() instanceof LazyOrExpr) {
            this.nestedExprMap.clear();
        }
    }

    public BooleanExpr build() {
        return this.stack.getFirst().get();
    }

    private PropertyValueExpr makePropertyValueExpr(PropertyPath<?> propertyPath) {
        boolean isRepeated = this.propertyHelper.isRepeatedProperty(this.entityType, propertyPath.asArrayPath());
        Class<?> primitiveType = this.propertyHelper.getPrimitivePropertyType(this.entityType, propertyPath.asArrayPath());
        if (propertyPath instanceof AggregationPropertyPath) {
            return new AggregationExpr((AggregationPropertyPath)propertyPath, isRepeated, primitiveType);
        }
        return new PropertyValueExpr(propertyPath, isRepeated, primitiveType);
    }

    public void addConstantBoolean(boolean booleanConstant) {
        this.push(ConstantBooleanExpr.forBoolean(booleanConstant));
    }

    private static final class LazyRootBooleanExpr
    extends LazyBooleanExpr {
        private LazyBooleanExpr child;

        private LazyRootBooleanExpr() {
        }

        @Override
        public void addChild(LazyBooleanExpr child) {
            if (this.child != null) {
                throw log.getNotMoreThanOnePredicateInRootOfWhereClauseAllowedException(child);
            }
            this.child = child;
        }

        @Override
        public BooleanExpr get() {
            return this.child == null ? null : this.child.get();
        }
    }

    private static final class LazyNegationExpr
    extends LazyBooleanExpr {
        private LazyBooleanExpr child;

        private LazyNegationExpr() {
        }

        @Override
        public void addChild(LazyBooleanExpr child) {
            if (this.child != null) {
                throw log.getNotMoreThanOnePredicateInNegationAllowedException(child);
            }
            this.child = child;
        }

        public LazyBooleanExpr getChild() {
            return this.child;
        }

        @Override
        public BooleanExpr get() {
            return new NotExpr(this.getChild().get());
        }
    }

    private static final class LazyAndExpr
    extends LazyBooleanExpr {
        private final List<LazyBooleanExpr> children = new ArrayList<LazyBooleanExpr>(3);

        private LazyAndExpr() {
        }

        @Override
        public void addChild(LazyBooleanExpr child) {
            this.children.add(child);
        }

        @Override
        public BooleanExpr get() {
            if (this.children.isEmpty()) {
                throw new IllegalStateException("A conjunction must have at least one child");
            }
            BooleanExpr firstChild = this.children.get(0).get();
            if (this.children.size() == 1) {
                return firstChild;
            }
            AndExpr andExpr = new AndExpr(firstChild);
            for (int i = 1; i < this.children.size(); ++i) {
                BooleanExpr child = this.children.get(i).get();
                andExpr.getChildren().add(child);
            }
            return andExpr;
        }
    }

    static abstract class LazyBooleanExpr {
        LazyBooleanExpr() {
        }

        public boolean isParent() {
            return true;
        }

        public abstract void addChild(LazyBooleanExpr var1);

        public abstract BooleanExpr get();
    }

    private static final class LazyOrExpr
    extends LazyBooleanExpr {
        private final List<LazyBooleanExpr> children = new ArrayList<LazyBooleanExpr>(3);

        private LazyOrExpr() {
        }

        @Override
        public void addChild(LazyBooleanExpr child) {
            this.children.add(child);
        }

        @Override
        public BooleanExpr get() {
            if (this.children.isEmpty()) {
                throw new IllegalStateException("A disjunction must have at least one child");
            }
            BooleanExpr firstChild = this.children.get(0).get();
            if (this.children.size() == 1) {
                return firstChild;
            }
            OrExpr orExpr = new OrExpr(firstChild);
            for (int i = 1; i < this.children.size(); ++i) {
                BooleanExpr child = this.children.get(i).get();
                orExpr.getChildren().add(child);
            }
            return orExpr;
        }
    }

    private static final class LazyFTBoostExpr
    extends LazyBooleanExpr {
        private LazyBooleanExpr child;
        private final float boost;

        LazyFTBoostExpr(float boost) {
            this.boost = boost;
        }

        @Override
        public void addChild(LazyBooleanExpr child) {
            if (this.child != null) {
                throw log.getNotMoreThanOnePredicateInNegationAllowedException(child);
            }
            this.child = child;
        }

        public LazyBooleanExpr getChild() {
            return this.child;
        }

        @Override
        public BooleanExpr get() {
            return new FullTextBoostExpr(this.getChild().get(), this.boost);
        }
    }

    private static final class LazyFTOccurExpr
    extends LazyBooleanExpr {
        private LazyBooleanExpr child;
        private final QueryRendererDelegate.Occur occur;

        LazyFTOccurExpr(QueryRendererDelegate.Occur occur) {
            this.occur = occur;
        }

        @Override
        public void addChild(LazyBooleanExpr child) {
            if (this.child != null) {
                throw log.getNotMoreThanOnePredicateInNegationAllowedException(child);
            }
            this.child = child;
        }

        public LazyBooleanExpr getChild() {
            return this.child;
        }

        @Override
        public BooleanExpr get() {
            return new FullTextOccurExpr(this.getChild().get(), this.occur);
        }
    }

    private static final class LazyLeafBooleanExpr
    extends LazyBooleanExpr {
        private final BooleanExpr booleanExpr;

        LazyLeafBooleanExpr(BooleanExpr booleanExpr) {
            this.booleanExpr = booleanExpr;
        }

        @Override
        public boolean isParent() {
            return false;
        }

        @Override
        public void addChild(LazyBooleanExpr child) {
            throw new UnsupportedOperationException("Adding a sub-expression to a non-parent expression is illegal");
        }

        @Override
        public BooleanExpr get() {
            return this.booleanExpr;
        }
    }
}

