/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.objectfilter.impl.aggregation;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.infinispan.query.objectfilter.impl.aggregation.Counter;
import org.infinispan.query.objectfilter.impl.aggregation.DoubleStat;
import org.infinispan.query.objectfilter.impl.aggregation.FieldAccumulator;

final class SumAccumulator
extends FieldAccumulator {
    private final Class<? extends Number> fieldType;

    SumAccumulator(int inPos, int outPos, Class<?> fieldType) {
        super(inPos, outPos);
        if (!Number.class.isAssignableFrom(fieldType)) {
            throw new IllegalStateException("Aggregation SUM cannot be applied to property of type " + fieldType.getName());
        }
        this.fieldType = fieldType;
    }

    @Override
    public void init(Object[] accRow) {
        if (this.fieldType == Double.class || this.fieldType == Float.class) {
            accRow[this.outPos] = new DoubleStat();
        }
    }

    @Override
    public void update(Object[] accRow, Object val) {
        if (val != null) {
            Number value = (Number)val;
            if (this.fieldType == Double.class || this.fieldType == Float.class) {
                ((DoubleStat)accRow[this.outPos]).update(value.doubleValue());
            } else if (this.fieldType == Long.class || this.fieldType == Integer.class || this.fieldType == Byte.class || this.fieldType == Short.class) {
                value = value.longValue();
                Number sum = (Number)accRow[this.outPos];
                if (sum != null) {
                    value = this.fieldType == Long.class ? (Number)(sum.longValue() + value.longValue()) : (Number)(this.fieldType == BigInteger.class ? ((BigInteger)sum).add((BigInteger)value) : (this.fieldType == BigDecimal.class ? ((BigDecimal)sum).add((BigDecimal)value) : Integer.valueOf(sum.intValue() + value.intValue())));
                }
                accRow[this.outPos] = value;
            }
        }
    }

    @Override
    protected void merge(Object[] accRow, Object value) {
        if (value instanceof DoubleStat) {
            value = ((DoubleStat)value).getSum();
        } else if (value instanceof Counter) {
            value = ((Counter)value).getValue();
        }
        this.update(accRow, value);
    }

    @Override
    protected void finish(Object[] accRow) {
        if (this.fieldType == Double.class || this.fieldType == Float.class) {
            accRow[this.outPos] = ((DoubleStat)accRow[this.outPos]).getSum();
        }
    }

    static Class<?> getOutputType(Class<?> fieldType) {
        if (!Number.class.isAssignableFrom(fieldType)) {
            throw new IllegalStateException("Aggregation SUM cannot be applied to property of type " + fieldType.getName());
        }
        if (fieldType == Double.class || fieldType == Float.class) {
            return Double.class;
        }
        if (fieldType == Long.class || fieldType == Integer.class || fieldType == Byte.class || fieldType == Short.class) {
            return Long.class;
        }
        return fieldType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        SumAccumulator other = (SumAccumulator)o;
        return this.inPos == other.inPos && this.outPos == other.outPos && this.fieldType == other.fieldType;
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + this.fieldType.hashCode();
    }
}

