/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.objectfilter.impl.syntax.parser;

import org.infinispan.query.objectfilter.impl.syntax.parser.EntityNameResolver;

public final class ReflectionEntityNamesResolver
implements EntityNameResolver<Class<?>> {
    private final ClassLoader[] classLoaders;

    public ReflectionEntityNamesResolver(ClassLoader userClassLoader) {
        this.classLoaders = new ClassLoader[]{userClassLoader, ClassLoader.getSystemClassLoader(), Thread.currentThread().getContextClassLoader()};
    }

    @Override
    public Class<?> resolve(String entityName) {
        for (ClassLoader cl : this.classLoaders) {
            try {
                return cl != null ? Class.forName(entityName, true, cl) : Class.forName(entityName);
            }
            catch (ClassNotFoundException | NoClassDefFoundError throwable) {
            }
        }
        return null;
    }
}

