/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.objectfilter.impl.syntax;

import java.util.Collections;
import java.util.List;
import org.infinispan.query.objectfilter.impl.syntax.BooleanExpr;
import org.infinispan.query.objectfilter.impl.syntax.BooleanOperatorExpr;
import org.infinispan.query.objectfilter.impl.syntax.Visitor;

public class NestedExpr
extends BooleanOperatorExpr {
    private final String nestedPath;

    @Override
    public void appendQueryString(StringBuilder sb) {
        sb.append("NESTED ( ");
        for (int i = 0; i < this.children.size(); ++i) {
            if (i != 0) {
                sb.append(" AND ");
            }
            sb.append('(');
            ((BooleanExpr)this.children.get(i)).appendQueryString(sb);
            sb.append(')');
        }
        sb.append(" ) ");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("NESTED(");
        boolean isFirst = true;
        for (BooleanExpr c : this.children) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            sb.append(c);
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    public <T> T acceptVisitor(Visitor<?, ?> visitor) {
        return (T)visitor.visit(this);
    }

    public NestedExpr(String nestedPath, BooleanExpr ... nestedChildExpressions) {
        super(new BooleanExpr[0]);
        this.nestedPath = nestedPath;
        Collections.addAll(this.children, nestedChildExpressions);
    }

    public List<BooleanExpr> getNestedChildren() {
        return this.children;
    }

    public String getNestedPath() {
        return this.nestedPath;
    }

    public void add(BooleanExpr expr) {
        this.children.add(expr);
    }
}

