/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl.massindex;

import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import org.hibernate.search.engine.common.EntityReference;
import org.hibernate.search.engine.reporting.EntityIndexingFailureContext;
import org.hibernate.search.engine.reporting.FailureHandler;
import org.hibernate.search.util.common.SearchException;
import org.infinispan.commons.time.TimeService;
import org.infinispan.query.core.impl.Log;
import org.infinispan.query.impl.massindex.MassIndexerProgressMonitor;
import org.infinispan.query.mapper.common.impl.EntityReferenceImpl;
import org.infinispan.query.mapper.mapping.SearchMapping;
import org.infinispan.util.logging.LogFactory;

class MassIndexerProgressNotifier {
    private static final Log log = (Log)LogFactory.getLog(MassIndexerProgressNotifier.class, Log.class);
    private final MassIndexerProgressMonitor monitor;
    private final SearchMapping searchMapping;
    private final AtomicReference<RecordedEntityIndexingFailure> entityIndexingFirstFailure = new AtomicReference<Object>(null);
    private final LongAdder entityIndexingFailureCount = new LongAdder();
    private FailureHandler failureHandler;

    MassIndexerProgressNotifier(SearchMapping searchMapping, TimeService timeService) {
        this.monitor = new MassIndexerProgressMonitor(timeService);
        this.searchMapping = searchMapping;
    }

    void notifyPreIndexingReloading() {
        this.monitor.preIndexingReloading();
    }

    void notifyIndexingStarting() {
        this.monitor.indexingStarting();
    }

    void notifyDocumentsAdded(int size) {
        this.monitor.documentsAdded(size);
    }

    void notifyIndexingCompletedSuccessfully() {
        this.monitor.indexingCompleted();
        SearchException entityIndexingException = this.createEntityIndexingExceptionOrNull();
        if (entityIndexingException != null) {
            throw entityIndexingException;
        }
    }

    <T> void notifyEntityIndexingFailure(Class<T> type, Object id, Throwable throwable) {
        RecordedEntityIndexingFailure recordedFailure = new RecordedEntityIndexingFailure(throwable);
        this.entityIndexingFirstFailure.compareAndSet(null, recordedFailure);
        this.entityIndexingFailureCount.increment();
        EntityIndexingFailureContext.Builder contextBuilder = EntityIndexingFailureContext.builder();
        contextBuilder.throwable(throwable);
        contextBuilder.failingOperation((Object)log.massIndexerIndexingInstance(type.getSimpleName()));
        EntityReference entityReference = EntityReferenceImpl.withDefaultName(type, id);
        contextBuilder.entityReference((Object)entityReference);
        recordedFailure.entityReference = entityReference;
        if (this.failureHandler == null) {
            this.failureHandler = this.searchMapping.getFailureHandler();
        }
        this.failureHandler.handle(contextBuilder.build());
    }

    private SearchException createEntityIndexingExceptionOrNull() {
        RecordedEntityIndexingFailure firstFailure = this.entityIndexingFirstFailure.get();
        if (firstFailure == null) {
            return null;
        }
        return new SearchException(log.massIndexingEntityFailures(this.entityIndexingFailureCount.longValue(), firstFailure.entityReference, firstFailure.throwable.getMessage()), firstFailure.throwable);
    }

    private static class RecordedEntityIndexingFailure {
        private final Throwable throwable;
        private EntityReference entityReference;

        RecordedEntityIndexingFailure(Throwable throwable) {
            this.throwable = throwable;
        }
    }
}

