/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded.impl;

import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.sort.SearchSort;
import org.infinispan.query.dsl.embedded.impl.InfinispanAggregation;
import org.infinispan.query.dsl.embedded.impl.SearchProjectionInfo;
import org.infinispan.query.dsl.embedded.impl.SearchQueryBuilder;
import org.infinispan.query.mapper.scope.SearchScope;
import org.infinispan.query.mapper.session.SearchSession;

public final class SearchQueryParsingResult {
    private final Class<?> targetedType;
    private final String targetedTypeName;
    private final SearchProjectionInfo projectionInfo;
    private final InfinispanAggregation<?> aggregation;
    private final SearchPredicate predicate;
    private final SearchSort sort;
    private final int hitCountAccuracy;
    private final Integer knn;

    public SearchQueryParsingResult(Class<?> targetedType, String targetedTypeName, SearchProjectionInfo projectionInfo, InfinispanAggregation<?> aggregation, SearchPredicate predicate, SearchSort sort, int hitCountAccuracy, Integer knn) {
        this.targetedType = targetedType;
        this.targetedTypeName = targetedTypeName;
        this.projectionInfo = projectionInfo;
        this.aggregation = aggregation;
        this.predicate = predicate;
        this.sort = sort;
        this.hitCountAccuracy = hitCountAccuracy;
        this.knn = knn;
    }

    public SearchQueryBuilder builder(SearchSession querySession) {
        SearchScope<?> scope = this.getScope(querySession);
        return new SearchQueryBuilder(querySession, scope, this.projectionInfo, this.aggregation, this.predicate, this.sort, this.hitCountAccuracy, this.knn);
    }

    private SearchScope<?> getScope(SearchSession querySession) {
        return this.targetedTypeName == null ? querySession.scope(this.targetedType) : querySession.scope(this.targetedType, this.targetedTypeName);
    }
}

