/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.objectfilter.impl.syntax;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.infinispan.query.objectfilter.impl.syntax.ConstantValueExpr;
import org.infinispan.query.objectfilter.impl.syntax.PrimaryPredicateExpr;
import org.infinispan.query.objectfilter.impl.syntax.ValueExpr;
import org.infinispan.query.objectfilter.impl.syntax.Visitor;

public final class KnnPredicate
implements PrimaryPredicateExpr {
    private final ValueExpr leftChild;
    private final Class<?> expectedType;
    private final List<Object> vector;
    private final ConstantValueExpr.ParamPlaceholder vectorParam;
    private final Object knn;

    public KnnPredicate(ValueExpr leftChild, Class<?> expectedType, List<Object> vector, Object knn) {
        this.leftChild = leftChild;
        this.expectedType = expectedType;
        this.vector = vector;
        this.vectorParam = null;
        this.knn = knn;
    }

    public KnnPredicate(ValueExpr leftChild, Class<?> expectedType, ConstantValueExpr.ParamPlaceholder vector, Object knn) {
        this.leftChild = leftChild;
        this.expectedType = expectedType;
        this.vector = null;
        this.vectorParam = vector;
        this.knn = knn;
    }

    @Override
    public <T> T acceptVisitor(Visitor<?, ?> visitor) {
        return (T)visitor.visit(this);
    }

    @Override
    public ValueExpr getChild() {
        return this.leftChild;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendQueryString(sb);
        return sb.toString();
    }

    @Override
    public void appendQueryString(StringBuilder sb) {
        this.leftChild.appendQueryString(sb);
        sb.append(" <-> ").append(this.vector != null ? this.vector : "[" + String.valueOf(this.vectorParam) + "]").append('~').append(this.knn);
    }

    public Integer knn(Map<String, Object> namedParameters) {
        if (this.knn == null) {
            return null;
        }
        return this.convertToInt(this.knn, namedParameters);
    }

    public boolean floats() {
        return this.expectedType == float[].class || this.expectedType == Float.class;
    }

    public byte[] bytesArray(Map<String, Object> namedParameters) {
        if (this.vector != null) {
            byte[] result = new byte[this.vector.size()];
            for (int i = 0; i < this.vector.size(); ++i) {
                result[i] = this.convertToByte(this.vector.get(i), namedParameters);
            }
            return result;
        }
        String paramName = this.vectorParam.getName();
        Object value = namedParameters.get(paramName);
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        throw new IllegalStateException("Wrong parameter type. Param: " + paramName + ". Required type: byte[].");
    }

    public float[] floatsArray(Map<String, Object> namedParameters) {
        if (this.vector != null) {
            float[] result = new float[this.vector.size()];
            for (int i = 0; i < this.vector.size(); ++i) {
                result[i] = this.convertToFloat(this.vector.get(i), namedParameters);
            }
            return result;
        }
        String paramName = this.vectorParam.getName();
        Object value = namedParameters.get(paramName);
        if (value instanceof float[]) {
            return (float[])value;
        }
        throw new IllegalStateException("Wrong parameter type. Param: " + paramName + ". Required type: float[].");
    }

    private int convertToInt(Object valueOrParam, Map<String, Object> namedParameters) {
        return this.convertValue(valueOrParam, namedParameters, Integer::parseInt, Number::intValue);
    }

    private byte convertToByte(Object valueOrParam, Map<String, Object> namedParameters) {
        return this.convertValue(valueOrParam, namedParameters, Byte::parseByte, Number::byteValue);
    }

    private float convertToFloat(Object valueOrParam, Map<String, Object> namedParameters) {
        return this.convertValue(valueOrParam, namedParameters, Float::parseFloat, Number::floatValue).floatValue();
    }

    private <T> T convertValue(Object valueOrParam, Map<String, Object> namedParameters, Function<String, T> parse, Function<Number, T> convert) {
        if (valueOrParam == null) {
            throw new IllegalStateException("Missing value or parameter");
        }
        Object value = null;
        String paramName = null;
        if (valueOrParam instanceof String) {
            value = valueOrParam;
        }
        if (valueOrParam instanceof ConstantValueExpr.ParamPlaceholder) {
            ConstantValueExpr.ParamPlaceholder param = (ConstantValueExpr.ParamPlaceholder)valueOrParam;
            paramName = param.getName();
            value = namedParameters.get(paramName);
        }
        if (value instanceof Number) {
            return convert.apply((Number)value);
        }
        if (valueOrParam instanceof String) {
            return parse.apply((String)valueOrParam);
        }
        if (value == null) {
            throw new IllegalStateException("Missing value for parameter " + paramName);
        }
        throw new IllegalStateException("Parameter must be a number or a string" + paramName);
    }
}

