/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.query.BaseQuery;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.query.clustered.DistributedIndexedQueryImpl;
import org.infinispan.query.core.impl.AggregatingQuery;
import org.infinispan.query.core.impl.EmbeddedQuery;
import org.infinispan.query.core.impl.EmptyResultQuery;
import org.infinispan.query.core.impl.HybridQuery;
import org.infinispan.query.core.impl.Log;
import org.infinispan.query.core.impl.MetadataHybridQuery;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.embedded.impl.EmbeddedLuceneQuery;
import org.infinispan.query.dsl.embedded.impl.ObjectReflectionMatcher;
import org.infinispan.query.dsl.embedded.impl.QueryAnalyzer;
import org.infinispan.query.dsl.embedded.impl.SearchQueryBuilder;
import org.infinispan.query.dsl.embedded.impl.SearchQueryMaker;
import org.infinispan.query.dsl.embedded.impl.SearchQueryParsingResult;
import org.infinispan.query.impl.ComponentRegistryUtils;
import org.infinispan.query.impl.IndexedQuery;
import org.infinispan.query.impl.IndexedQueryImpl;
import org.infinispan.query.impl.QueryDefinition;
import org.infinispan.query.mapper.mapping.SearchMapping;
import org.infinispan.query.objectfilter.Matcher;
import org.infinispan.query.objectfilter.SortField;
import org.infinispan.query.objectfilter.impl.RowMatcher;
import org.infinispan.query.objectfilter.impl.aggregation.FieldAccumulator;
import org.infinispan.query.objectfilter.impl.ql.AggregationFunction;
import org.infinispan.query.objectfilter.impl.ql.PropertyPath;
import org.infinispan.query.objectfilter.impl.syntax.AggregationExpr;
import org.infinispan.query.objectfilter.impl.syntax.AndExpr;
import org.infinispan.query.objectfilter.impl.syntax.BooleShannonExpansion;
import org.infinispan.query.objectfilter.impl.syntax.BooleanExpr;
import org.infinispan.query.objectfilter.impl.syntax.ComparisonExpr;
import org.infinispan.query.objectfilter.impl.syntax.ConstantBooleanExpr;
import org.infinispan.query.objectfilter.impl.syntax.ConstantValueExpr;
import org.infinispan.query.objectfilter.impl.syntax.ExprVisitor;
import org.infinispan.query.objectfilter.impl.syntax.IndexedFieldProvider;
import org.infinispan.query.objectfilter.impl.syntax.IndexedSearchPredicateDetector;
import org.infinispan.query.objectfilter.impl.syntax.IsNullExpr;
import org.infinispan.query.objectfilter.impl.syntax.LikeExpr;
import org.infinispan.query.objectfilter.impl.syntax.NotExpr;
import org.infinispan.query.objectfilter.impl.syntax.OrExpr;
import org.infinispan.query.objectfilter.impl.syntax.PropertyValueExpr;
import org.infinispan.query.objectfilter.impl.syntax.SyntaxTreePrinter;
import org.infinispan.query.objectfilter.impl.syntax.ValueExpr;
import org.infinispan.query.objectfilter.impl.syntax.parser.AggregationPropertyPath;
import org.infinispan.query.objectfilter.impl.syntax.parser.IckleParsingResult;
import org.infinispan.query.objectfilter.impl.syntax.parser.ObjectPropertyHelper;
import org.infinispan.query.objectfilter.impl.syntax.parser.RowPropertyHelper;
import org.infinispan.util.function.SerializableFunction;
import org.infinispan.util.logging.LogFactory;

public class QueryEngine<TypeMetadata>
extends org.infinispan.query.core.impl.QueryEngine<TypeMetadata> {
    private static final Log log = (Log)LogFactory.getLog(QueryEngine.class, Log.class);
    private static final int MAX_EXPANSION_COFACTORS = 16;
    public static final String DEFAULT_ALIAS = "_gen0";
    protected final boolean isIndexed;
    private SearchMapping searchMapping;
    private static final SerializableFunction<AdvancedCache<?, ?>, QueryEngine<?>> queryEngineProvider = (SerializableFunction & Serializable)c -> (QueryEngine)ComponentRegistry.componentOf((Cache)c, QueryEngine.class);
    private final boolean broadcastQuery;
    private final int defaultMaxResults;
    private final int defaultHitCountAccuracy;
    private final QueryAnalyzer<TypeMetadata> queryAnalyzer;

    public QueryEngine(AdvancedCache<?, ?> cache, boolean isIndexed) {
        this(cache, isIndexed, ObjectReflectionMatcher.class);
    }

    protected QueryEngine(AdvancedCache<?, ?> cache, boolean isIndexed, Class<? extends Matcher> matcherImplClass) {
        super(cache, matcherImplClass);
        Configuration configuration = cache.getCacheConfiguration();
        CacheMode cacheMode = configuration.clustering().cacheMode();
        this.broadcastQuery = cacheMode.isClustered() && !cacheMode.isReplicated();
        this.isIndexed = isIndexed;
        this.defaultMaxResults = configuration.query().defaultMaxResults();
        this.defaultHitCountAccuracy = configuration.query().hitCountAccuracy();
        this.queryAnalyzer = new QueryAnalyzer<TypeMetadata>(this.getPropertyHelper());
    }

    protected SearchMapping getSearchMapping() {
        if (this.searchMapping == null) {
            this.searchMapping = ComponentRegistryUtils.getSearchMapping(this.cache);
        }
        return this.searchMapping;
    }

    public Class<? extends Matcher> getMatcherClass() {
        return this.matcherImplClass;
    }

    ObjectPropertyHelper<TypeMetadata> getPropertyHelper() {
        return this.propertyHelper;
    }

    @Override
    protected BaseQuery<?> buildQueryWithAggregations(String queryString, Map<String, Object> namedParameters, long startOffset, int maxResults, IckleParsingResult<TypeMetadata> parsingResult, boolean local) {
        int idx;
        Class<?> propertyType;
        if (parsingResult.getProjectedPaths() == null) {
            throw Log.CONTAINER.groupingAndAggregationQueriesMustUseProjections();
        }
        if (this.queryAnalyzer.fullIndexingAggregation(parsingResult)) {
            return this.buildQueryWithNativeAggregations(namedParameters, startOffset, maxResults, parsingResult, local);
        }
        LinkedHashMap<PropertyPath, RowPropertyHelper.ColumnMetadata> columns = new LinkedHashMap<PropertyPath, RowPropertyHelper.ColumnMetadata>();
        if (parsingResult.getGroupBy() != null) {
            for (PropertyPath<?> p : parsingResult.getGroupBy()) {
                if (p instanceof AggregationPropertyPath) {
                    throw Log.CONTAINER.cannotHaveAggregationsInGroupByClause();
                }
                if (columns.containsKey(p)) continue;
                if (this.propertyHelper.isRepeatedProperty(parsingResult.getTargetEntityMetadata(), p.asArrayPath())) {
                    throw Log.CONTAINER.multivaluedPropertyCannotBeUsedInGroupBy(p.toString());
                }
                propertyType = this.propertyHelper.getPrimitivePropertyType(parsingResult.getTargetEntityMetadata(), p.asArrayPath());
                idx = columns.size();
                columns.put(p, new RowPropertyHelper.ColumnMetadata(idx, "C" + idx, propertyType));
            }
        }
        int noOfGroupingColumns = columns.size();
        for (int i = 0; i < parsingResult.getProjectedPaths().length; ++i) {
            PropertyPath<?> p = parsingResult.getProjectedPaths()[i];
            RowPropertyHelper.ColumnMetadata c = (RowPropertyHelper.ColumnMetadata)columns.get(p);
            if (!(p instanceof AggregationPropertyPath || c != null && c.getColumnIndex() < noOfGroupingColumns)) {
                throw Log.CONTAINER.expressionMustBePartOfAggregateFunctionOrShouldBeIncludedInGroupByClause(p.toString());
            }
            if (c != null) continue;
            propertyType = FieldAccumulator.getOutputType(((AggregationPropertyPath)p).getAggregationFunction(), parsingResult.getProjectedTypes()[i]);
            idx = columns.size();
            columns.put(p, new RowPropertyHelper.ColumnMetadata(idx, "C" + idx, propertyType));
        }
        if (parsingResult.getSortFields() != null) {
            for (SortField sortField : parsingResult.getSortFields()) {
                PropertyPath<?> p = sortField.getPath();
                RowPropertyHelper.ColumnMetadata c = (RowPropertyHelper.ColumnMetadata)columns.get(p);
                if (!(p instanceof AggregationPropertyPath || c != null && c.getColumnIndex() < noOfGroupingColumns)) {
                    throw Log.CONTAINER.expressionMustBePartOfAggregateFunctionOrShouldBeIncludedInGroupByClause(p.toString());
                }
                if (c != null) continue;
                Class<?> propertyType2 = this.propertyHelper.getPrimitivePropertyType(parsingResult.getTargetEntityMetadata(), p.asArrayPath());
                int idx2 = columns.size();
                columns.put(p, new RowPropertyHelper.ColumnMetadata(idx2, "C" + idx2, propertyType2));
            }
        }
        String havingClause = null;
        if (parsingResult.getHavingClause() != null) {
            BooleanExpr normalizedHavingClause = booleanFilterNormalizer.normalize(parsingResult.getHavingClause());
            if (normalizedHavingClause == ConstantBooleanExpr.FALSE) {
                return new EmptyResultQuery(this.cache, queryString, parsingResult.getStatementType(), namedParameters, startOffset, maxResults, this.queryStatistics);
            }
            if (normalizedHavingClause != ConstantBooleanExpr.TRUE) {
                havingClause = SyntaxTreePrinter.printTree(this.swapVariables(normalizedHavingClause, parsingResult.getTargetEntityMetadata(), columns, namedParameters, this.propertyHelper));
            }
        }
        for (PropertyPath p : columns.keySet()) {
            if (!this.propertyHelper.isRepeatedProperty(parsingResult.getTargetEntityMetadata(), p.asArrayPath())) continue;
            return this.buildQueryWithRepeatedAggregations(queryString, namedParameters, startOffset, maxResults, parsingResult, havingClause, columns, noOfGroupingColumns, local);
        }
        LinkedHashMap<String, Integer> inColumns = new LinkedHashMap<String, Integer>();
        LinkedList<FieldAccumulator> accumulators = new LinkedList<FieldAccumulator>();
        RowPropertyHelper.ColumnMetadata[] _columns = new RowPropertyHelper.ColumnMetadata[columns.size()];
        for (PropertyPath p : columns.keySet()) {
            RowPropertyHelper.ColumnMetadata c = columns.get(p);
            _columns[c.getColumnIndex()] = c;
            String asStringPath = p.asStringPath();
            Integer inIdx = (Integer)inColumns.get(asStringPath);
            if (inIdx == null) {
                inIdx = inColumns.size();
                inColumns.put(asStringPath, inIdx);
            }
            if (!(p instanceof AggregationPropertyPath)) continue;
            FieldAccumulator acc = FieldAccumulator.makeAccumulator(((AggregationPropertyPath)p).getAggregationFunction(), inIdx, c.getColumnIndex(), c.getPropertyType());
            accumulators.add(acc);
        }
        StringBuilder firstPhaseQuery = new StringBuilder();
        firstPhaseQuery.append("SELECT ");
        boolean isFirst = true;
        for (String p : inColumns.keySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                firstPhaseQuery.append(", ");
            }
            firstPhaseQuery.append(DEFAULT_ALIAS).append('.').append(p);
        }
        firstPhaseQuery.append(" FROM ").append(parsingResult.getTargetEntityName()).append(' ').append(DEFAULT_ALIAS);
        if (parsingResult.getWhereClause() != null) {
            BooleanExpr normalizedWhereClause = booleanFilterNormalizer.normalize(parsingResult.getWhereClause());
            if (normalizedWhereClause == ConstantBooleanExpr.FALSE) {
                return new EmptyResultQuery(this.cache, queryString, parsingResult.getStatementType(), namedParameters, startOffset, maxResults, this.queryStatistics);
            }
            if (normalizedWhereClause != ConstantBooleanExpr.TRUE) {
                firstPhaseQuery.append(' ').append(SyntaxTreePrinter.printTree(normalizedWhereClause));
            }
        }
        StringBuilder secondPhaseQuery = new StringBuilder();
        secondPhaseQuery.append("SELECT ");
        for (int i = 0; i < parsingResult.getProjectedPaths().length; ++i) {
            PropertyPath<?> p = parsingResult.getProjectedPaths()[i];
            RowPropertyHelper.ColumnMetadata c = columns.get(p);
            if (i != 0) {
                secondPhaseQuery.append(", ");
            }
            secondPhaseQuery.append(c.getColumnName());
        }
        secondPhaseQuery.append(" FROM Row ");
        if (havingClause != null) {
            secondPhaseQuery.append(' ').append(havingClause);
        }
        if (parsingResult.getSortFields() != null) {
            secondPhaseQuery.append(" ORDER BY ");
            boolean isFirst2 = true;
            for (SortField sortField : parsingResult.getSortFields()) {
                if (isFirst2) {
                    isFirst2 = false;
                } else {
                    secondPhaseQuery.append(", ");
                }
                RowPropertyHelper.ColumnMetadata c = columns.get(sortField.getPath());
                secondPhaseQuery.append(c.getColumnName()).append(' ').append(sortField.isAscending() ? "ASC" : "DESC");
            }
        }
        String firstPhaseQueryStr = firstPhaseQuery.toString();
        BaseQuery<?> baseQuery = this.buildQueryNoAggregations(firstPhaseQueryStr, namedParameters, -1L, Integer.MAX_VALUE, this.parse(firstPhaseQueryStr), local);
        String secondPhaseQueryStr = secondPhaseQuery.toString();
        return new AggregatingQuery(this.cache, secondPhaseQueryStr, namedParameters, noOfGroupingColumns, accumulators, false, this.getObjectFilter(new RowMatcher(_columns), secondPhaseQueryStr, namedParameters, null), startOffset, maxResults, baseQuery, this.queryStatistics, local);
    }

    private EmbeddedLuceneQuery<TypeMetadata, Object> buildQueryWithNativeAggregations(Map<String, Object> namedParameters, long startOffset, int maxResults, IckleParsingResult<TypeMetadata> parsingResult, boolean local) {
        return new EmbeddedLuceneQuery(this, namedParameters, parsingResult, parsingResult.getProjections(), null, startOffset, maxResults, local);
    }

    private BooleanExpr swapVariables(BooleanExpr expr, final TypeMetadata targetEntityMetadata, final LinkedHashMap<PropertyPath, RowPropertyHelper.ColumnMetadata> columns, final Map<String, Object> namedParameters, final ObjectPropertyHelper<TypeMetadata> propertyHelper) {
        class PropertyReplacer
        extends ExprVisitor {
            final /* synthetic */ QueryEngine this$0;

            PropertyReplacer() {
                this.this$0 = this$0;
            }

            @Override
            public BooleanExpr visit(NotExpr notExpr) {
                return new NotExpr((BooleanExpr)notExpr.getChild().acceptVisitor(this));
            }

            @Override
            public BooleanExpr visit(OrExpr orExpr) {
                ArrayList<BooleanExpr> visitedChildren = new ArrayList<BooleanExpr>();
                for (BooleanExpr c : orExpr.getChildren()) {
                    visitedChildren.add((BooleanExpr)c.acceptVisitor(this));
                }
                return new OrExpr(visitedChildren);
            }

            @Override
            public BooleanExpr visit(AndExpr andExpr) {
                ArrayList<BooleanExpr> visitedChildren = new ArrayList<BooleanExpr>();
                for (BooleanExpr c : andExpr.getChildren()) {
                    visitedChildren.add((BooleanExpr)c.acceptVisitor(this));
                }
                return new AndExpr(visitedChildren);
            }

            @Override
            public BooleanExpr visit(ConstantBooleanExpr constantBooleanExpr) {
                return constantBooleanExpr;
            }

            @Override
            public BooleanExpr visit(IsNullExpr isNullExpr) {
                return new IsNullExpr((ValueExpr)isNullExpr.getChild().acceptVisitor(this));
            }

            @Override
            public BooleanExpr visit(ComparisonExpr comparisonExpr) {
                return new ComparisonExpr((ValueExpr)comparisonExpr.getLeftChild().acceptVisitor(this), comparisonExpr.getRightChild(), comparisonExpr.getComparisonType());
            }

            @Override
            public BooleanExpr visit(LikeExpr likeExpr) {
                return new LikeExpr((ValueExpr)likeExpr.getChild().acceptVisitor(this), likeExpr.getPattern(namedParameters));
            }

            @Override
            public ValueExpr visit(ConstantValueExpr constantValueExpr) {
                return constantValueExpr;
            }

            @Override
            public ValueExpr visit(PropertyValueExpr propertyValueExpr) {
                RowPropertyHelper.ColumnMetadata c = (RowPropertyHelper.ColumnMetadata)columns.get(propertyValueExpr.getPropertyPath());
                if (c == null) {
                    throw Log.CONTAINER.expressionMustBePartOfAggregateFunctionOrShouldBeIncludedInGroupByClause(propertyValueExpr.toQueryString());
                }
                return new PropertyValueExpr(c.getColumnName(), propertyValueExpr.isRepeated(), propertyValueExpr.getPrimitiveType());
            }

            @Override
            public ValueExpr visit(AggregationExpr aggregationExpr) {
                RowPropertyHelper.ColumnMetadata c = (RowPropertyHelper.ColumnMetadata)columns.get(aggregationExpr.getPropertyPath());
                if (c == null) {
                    Class<?> propertyType = propertyHelper.getPrimitivePropertyType(targetEntityMetadata, aggregationExpr.getPropertyPath().asArrayPath());
                    propertyType = FieldAccumulator.getOutputType(aggregationExpr.getAggregationType(), propertyType);
                    int idx = columns.size();
                    c = new RowPropertyHelper.ColumnMetadata(idx, "C" + idx, propertyType);
                    columns.put(aggregationExpr.getPropertyPath(), c);
                    return new PropertyValueExpr(c.getColumnName(), aggregationExpr.isRepeated(), propertyType);
                }
                return new PropertyValueExpr(c.getColumnName(), aggregationExpr.isRepeated(), aggregationExpr.getPrimitiveType());
            }
        }
        return (BooleanExpr)expr.acceptVisitor(new PropertyReplacer());
    }

    private BaseQuery<?> buildQueryWithRepeatedAggregations(String queryString, Map<String, Object> namedParameters, long startOffset, int maxResults, IckleParsingResult<TypeMetadata> parsingResult, String havingClause, LinkedHashMap<PropertyPath, RowPropertyHelper.ColumnMetadata> columns, int noOfGroupingColumns, boolean local) {
        StringBuilder firstPhaseQuery = new StringBuilder();
        firstPhaseQuery.append("FROM ").append(parsingResult.getTargetEntityName()).append(' ').append(DEFAULT_ALIAS);
        if (parsingResult.getWhereClause() != null) {
            BooleanExpr normalizedWhereClause = booleanFilterNormalizer.normalize(parsingResult.getWhereClause());
            if (normalizedWhereClause == ConstantBooleanExpr.FALSE) {
                return new EmptyResultQuery(this.cache, queryString, parsingResult.getStatementType(), namedParameters, startOffset, maxResults, this.queryStatistics);
            }
            if (normalizedWhereClause != ConstantBooleanExpr.TRUE) {
                firstPhaseQuery.append(' ').append(SyntaxTreePrinter.printTree(normalizedWhereClause));
            }
        }
        String firstPhaseQueryStr = firstPhaseQuery.toString();
        BaseQuery<?> baseQuery = this.buildQueryNoAggregations(firstPhaseQueryStr, namedParameters, -1L, -1, this.parse(firstPhaseQueryStr), local);
        LinkedList<FieldAccumulator> secondPhaseAccumulators = new LinkedList<FieldAccumulator>();
        LinkedList<FieldAccumulator> thirdPhaseAccumulators = new LinkedList<FieldAccumulator>();
        RowPropertyHelper.ColumnMetadata[] _columns = new RowPropertyHelper.ColumnMetadata[columns.size()];
        StringBuilder secondPhaseQuery = new StringBuilder();
        secondPhaseQuery.append("SELECT ");
        for (PropertyPath p : columns.keySet()) {
            RowPropertyHelper.ColumnMetadata c = columns.get(p);
            if (c.getColumnIndex() > 0) {
                secondPhaseQuery.append(", ");
            }
            if (p instanceof AggregationPropertyPath) {
                FieldAccumulator acc = FieldAccumulator.makeAccumulator(((AggregationPropertyPath)p).getAggregationFunction(), c.getColumnIndex(), c.getColumnIndex(), c.getPropertyType());
                if (this.propertyHelper.isRepeatedProperty(parsingResult.getTargetEntityMetadata(), p.asArrayPath())) {
                    secondPhaseAccumulators.add(acc);
                    if (((AggregationPropertyPath)p).getAggregationFunction() == AggregationFunction.COUNT) {
                        c = new RowPropertyHelper.ColumnMetadata(c.getColumnIndex(), c.getColumnName(), Long.class);
                        acc = FieldAccumulator.makeAccumulator(AggregationFunction.SUM, c.getColumnIndex(), c.getColumnIndex(), Long.class);
                    }
                } else {
                    secondPhaseAccumulators.add(null);
                }
                thirdPhaseAccumulators.add(acc);
            } else {
                secondPhaseAccumulators.add(null);
            }
            secondPhaseQuery.append(DEFAULT_ALIAS).append('.').append(p.asStringPath());
            _columns[c.getColumnIndex()] = c;
        }
        secondPhaseQuery.append(" FROM ").append(parsingResult.getTargetEntityName()).append(' ').append(DEFAULT_ALIAS);
        String secondPhaseQueryStr = secondPhaseQuery.toString();
        HybridQuery projectingAggregatingQuery = new HybridQuery((AdvancedCache<?, ?>)this.cache, secondPhaseQueryStr, parsingResult.getStatementType(), namedParameters, this.getObjectFilter(this.matcher, secondPhaseQueryStr, namedParameters, secondPhaseAccumulators), startOffset, maxResults, (org.infinispan.commons.api.query.Query<?>)baseQuery, this.queryStatistics, local, false);
        StringBuilder thirdPhaseQuery = new StringBuilder();
        thirdPhaseQuery.append("SELECT ");
        for (int i = 0; i < parsingResult.getProjectedPaths().length; ++i) {
            PropertyPath<?> p = parsingResult.getProjectedPaths()[i];
            RowPropertyHelper.ColumnMetadata c = columns.get(p);
            if (i != 0) {
                thirdPhaseQuery.append(", ");
            }
            thirdPhaseQuery.append(c.getColumnName());
        }
        thirdPhaseQuery.append(" FROM Row ");
        if (havingClause != null) {
            thirdPhaseQuery.append(' ').append(havingClause);
        }
        if (parsingResult.getSortFields() != null) {
            thirdPhaseQuery.append(" ORDER BY ");
            boolean isFirst = true;
            for (SortField sortField : parsingResult.getSortFields()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    thirdPhaseQuery.append(", ");
                }
                RowPropertyHelper.ColumnMetadata c = columns.get(sortField.getPath());
                thirdPhaseQuery.append(c.getColumnName()).append(' ').append(sortField.isAscending() ? "ASC" : "DESC");
            }
        }
        String thirdPhaseQueryStr = thirdPhaseQuery.toString();
        return new AggregatingQuery(this.cache, thirdPhaseQueryStr, namedParameters, noOfGroupingColumns, thirdPhaseAccumulators, true, this.getObjectFilter(new RowMatcher(_columns), thirdPhaseQueryStr, namedParameters, null), startOffset, maxResults, projectingAggregatingQuery, this.queryStatistics, local);
    }

    @Override
    protected BaseQuery<?> buildQueryNoAggregations(String queryString, Map<String, Object> namedParameters, long startOffset, int maxResults, IckleParsingResult<TypeMetadata> parsingResult, boolean local) {
        BooleShannonExpansion bse;
        BooleanExpr expansion;
        BooleanExpr normalizedWhereClause;
        if (parsingResult.hasGroupingOrAggregations()) {
            throw Log.CONTAINER.queryMustNotUseGroupingOrAggregation();
        }
        if (!this.isIndexed && parsingResult.getWhereClause() != null && IndexedSearchPredicateDetector.checkIndexingRequired(parsingResult.getWhereClause())) {
            throw new IllegalStateException("The cache must be indexed in order to use full-text or spatial queries.");
        }
        if (parsingResult.getSortFields() != null) {
            for (SortField sortField : parsingResult.getSortFields()) {
                PropertyPath<?> p = sortField.getPath();
                if (!this.propertyHelper.isRepeatedProperty(parsingResult.getTargetEntityMetadata(), p.asArrayPath())) continue;
                throw Log.CONTAINER.multivaluedPropertyCannotBeUsedInOrderBy(p.toString());
            }
        }
        if (parsingResult.getProjectedPaths() != null) {
            for (PropertyPath<?> p : parsingResult.getProjectedPaths()) {
                if (!this.propertyHelper.isRepeatedProperty(parsingResult.getTargetEntityMetadata(), p.asArrayPath())) continue;
                throw Log.CONTAINER.multivaluedPropertyCannotBeProjected(p.asStringPath());
            }
        }
        if ((normalizedWhereClause = booleanFilterNormalizer.normalize(parsingResult.getWhereClause())) == ConstantBooleanExpr.FALSE) {
            return new EmptyResultQuery(this.cache, queryString, parsingResult.getStatementType(), namedParameters, startOffset, maxResults, this.queryStatistics);
        }
        if (!this.isIndexed) {
            return new EmbeddedQuery(this, this.cache, queryString, parsingResult.getStatementType(), namedParameters, parsingResult.getProjections(), startOffset, maxResults, this.defaultMaxResults, this.queryStatistics, local);
        }
        IndexedFieldProvider.FieldIndexingMetadata fieldIndexingMetadata = this.propertyHelper.getIndexedFieldProvider().get(parsingResult.getTargetEntityMetadata());
        boolean allProjectionsAreStored = true;
        LinkedHashMap projectionsMap = null;
        if (parsingResult.getProjectedPaths() != null) {
            projectionsMap = new LinkedHashMap();
            for (int i = 0; i < parsingResult.getProjectedPaths().length; ++i) {
                PropertyPath<?> p = parsingResult.getProjectedPaths()[i];
                ArrayList<Integer> idx = (ArrayList<Integer>)projectionsMap.get(p);
                if (idx == null) {
                    idx = new ArrayList<Integer>();
                    projectionsMap.put(p, idx);
                    if (!fieldIndexingMetadata.isProjectable(p.asArrayPath())) {
                        allProjectionsAreStored = false;
                    }
                }
                idx.add(i);
            }
        }
        boolean allSortFieldsAreStored = true;
        SortField[] sortFields = parsingResult.getSortFields();
        if (sortFields != null) {
            LinkedHashMap<String, SortField> sortFieldMap = new LinkedHashMap<String, SortField>();
            for (SortField sf : sortFields) {
                PropertyPath<?> p = sf.getPath();
                String asStringPath = p.asStringPath();
                if (sortFieldMap.containsKey(asStringPath)) continue;
                sortFieldMap.put(asStringPath, sf);
                if (fieldIndexingMetadata.isSortable(p.asArrayPath())) continue;
                allSortFieldsAreStored = false;
            }
            sortFields = sortFieldMap.values().toArray(new SortField[sortFieldMap.size()]);
        }
        if ((expansion = (bse = new BooleShannonExpansion(16, fieldIndexingMetadata)).expand(normalizedWhereClause)) == normalizedWhereClause) {
            String projectionQueryStr;
            if (allSortFieldsAreStored) {
                if (allProjectionsAreStored) {
                    RowProcessor rowProcessor = null;
                    if (parsingResult.getProjectedPaths() != null) {
                        if (projectionsMap.size() != parsingResult.getProjectedPaths().length) {
                            Class[] projectedTypes = new Class[projectionsMap.size()];
                            Object[] deduplicatedProjectedNullMarkers = parsingResult.getProjectedNullMarkers() != null ? new Object[projectedTypes.length] : null;
                            int[] map = new int[parsingResult.getProjectedPaths().length];
                            int j = 0;
                            for (List idx : projectionsMap.values()) {
                                int i = (Integer)idx.get(0);
                                projectedTypes[j] = parsingResult.getProjectedTypes()[i];
                                if (deduplicatedProjectedNullMarkers != null) {
                                    deduplicatedProjectedNullMarkers[j] = parsingResult.getProjectedNullMarkers()[i];
                                }
                                Iterator iterator = idx.iterator();
                                while (iterator.hasNext()) {
                                    int k = (Integer)iterator.next();
                                    map[k] = j;
                                }
                                ++j;
                            }
                            RowProcessor projectionProcessor = this.makeProjectionProcessor(projectedTypes, deduplicatedProjectedNullMarkers);
                            rowProcessor = inRow -> {
                                if (projectionProcessor != null) {
                                    inRow = (Object[])projectionProcessor.apply(inRow);
                                }
                                Object[] outRow = new Object[map.length];
                                for (int i = 0; i < map.length; ++i) {
                                    outRow[i] = inRow[map[i]];
                                }
                                return outRow;
                            };
                            PropertyPath[] deduplicatedProjection = projectionsMap.keySet().toArray(new PropertyPath[projectionsMap.size()]);
                            IckleParsingResult<TypeMetadata> fpr = this.makeFilterParsingResult(parsingResult, normalizedWhereClause, deduplicatedProjection, projectedTypes, deduplicatedProjectedNullMarkers, sortFields);
                            return new EmbeddedLuceneQuery(this, namedParameters, fpr, parsingResult.getProjections(), rowProcessor, startOffset, maxResults, local);
                        }
                        rowProcessor = this.makeProjectionProcessor(parsingResult.getProjectedTypes(), parsingResult.getProjectedNullMarkers());
                    }
                    return new EmbeddedLuceneQuery(this, namedParameters, parsingResult, parsingResult.getProjections(), rowProcessor, startOffset, maxResults, local);
                }
                IckleParsingResult<TypeMetadata> fpr = this.makeFilterParsingResult(parsingResult, parsingResult.getWhereClause() != null ? parsingResult.getWhereClause() : normalizedWhereClause, null, null, null, sortFields);
                EmbeddedLuceneQuery indexQuery = new EmbeddedLuceneQuery(this, namedParameters, fpr, null, null, startOffset, maxResults, local);
                projectionQueryStr = SyntaxTreePrinter.printTree(parsingResult.getTargetEntityName(), parsingResult.getProjectedPaths(), null, null, null);
                return new MetadataHybridQuery((AdvancedCache<?, ?>)this.cache, projectionQueryStr, parsingResult.getStatementType(), null, this.getObjectFilter(this.matcher, projectionQueryStr, null, null), startOffset, maxResults, (Query<?>)indexQuery, this.queryStatistics, local, allSortFieldsAreStored);
            }
            IckleParsingResult<TypeMetadata> fpr = this.makeFilterParsingResult(parsingResult, normalizedWhereClause, null, null, null, null);
            EmbeddedLuceneQuery indexQuery = new EmbeddedLuceneQuery(this, namedParameters, fpr, null, null, -1L, -1, local);
            projectionQueryStr = SyntaxTreePrinter.printTree(parsingResult.getTargetEntityName(), parsingResult.getProjectedPaths(), null, null, sortFields);
            return new MetadataHybridQuery((AdvancedCache<?, ?>)this.cache, projectionQueryStr, parsingResult.getStatementType(), null, this.getObjectFilter(this.matcher, projectionQueryStr, null, null), startOffset, maxResults, (Query<?>)indexQuery, this.queryStatistics, local, allSortFieldsAreStored);
        }
        if (expansion == ConstantBooleanExpr.TRUE) {
            return new EmbeddedQuery(this, this.cache, queryString, parsingResult.getStatementType(), namedParameters, parsingResult.getProjections(), startOffset, maxResults, this.defaultMaxResults, this.queryStatistics, local);
        }
        IckleParsingResult<TypeMetadata> fpr = this.makeFilterParsingResult(parsingResult, expansion, null, null, null, null);
        EmbeddedLuceneQuery expandedQuery = new EmbeddedLuceneQuery(this, namedParameters, fpr, null, null, -1L, -1, local);
        return new MetadataHybridQuery((AdvancedCache<?, ?>)this.cache, queryString, parsingResult.getStatementType(), namedParameters, this.getObjectFilter(this.matcher, queryString, namedParameters, null), startOffset, maxResults, (Query<?>)expandedQuery, this.queryStatistics, local, allSortFieldsAreStored);
    }

    private IckleParsingResult<TypeMetadata> makeFilterParsingResult(IckleParsingResult<TypeMetadata> parsingResult, BooleanExpr normalizedWhereClause, PropertyPath[] projection, Class<?>[] projectedTypes, Object[] projectedNullMarkers, SortField[] sortFields) {
        String queryString = parsingResult.getQueryString();
        if (!queryString.toUpperCase().contains("JOIN")) {
            queryString = SyntaxTreePrinter.printTree(parsingResult.getTargetEntityName(), projection, normalizedWhereClause, parsingResult.getFilteringClause(), sortFields);
        }
        return new IckleParsingResult<TypeMetadata>(queryString, parsingResult.getStatementType(), parsingResult.getParameterNames(), normalizedWhereClause, null, parsingResult.getFilteringClause(), parsingResult.getTargetEntityName(), parsingResult.getTargetEntityMetadata(), projection, projectedTypes, projectedNullMarkers, null, sortFields);
    }

    protected RowProcessor makeProjectionProcessor(Class<?>[] projectedTypes, Object[] projectedNullMarkers) {
        return null;
    }

    public SearchQueryBuilder buildSearchQuery(String queryString, Map<String, Object> namedParameters) {
        log.tracef("Building Lucene query for Ickle query: %s", queryString);
        if (!this.isIndexed) {
            throw Log.CONTAINER.cannotRunLuceneQueriesIfNotIndexed(this.cache.getName());
        }
        return this.transformParsingResult(this.parse(queryString), namedParameters);
    }

    public <E> IndexedQuery<E> buildLuceneQuery(IckleParsingResult<TypeMetadata> parsingResult, Map<String, Object> namedParameters, long startOffset, int maxResults, boolean local) {
        if (log.isDebugEnabled()) {
            log.debugf("Building Lucene query for Ickle query: %s", parsingResult.getQueryString());
        }
        if (!this.isIndexed) {
            throw Log.CONTAINER.cannotRunLuceneQueriesIfNotIndexed(this.cache.getName());
        }
        SearchQueryBuilder searchQuery = this.transformParsingResult(parsingResult, namedParameters);
        IndexedQuery<?> cacheQuery = this.makeCacheQuery(parsingResult, searchQuery, namedParameters, local);
        if (startOffset >= 0L) {
            cacheQuery = cacheQuery.firstResult((int)startOffset);
        }
        if (maxResults >= 0) {
            cacheQuery = cacheQuery.maxResults(maxResults);
        }
        return cacheQuery;
    }

    public SearchQueryBuilder transformParsingResult(IckleParsingResult<TypeMetadata> parsingResult, Map<String, Object> namedParameters) {
        SearchQueryParsingResult searchParsingResult = this.queryCache != null && parsingResult.getParameterNames().isEmpty() ? this.queryCache.get(this.cache.getName(), parsingResult.getQueryString(), null, SearchQueryParsingResult.class, (q, a) -> this.transformToSearchQueryParsingResult(parsingResult, namedParameters)) : this.transformToSearchQueryParsingResult(parsingResult, namedParameters);
        return searchParsingResult.builder(this.getSearchMapping().getMappingSession());
    }

    private SearchQueryParsingResult transformToSearchQueryParsingResult(IckleParsingResult<TypeMetadata> parsingResult, Map<String, Object> namedParameters) {
        SearchQueryMaker<TypeMetadata> queryMaker = new SearchQueryMaker<TypeMetadata>(this.getSearchMapping(), this.propertyHelper, this.defaultMaxResults, this.defaultHitCountAccuracy);
        return queryMaker.transform(parsingResult, namedParameters, this.getTargetedClass(parsingResult), this.getTargetedNamedType(parsingResult));
    }

    @Override
    public IckleParsingResult<TypeMetadata> parse(String queryString) {
        return super.parse(queryString);
    }

    protected Class<?> getTargetedClass(IckleParsingResult<?> parsingResult) {
        return (Class)parsingResult.getTargetEntityMetadata();
    }

    protected String getTargetedNamedType(IckleParsingResult<?> parsingResult) {
        return null;
    }

    protected IndexedQuery<?> makeCacheQuery(IckleParsingResult<TypeMetadata> ickleParsingResult, SearchQueryBuilder searchQuery, Map<String, Object> namedParameters, boolean local) {
        if (!this.isIndexed) {
            throw Log.CONTAINER.cannotRunLuceneQueriesIfNotIndexed(this.cache.getName());
        }
        String queryString = ickleParsingResult.getQueryString();
        if (this.broadcastQuery && !local) {
            QueryDefinition queryDefinition = new QueryDefinition(queryString, ickleParsingResult.getStatementType(), this.getQueryEngineProvider(), this.defaultMaxResults);
            queryDefinition.setNamedParameters(namedParameters);
            return new DistributedIndexedQueryImpl(queryDefinition, this.cache, this.queryStatistics, this.defaultMaxResults, searchQuery.knn());
        }
        return new IndexedQueryImpl(queryString, ickleParsingResult.getStatementType(), searchQuery, this.cache, this.queryStatistics, this.defaultMaxResults);
    }

    protected SerializableFunction<AdvancedCache<?, ?>, QueryEngine<?>> getQueryEngineProvider() {
        return queryEngineProvider;
    }

    @FunctionalInterface
    protected static interface RowProcessor
    extends Function<Object[], Object[]> {
    }
}

