/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded.impl;

import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.lucene.search.Sort;
import org.hibernate.search.backend.lucene.LuceneExtension;
import org.hibernate.search.backend.lucene.search.query.LuceneSearchQuery;
import org.hibernate.search.backend.lucene.search.query.dsl.LuceneSearchQueryOptionsStep;
import org.hibernate.search.backend.lucene.search.query.dsl.LuceneSearchQuerySelectStep;
import org.hibernate.search.engine.common.EntityReference;
import org.hibernate.search.engine.search.aggregation.AggregationKey;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.projection.dsl.SearchProjectionFactory;
import org.hibernate.search.engine.search.query.dsl.SearchQueryDslExtension;
import org.hibernate.search.engine.search.sort.SearchSort;
import org.infinispan.query.dsl.embedded.impl.InfinispanAggregation;
import org.infinispan.query.dsl.embedded.impl.SearchProjectionInfo;
import org.infinispan.search.mapper.scope.SearchScope;
import org.infinispan.search.mapper.session.SearchSession;

public final class SearchQueryBuilder {
    public static final String INFINISPAN_AGGREGATION_KEY_NAME = "InfinispanSingletonKey";
    private final SearchSession querySession;
    private final SearchScope<?> scope;
    private final SearchProjectionInfo projectionInfo;
    private final InfinispanAggregation<?> aggregation;
    private final SearchPredicate predicate;
    private final SearchSort sort;
    private final Integer knn;
    private Collection<String> routingKeys = Collections.emptySet();
    private int hitCountAccuracy;
    private Long timeout;
    private TimeUnit timeUnit;

    public SearchQueryBuilder(SearchSession querySession, SearchScope<?> scope, SearchProjectionInfo projectionInfo, InfinispanAggregation<?> aggregation, SearchPredicate predicate, SearchSort sort, int hitCountAccuracy, Integer knn) {
        this.querySession = querySession;
        this.scope = scope;
        this.projectionInfo = projectionInfo;
        this.aggregation = aggregation;
        this.predicate = predicate;
        this.sort = sort;
        this.hitCountAccuracy = hitCountAccuracy;
        this.knn = knn;
    }

    public LuceneSearchQuery<?> build() {
        return this.aggregation == null ? this.build(this.projectionInfo.getProjection(), false) : this.buildWithAggregation(this.projectionInfo.getProjection(), this.aggregation);
    }

    public LuceneSearchQuery<Object> ids() {
        return this.build(this.scope.projection().id().toProjection(), false);
    }

    public LuceneSearchQuery<List<Object>> idAndScore() {
        SearchProjectionFactory<EntityReference, ?> projectionFactory = this.scope.projection();
        SearchProjection[] searchProjections = new SearchProjection[]{projectionFactory.id().toProjection(), projectionFactory.score().toProjection()};
        return this.build(SearchProjectionInfo.composite(projectionFactory, searchProjections).getProjection(), false);
    }

    public LuceneSearchQuery<List<Object>> keyAndEntity(boolean withMetadata) {
        SearchProjectionFactory<EntityReference, ?> projectionFactory = this.scope.projection();
        SearchProjection[] searchProjections = new SearchProjection[]{projectionFactory.entityReference().toProjection(), projectionFactory.entity().toProjection()};
        return this.build(SearchProjectionInfo.composite(projectionFactory, searchProjections).getProjection(), withMetadata);
    }

    public LuceneSearchQuery<List<Object>> keyEntityAndScore(boolean withMetadata) {
        SearchProjectionFactory<EntityReference, ?> projectionFactory = this.scope.projection();
        SearchProjection[] searchProjections = new SearchProjection[]{projectionFactory.entityReference().toProjection(), projectionFactory.entity().toProjection(), projectionFactory.score().toProjection()};
        return this.build(SearchProjectionInfo.composite(projectionFactory, searchProjections).getProjection(), withMetadata);
    }

    public void routeOnSegments(BitSet segments) {
        this.routingKeys = segments.stream().mapToObj(String::valueOf).collect(Collectors.toList());
    }

    public void noRouting() {
        this.routingKeys = Collections.emptySet();
    }

    public boolean isEntityProjection() {
        return this.projectionInfo.isEntityProjection();
    }

    public Sort getLuceneSort() {
        return this.ids().luceneSort();
    }

    public Integer knn() {
        return this.knn;
    }

    public InfinispanAggregation<?> aggregation() {
        return this.aggregation;
    }

    private <T> LuceneSearchQuery<T> build(SearchProjection<T> searchProjection, boolean withMetadata) {
        LuceneSearchQueryOptionsStep queryOptionsStep = (LuceneSearchQueryOptionsStep)((LuceneSearchQueryOptionsStep)((LuceneSearchQueryOptionsStep)((LuceneSearchQuerySelectStep)this.querySession.search(this.scope).extension((SearchQueryDslExtension)LuceneExtension.get())).select(searchProjection).where(this.predicate)).sort(this.sort)).routing(this.routingKeys);
        if (this.timeout != null && this.timeUnit != null) {
            queryOptionsStep = (LuceneSearchQueryOptionsStep)queryOptionsStep.failAfter(this.timeout.longValue(), this.timeUnit);
        }
        queryOptionsStep = (LuceneSearchQueryOptionsStep)queryOptionsStep.totalHitCountThreshold((long)this.hitCountAccuracy);
        queryOptionsStep.loading(l -> l.withMetadata(withMetadata));
        return queryOptionsStep.toQuery();
    }

    private <T, A> LuceneSearchQuery<T> buildWithAggregation(SearchProjection<T> searchProjection, InfinispanAggregation<A> aggregation) {
        AggregationKey aggregationKey = AggregationKey.of((String)INFINISPAN_AGGREGATION_KEY_NAME);
        LuceneSearchQueryOptionsStep queryOptionsStep = (LuceneSearchQueryOptionsStep)((LuceneSearchQueryOptionsStep)((LuceneSearchQueryOptionsStep)((LuceneSearchQueryOptionsStep)((LuceneSearchQuerySelectStep)this.querySession.search(this.scope).extension((SearchQueryDslExtension)LuceneExtension.get())).select(searchProjection).where(this.predicate)).aggregation(aggregationKey, aggregation.searchAggregation())).sort(this.sort)).routing(this.routingKeys);
        if (this.timeout != null && this.timeUnit != null) {
            queryOptionsStep = (LuceneSearchQueryOptionsStep)queryOptionsStep.failAfter(this.timeout.longValue(), this.timeUnit);
        }
        queryOptionsStep = (LuceneSearchQueryOptionsStep)queryOptionsStep.totalHitCountThreshold(0L);
        return queryOptionsStep.toQuery();
    }

    public void hitCountAccuracy(int hitCountAccuracy) {
        this.hitCountAccuracy = hitCountAccuracy;
    }

    public void failAfter(long timeout, TimeUnit timeUnit) {
        this.timeout = timeout;
        this.timeUnit = timeUnit;
    }
}

