/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl.function.sortedset;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.infinispan.functional.EntryView;
import org.infinispan.multimap.impl.BaseSetBucket;
import org.infinispan.multimap.impl.ScoredValue;
import org.infinispan.multimap.impl.SortedSetBucket;
import org.infinispan.protostream.annotations.Proto;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.util.function.SerializableFunction;

@ProtoTypeId(value=5342)
public final class SortedSetAggregateFunction<K, V>
implements SerializableFunction<EntryView.ReadWriteEntryView<K, ? extends BaseSetBucket<V>>, Collection<ScoredValue<V>>> {
    @ProtoField(value=1)
    final AggregateType type;
    @ProtoField(value=2)
    final Collection<ScoredValue<V>> scoredValues;
    @ProtoField(value=3)
    final double weight;
    @ProtoField(value=4)
    final SortedSetBucket.AggregateFunction function;

    @ProtoFactory
    public SortedSetAggregateFunction(AggregateType type, Collection<ScoredValue<V>> scoredValues, double weight, SortedSetBucket.AggregateFunction function) {
        this.type = type;
        this.scoredValues = scoredValues;
        this.weight = weight;
        this.function = function;
    }

    public Collection<ScoredValue<V>> apply(EntryView.ReadWriteEntryView<K, ? extends BaseSetBucket<V>> view) {
        Optional existing = view.peek();
        if (this.scoredValues != null && this.scoredValues.isEmpty() && existing.isEmpty()) {
            return Collections.emptyList();
        }
        BaseSetBucket bucket = existing.map(v -> v).orElseGet(SortedSetBucket::new);
        return this.type == AggregateType.UNION ? bucket.union(this.scoredValues, this.weight, this.function) : bucket.inter(this.scoredValues, this.weight, this.function);
    }

    @Proto
    @ProtoTypeId(value=5343)
    public static enum AggregateType {
        UNION,
        INTER;

    }
}

