/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl.function.list;

import java.util.Collection;
import java.util.Optional;
import org.infinispan.functional.EntryView;
import org.infinispan.marshall.protostream.impl.MarshallableObject;
import org.infinispan.multimap.impl.ListBucket;
import org.infinispan.multimap.impl.function.list.ListBucketBaseFunction;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=5321)
public final class IndexOfFunction<K, V>
implements ListBucketBaseFunction<K, V, Collection<Long>> {
    @ProtoField(value=1)
    final long count;
    @ProtoField(value=2)
    final long rank;
    @ProtoField(value=3)
    final long maxLen;
    private final V element;

    public IndexOfFunction(V element, long count, long rank, long maxLen) {
        this.element = element;
        this.count = count;
        this.rank = rank;
        this.maxLen = maxLen;
    }

    @ProtoFactory
    IndexOfFunction(long count, long rank, long maxLen, MarshallableObject<V> element) {
        this(MarshallableObject.unwrap(element), count, rank, maxLen);
    }

    @ProtoField(value=4)
    MarshallableObject<V> getElement() {
        return MarshallableObject.create(this.element);
    }

    public Collection<Long> apply(EntryView.ReadWriteEntryView<K, ListBucket<V>> entryView) {
        Optional existing = entryView.peek();
        if (existing.isPresent()) {
            return ((ListBucket)existing.get()).indexOf(this.element, this.count, this.rank, this.maxLen);
        }
        return null;
    }
}

