/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl.function.sortedset;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.multimap.impl.ScoredValue;
import org.infinispan.multimap.impl.SortedSetBucket;
import org.infinispan.multimap.impl.function.sortedset.SortedSetBucketBaseFunction;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=5326)
public final class PopFunction<K, V>
implements SortedSetBucketBaseFunction<K, V, Collection<ScoredValue<V>>> {
    @ProtoField(value=1)
    final boolean min;
    @ProtoField(value=2)
    final long count;

    @ProtoFactory
    public PopFunction(boolean min, long count) {
        this.min = min;
        this.count = count;
    }

    public Collection<ScoredValue<V>> apply(EntryView.ReadWriteEntryView<K, SortedSetBucket<V>> entryView) {
        Optional existing = entryView.peek();
        if (existing.isPresent()) {
            SortedSetBucket sortedSetBucket = (SortedSetBucket)existing.get();
            SortedSetBucket.SortedSetResult result = sortedSetBucket.pop(this.min, this.count);
            Collection poppedValues = result.result();
            if (result.bucket().size() == 0L) {
                entryView.remove();
            } else {
                entryView.set(result.bucket(), new MetaParam.Writable[0]);
            }
            return poppedValues;
        }
        return Collections.emptyList();
    }
}

