/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl.function.sortedset;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.marshall.protostream.impl.MarshallableList;
import org.infinispan.multimap.impl.SortedSetBucket;
import org.infinispan.multimap.impl.function.sortedset.SortedSetBucketBaseFunction;
import org.infinispan.multimap.impl.function.sortedset.SortedSetOperationType;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=5330)
public final class RemoveManyFunction<K, V, T>
implements SortedSetBucketBaseFunction<K, V, Long> {
    @ProtoField(value=1)
    final boolean includeMin;
    @ProtoField(value=2)
    final boolean includeMax;
    @ProtoField(value=3)
    final SortedSetOperationType type;
    private final List<T> values;

    public RemoveManyFunction(List<T> values, SortedSetOperationType type) {
        this.values = values;
        this.includeMin = false;
        this.includeMax = false;
        this.type = type;
    }

    public RemoveManyFunction(List<T> values, boolean includeMin, boolean includeMax, SortedSetOperationType type) {
        this.values = values;
        this.includeMin = includeMin;
        this.includeMax = includeMax;
        this.type = type;
    }

    @ProtoFactory
    RemoveManyFunction(boolean includeMin, boolean includeMax, SortedSetOperationType type, MarshallableList<T> values) {
        this(MarshallableList.unwrap(values), includeMin, includeMax, type);
    }

    @ProtoField(value=4)
    MarshallableList<T> getValues() {
        return MarshallableList.create(this.values);
    }

    public Long apply(EntryView.ReadWriteEntryView<K, SortedSetBucket<V>> entryView) {
        Optional existing = entryView.peek();
        if (existing.isPresent()) {
            SortedSetBucket bucket = (SortedSetBucket)existing.get();
            SortedSetBucket.SortedSetResult result = switch (this.type) {
                case SortedSetOperationType.LEX -> {
                    Object first = RemoveManyFunction.element(this.values, 0);
                    yield bucket.removeAll(first, this.includeMin, RemoveManyFunction.element(this.values, 1), this.includeMax);
                }
                case SortedSetOperationType.SCORE -> {
                    Double d = (Double)RemoveManyFunction.element(this.values, 0);
                    yield bucket.removeAll(d, this.includeMin, (Double)RemoveManyFunction.element(this.values, 1), this.includeMax);
                }
                case SortedSetOperationType.INDEX -> {
                    Long l = (Long)RemoveManyFunction.element(this.values, 0);
                    yield bucket.removeAll(l, (Long)RemoveManyFunction.element(this.values, 1));
                }
                default -> bucket.removeAll(RemoveManyFunction.unchecked(this.values));
            };
            SortedSetBucket next = result.bucket();
            if (next.size() == 0L) {
                entryView.remove();
            } else {
                entryView.set(next, new MetaParam.Writable[0]);
            }
            return result.result();
        }
        return 0L;
    }

    private static <E> Collection<E> unchecked(List<?> list) {
        return list;
    }

    private static <E> E element(List<?> list, int index) {
        return (E)list.get(index);
    }
}

