/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache.embedded;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URI;
import java.util.Properties;
import java.util.Set;
import javax.cache.CacheManager;
import javax.cache.configuration.Configuration;
import javax.cache.spi.CachingProvider;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.commons.util.FileLookup;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.commons.util.ReflectionUtil;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.jcache.AbstractJCache;
import org.infinispan.jcache.AbstractJCacheManager;
import org.infinispan.jcache.embedded.ConfigurationAdapter;
import org.infinispan.jcache.embedded.JCache;
import org.infinispan.jcache.embedded.logging.Log;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.util.logging.LogFactory;

public class JCacheManager
extends AbstractJCacheManager {
    private static final Log log = (Log)LogFactory.getLog(JCacheManager.class, Log.class);
    private final EmbeddedCacheManager cm;

    public JCacheManager(URI uri, ClassLoader classLoader, CachingProvider provider, Properties properties) {
        super(uri, classLoader, provider, properties, false);
        if (classLoader == null) {
            throw new IllegalArgumentException("Classloader cannot be null");
        }
        if (uri == null) {
            throw new IllegalArgumentException("Invalid CacheManager URI " + uri);
        }
        ConfigurationBuilderHolder cbh = this.getConfigurationBuilderHolder(classLoader);
        GlobalConfigurationBuilder globalBuilder = cbh.getGlobalConfigurationBuilder();
        String cacheManagerName = "uri=" + uri + "/classloader=" + classLoader.toString() + "/provider=" + provider.toString();
        globalBuilder.classLoader(classLoader).globalJmxStatistics().cacheManagerName(cacheManagerName);
        this.cm = new DefaultCacheManager(cbh, true);
        this.registerPredefinedCaches();
    }

    public JCacheManager(URI uri, EmbeddedCacheManager cacheManager, CachingProvider provider) {
        super(uri, null, provider, null, true);
        this.cm = cacheManager;
        this.registerPredefinedCaches();
    }

    private void registerPredefinedCaches() {
        Set cacheNames = this.cm.getCacheNames();
        for (String cacheName : cacheNames) {
            this.registerPredefinedCache(cacheName, new JCache(this.cm.getCache(cacheName).getAdvancedCache(), (CacheManager)this, ConfigurationAdapter.create()));
        }
    }

    private ConfigurationBuilderHolder getConfigurationBuilderHolder(ClassLoader classLoader) {
        try {
            FileLookup fileLookup = FileLookupFactory.newInstance();
            InputStream configurationStream = this.getURI().isAbsolute() ? fileLookup.lookupFileStrict(this.getURI(), classLoader) : fileLookup.lookupFileStrict(this.getURI().toString(), classLoader);
            return new ParserRegistry(classLoader).parse(configurationStream);
        }
        catch (FileNotFoundException e) {
            return new ConfigurationBuilderHolder(classLoader);
        }
    }

    public <T> T unwrap(Class<T> clazz) {
        return (T)ReflectionUtil.unwrapAny(clazz, (Object[])new Object[]{this, this.cm});
    }

    public ClassLoader getClassLoader() {
        return this.cm.getCacheManagerConfiguration().classLoader();
    }

    protected void delegateLogIsClosed() {
        throw log.cacheManagerClosed(this.cm.getStatus());
    }

    protected void delegateStop() {
        this.cm.stop();
    }

    protected Iterable<String> delegateCacheNames() {
        return this.cm.getCacheNames();
    }

    protected boolean delegateIsClosed() {
        return this.cm.getStatus().isTerminated();
    }

    protected <K, V> void delegateRemoveCache(AbstractJCache<K, V> jcache) {
        this.cm.removeCache(jcache.getName());
    }

    protected <K, V, C extends Configuration<K, V>> AbstractJCache<K, V> create(String cacheName, C configuration) {
        ConfigurationAdapter adapter = ConfigurationAdapter.create(configuration);
        this.cm.defineConfiguration(cacheName, adapter.build());
        AdvancedCache ispnCache = this.cm.getCache(cacheName).getAdvancedCache();
        if (!ispnCache.getStatus().allowInvocations()) {
            ispnCache.start();
        }
        return new JCache(ispnCache, (CacheManager)this, adapter);
    }

    protected <K, V, I extends BasicCache<K, V>> AbstractJCache<K, V> create(I ispnCache) {
        return new JCache((AdvancedCache)ispnCache, (CacheManager)this, ConfigurationAdapter.create());
    }

    protected boolean supportsJmx() {
        return true;
    }
}

