/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache.embedded.functions;

import java.util.function.Function;
import javax.cache.expiry.Duration;
import javax.cache.expiry.ExpiryPolicy;
import org.infinispan.commands.functional.functions.InjectableComponent;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.jcache.Expiration;
import org.infinispan.jcache.embedded.Durations;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=6907)
public class ReadWithExpiry<K, V>
implements Function<EntryView.ReadWriteEntryView<K, V>, V>,
InjectableComponent {
    private ExpiryPolicy expiryPolicy;

    public void inject(ComponentRegistry registry) {
        this.expiryPolicy = (ExpiryPolicy)registry.getComponent(ExpiryPolicy.class);
    }

    @Override
    public V apply(EntryView.ReadWriteEntryView<K, V> view) {
        if (view.find().isPresent()) {
            Object value = view.get();
            Duration ttl = Expiration.getExpiry((ExpiryPolicy)this.expiryPolicy, (Expiration.Operation)Expiration.Operation.ACCESS);
            if (ttl != null) {
                if (ttl.isZero()) {
                    view.remove();
                } else {
                    view.set(value, new MetaParam.Writable[]{new MetaParam.MetaLifespan(Durations.toMs(ttl))});
                }
            }
            return (V)value;
        }
        return null;
    }
}

