/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache.embedded.functions;

import java.util.Objects;
import java.util.function.BiFunction;
import javax.cache.expiry.ExpiryPolicy;
import org.infinispan.commands.functional.functions.InjectableComponent;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.functional.EntryView;
import org.infinispan.jcache.Expiration;
import org.infinispan.jcache.embedded.Durations;
import org.infinispan.marshall.protostream.impl.MarshallableObject;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=6911)
public class ReplaceConditionally<K, V>
implements BiFunction<V, EntryView.ReadWriteEntryView<K, V>, Boolean>,
InjectableComponent {
    private final V oldValue;
    private ExpiryPolicy expiryPolicy;

    public ReplaceConditionally(V oldValue) {
        this.oldValue = oldValue;
    }

    @ProtoFactory
    ReplaceConditionally(MarshallableObject<V> oldValue) {
        this(MarshallableObject.unwrap(oldValue));
    }

    @ProtoField(value=1)
    MarshallableObject<V> getOldValue() {
        return MarshallableObject.create(this.oldValue);
    }

    public void inject(ComponentRegistry registry) {
        this.expiryPolicy = (ExpiryPolicy)registry.getComponent(ExpiryPolicy.class);
    }

    @Override
    public Boolean apply(V v, EntryView.ReadWriteEntryView<K, V> view) {
        if (view.find().isPresent()) {
            if (Objects.equals(this.oldValue, view.get())) {
                Durations.setWithTtl(view, v, this.expiryPolicy, Expiration.Operation.UPDATE);
                return true;
            }
            Durations.updateTtl(view, this.expiryPolicy);
        }
        return false;
    }
}

