/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache.embedded;

import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import javax.cache.Cache;
import javax.cache.integration.CacheWriter;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.encoding.DataConversion;
import org.infinispan.jcache.Exceptions;
import org.infinispan.jcache.JCacheEntry;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.NonBlockingStore;
import org.infinispan.util.concurrent.BlockingManager;

public class JCacheWriterAdapter<K, V>
implements NonBlockingStore<K, V> {
    private CacheWriter<? super K, ? super V> delegate;
    private DataConversion keyDataConversion = DataConversion.IDENTITY_KEY;
    private DataConversion valueDataConversion = DataConversion.IDENTITY_KEY;
    private BlockingManager blockingManager;

    public void setCacheWriter(CacheWriter<? super K, ? super V> delegate) {
        this.delegate = delegate;
    }

    public void setDataConversion(DataConversion keyDataConversion, DataConversion valueDataConversion) {
        this.keyDataConversion = keyDataConversion;
        this.valueDataConversion = valueDataConversion;
    }

    public Set<NonBlockingStore.Characteristic> characteristics() {
        return EnumSet.of(NonBlockingStore.Characteristic.WRITE_ONLY, NonBlockingStore.Characteristic.SEGMENTABLE);
    }

    public CompletionStage<Void> start(InitializationContext ctx) {
        this.blockingManager = ctx.getBlockingManager();
        return CompletableFutures.completedNull();
    }

    public CompletionStage<Void> stop() {
        return CompletableFutures.completedNull();
    }

    public CompletionStage<MarshallableEntry<K, V>> load(int segment, Object key) {
        return CompletableFutures.completedNull();
    }

    public CompletionStage<Void> write(int segment, MarshallableEntry<? extends K, ? extends V> entry) {
        return this.blockingManager.runBlocking(() -> {
            try {
                this.delegate.write((Cache.Entry)new JCacheEntry(this.keyDataConversion.fromStorage(entry.getKey()), this.valueDataConversion.fromStorage(entry.getValue())));
            }
            catch (Exception e) {
                throw Exceptions.launderCacheWriterException((Exception)e);
            }
        }, (Object)"jcache-write");
    }

    public CompletionStage<Boolean> delete(int segment, Object key) {
        return this.blockingManager.supplyBlocking(() -> {
            try {
                this.delegate.delete(this.keyDataConversion.fromStorage(key));
            }
            catch (Exception e) {
                throw Exceptions.launderCacheWriterException((Exception)e);
            }
            return false;
        }, (Object)"jcache-delete");
    }

    public CompletionStage<Void> clear() {
        return CompletableFutures.completedNull();
    }
}

