/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache.logging;

import java.io.Closeable;
import javax.cache.CacheException;
import javax.cache.configuration.Configuration;
import javax.cache.processor.EntryProcessorException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="ISPN")
public interface Log
extends BasicLogger {
    @Message(value="Allocation stack trace:", id=21001)
    public LeakDescription cacheManagerNotClosed();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Closing leaked cache manager", id=21002)
    public void leakedCacheManager(@Cause Throwable var1);

    @Message(value="Method named '%s' is not annotated with CacheResult, CachePut, CacheRemoveEntry or CacheRemoveAll", id=21003)
    public IllegalArgumentException methodWithoutCacheAnnotation(String var1);

    @Message(value="Method named '%s' must have at least one parameter annotated with @CacheValue", id=21004)
    public CacheException cachePutMethodWithoutCacheValueParameter(String var1);

    @Message(value="Method named '%s' must have only one parameter annotated with @CacheValue", id=21005)
    public CacheException cachePutMethodWithMoreThanOneCacheValueParameter(String var1);

    @Message(value="Method named '%s' is annotated with CacheRemoveEntry but doesn't specify a cache name", id=21006)
    public CacheException cacheRemoveEntryMethodWithoutCacheName(String var1);

    @Message(value="Method named '%s' is annotated with CacheRemoveAll but doesn't specify a cache name", id=21007)
    public CacheException cacheRemoveAllMethodWithoutCacheName(String var1);

    @Message(value="Unable to instantiate CacheKeyGenerator with type '%s'", id=21008)
    public CacheException unableToInstantiateCacheKeyGenerator(Class<?> var1, @Cause Throwable var2);

    @Message(value="'%s' parameter must not be null", id=21010)
    public NullPointerException parameterMustNotBeNull(String var1);

    @Message(value="Incompatible cache value types specified, expected %s but %s was specified", id=21011)
    public ClassCastException incompatibleType(Class<?> var1, Class<?> var2);

    @Message(value="Cache %s already registered with configuration %s, and can not be registered again with a new given configuration %s", id=21015)
    public CacheException cacheAlreadyRegistered(String var1, Configuration var2, Configuration var3);

    @Message(value="Unknown expiry operation: %s", id=21016)
    public IllegalStateException unknownExpiryOperation(String var1);

    @Message(value="The configuration class %s is not supported by this implementation", id=21018)
    public IllegalArgumentException configurationClassNotSupported(Class var1);

    @Message(value="Entry processing failed", id=21019)
    public EntryProcessorException entryProcessingFailed(@Cause Throwable var1);

    @Message(value="Cache named '%s' was not found.", id=21022)
    public CacheException cacheNotFound(String var1);

    @Message(value="Cache is closed.", id=21023)
    public IllegalStateException cacheClosed();

    @Message(value="Cache manager is already closed.", id=21030)
    public IllegalStateException cacheManagerClosed();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Error closing %s", id=21031)
    public void errorClosingCloseable(Closeable var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Exception while getting expiry duration. Fallback to default duration eternal.", id=21032)
    public void getExpiryHasThrown(@Cause Throwable var1);

    public static class LeakDescription
    extends Throwable {
        public LeakDescription() {
        }

        public LeakDescription(String message) {
            super(message);
        }

        @Override
        public String toString() {
            return this.getLocalizedMessage();
        }
    }
}

