/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.blocks.RequestCorrelator;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.ResponseMode;
import org.jgroups.blocks.RspFilter;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.util.CondVar;
import org.jgroups.util.Condition;
import org.jgroups.util.FutureListener;
import org.jgroups.util.NotifyingFuture;
import org.jgroups.util.Util;

public abstract class Request
implements NotifyingFuture,
Condition {
    protected static final Log log = LogFactory.getLog(Request.class);
    protected final Lock lock = new ReentrantLock();
    protected final CondVar cond = new CondVar(this.lock);
    protected final Message request_msg;
    protected final RequestCorrelator corr;
    protected final RequestOptions options;
    protected volatile boolean done;
    protected boolean block_for_results = true;
    protected volatile FutureListener listener;

    public Request(Message request, RequestCorrelator corr, RequestOptions options) {
        this.request_msg = request;
        this.corr = corr;
        this.options = options;
    }

    public void setResponseFilter(RspFilter filter) {
        this.options.setRspFilter(filter);
    }

    public boolean getBlockForResults() {
        return this.block_for_results;
    }

    public void setBlockForResults(boolean block_for_results) {
        this.block_for_results = block_for_results;
    }

    public NotifyingFuture setListener(FutureListener listener) {
        this.listener = listener;
        if (this.done) {
            listener.futureDone(this);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() throws Exception {
        if (this.corr == null) {
            if (log.isErrorEnabled()) {
                log.error(Util.getMessage("CorrIsNullCannotSendRequest"));
            }
            return false;
        }
        this.sendRequest();
        if (!this.block_for_results || this.options.getMode() == ResponseMode.GET_NONE) {
            return true;
        }
        this.lock.lock();
        try {
            boolean bl = this.responsesComplete(this.options.getTimeout());
            return bl;
        }
        finally {
            this.done = true;
            this.lock.unlock();
        }
    }

    protected abstract void sendRequest() throws Exception;

    public abstract void receiveResponse(Object var1, Address var2, boolean var3);

    public abstract void viewChange(View var1);

    public abstract void suspect(Address var1);

    public abstract void siteUnreachable(String var1);

    public abstract void transportClosed();

    @Override
    public boolean isMet() {
        return this.responsesComplete();
    }

    protected abstract boolean responsesComplete();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getResponsesComplete() {
        this.lock.lock();
        try {
            boolean bl = this.responsesComplete();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.lock.lock();
        try {
            boolean retval = !this.done;
            this.done = true;
            if (this.corr != null) {
                this.corr.done(this);
            }
            this.cond.signal(true);
            boolean bl = retval;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCancelled() {
        this.lock.lock();
        try {
            boolean bl = this.done;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder(128);
        ret.append(super.toString());
        ret.append(", mode=" + (Object)((Object)this.options.getMode()));
        return ret.toString();
    }

    protected void checkCompletion(Future future) {
        if (this.listener != null && this.responsesComplete()) {
            this.listener.futureDone(future);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean responsesComplete(long timeout) throws InterruptedException {
        try {
            boolean bl = this.waitForResults(timeout);
            return bl;
        }
        finally {
            if (this.corr != null) {
                this.corr.done(this);
            }
        }
    }

    protected boolean waitForResults(long timeout) {
        if (timeout <= 0L) {
            this.cond.waitFor(this);
            return true;
        }
        return this.cond.waitFor(this, timeout, TimeUnit.MILLISECONDS);
    }
}

