/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.jgroups;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.marshall.InstanceReusingAdvancedExternalizer;
import org.infinispan.remoting.transport.TopologyAwareAddress;
import org.infinispan.remoting.transport.jgroups.JGroupsAddress;
import org.infinispan.remoting.transport.jgroups.JGroupsAddressCache;
import org.jgroups.util.ExtendedUUID;
import org.jgroups.util.Util;

public class JGroupsTopologyAwareAddress
extends JGroupsAddress
implements TopologyAwareAddress {
    protected static final byte[] SITE_ID = Util.stringToBytes("site-id");
    protected static final byte[] RACK_ID = Util.stringToBytes("rack-id");
    protected static final byte[] MACHINE_ID = Util.stringToBytes("machine-id");
    private final ExtendedUUID topologyAddress;

    public JGroupsTopologyAwareAddress(ExtendedUUID address) {
        super(address);
        this.topologyAddress = address;
    }

    @Override
    public String getSiteId() {
        return Util.bytesToString(this.topologyAddress.get(SITE_ID));
    }

    @Override
    public String getRackId() {
        return Util.bytesToString(this.topologyAddress.get(RACK_ID));
    }

    @Override
    public String getMachineId() {
        return Util.bytesToString(this.topologyAddress.get(MACHINE_ID));
    }

    @Override
    public boolean isSameSite(TopologyAwareAddress addr) {
        return this.getSiteId() == null ? addr.getSiteId() == null : this.getSiteId().equals(addr.getSiteId());
    }

    @Override
    public boolean isSameRack(TopologyAwareAddress addr) {
        if (!this.isSameSite(addr)) {
            return false;
        }
        return this.getRackId() == null ? addr.getRackId() == null : this.getRackId().equals(addr.getRackId());
    }

    @Override
    public boolean isSameMachine(TopologyAwareAddress addr) {
        if (!this.isSameRack(addr)) {
            return false;
        }
        return this.getMachineId() == null ? addr.getMachineId() == null : this.getMachineId().equals(addr.getMachineId());
    }

    public static final class Externalizer
    extends InstanceReusingAdvancedExternalizer<JGroupsTopologyAwareAddress> {
        public Externalizer() {
            super(false);
        }

        @Override
        public void doWriteObject(ObjectOutput output, JGroupsTopologyAwareAddress address) throws IOException {
            try {
                Util.writeAddress(address.address, output);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }

        @Override
        public JGroupsTopologyAwareAddress doReadObject(ObjectInput unmarshaller) throws IOException, ClassNotFoundException {
            try {
                ExtendedUUID jgroupsAddress = (ExtendedUUID)Util.readAddress(unmarshaller);
                return (JGroupsTopologyAwareAddress)JGroupsAddressCache.fromJGroupsAddress(jgroupsAddress);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }

        @Override
        public Set<Class<? extends JGroupsTopologyAwareAddress>> getTypeClasses() {
            return Collections.singleton(JGroupsTopologyAwareAddress.class);
        }

        @Override
        public Integer getId() {
            return 60;
        }
    }
}

