/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote.configuration;

import java.util.Properties;
import org.infinispan.commons.configuration.AbstractTypedPropertiesConfiguration;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.executors.ExecutorFactory;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.persistence.remote.configuration.AbstractRemoteStoreConfigurationChildBuilder;
import org.infinispan.persistence.remote.configuration.ExecutorFactoryConfiguration;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfigurationBuilder;

public class ExecutorFactoryConfigurationBuilder
extends AbstractRemoteStoreConfigurationChildBuilder<RemoteStoreConfigurationBuilder>
implements Builder<ExecutorFactoryConfiguration> {
    private final AttributeSet attributes = ExecutorFactoryConfiguration.attributeSet();

    ExecutorFactoryConfigurationBuilder(RemoteStoreConfigurationBuilder builder) {
        super(builder);
    }

    public ExecutorFactoryConfigurationBuilder factory(ExecutorFactory factory) {
        this.attributes.attribute(ExecutorFactoryConfiguration.EXECUTOR_FACTORY).set(factory);
        return this;
    }

    public ExecutorFactoryConfigurationBuilder addExecutorProperty(String key, String value) {
        TypedProperties properties = this.attributes.attribute(AbstractTypedPropertiesConfiguration.PROPERTIES).get();
        properties.put(key, value);
        this.attributes.attribute(AbstractTypedPropertiesConfiguration.PROPERTIES).set(properties);
        return this;
    }

    public ExecutorFactoryConfigurationBuilder withExecutorProperties(Properties props) {
        this.attributes.attribute(AbstractTypedPropertiesConfiguration.PROPERTIES).set(TypedProperties.toTypedProperties(props));
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
    }

    @Override
    public ExecutorFactoryConfiguration create() {
        return new ExecutorFactoryConfiguration(this.attributes.protect());
    }

    public ExecutorFactoryConfigurationBuilder read(ExecutorFactoryConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }

    public String toString() {
        return "ExecutorFactoryConfigurationBuilder [attributes=" + this.attributes + "]";
    }
}

