/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.eviction.impl;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.impl.ImmutableContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.eviction.PassivationManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.marshall.core.MarshalledEntryFactory;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.persistence.PersistenceUtil;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.util.TimeService;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class PassivationManagerImpl
implements PassivationManager {
    PersistenceManager persistenceManager;
    CacheNotifier notifier;
    Configuration cfg;
    private volatile boolean skipOnStop = false;
    boolean statsEnabled = false;
    boolean enabled = false;
    private static final Log log = LogFactory.getLog(PassivationManagerImpl.class);
    private final AtomicLong passivations = new AtomicLong(0L);
    private DataContainer<Object, Object> container;
    private TimeService timeService;
    private static final boolean trace = log.isTraceEnabled();
    private MarshalledEntryFactory marshalledEntryFactory;
    private DistributionManager distributionManager;

    @Inject
    public void inject(PersistenceManager persistenceManager, CacheNotifier notifier, Configuration cfg, DataContainer container, TimeService timeService, MarshalledEntryFactory marshalledEntryFactory, DistributionManager distributionManager) {
        this.persistenceManager = persistenceManager;
        this.notifier = notifier;
        this.cfg = cfg;
        this.container = container;
        this.timeService = timeService;
        this.marshalledEntryFactory = marshalledEntryFactory;
        this.distributionManager = distributionManager;
    }

    @Start(priority=12)
    public void start() {
        boolean bl = this.enabled = this.cfg.persistence().passivation() && this.cfg.persistence().usingStores();
        if (this.enabled) {
            this.statsEnabled = this.cfg.jmxStatistics().enabled();
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    private boolean isL1Key(Object key) {
        return this.distributionManager != null && !this.distributionManager.getLocality(key).isLocal();
    }

    @Override
    public void passivate(InternalCacheEntry entry) {
        Object key;
        if (this.enabled && entry != null && !this.isL1Key(key = entry.getKey())) {
            this.notifier.notifyCacheEntryPassivated(key, entry.getValue(), true, ImmutableContext.INSTANCE, null);
            if (trace) {
                log.tracef("Passivating entry %s", (Object)Util.toStr(key));
            }
            try {
                MarshalledEntry marshalledEntry = this.marshalledEntryFactory.newMarshalledEntry(entry.getKey(), entry.getValue(), PersistenceUtil.internalMetadata(entry));
                this.persistenceManager.writeToAllStores(marshalledEntry, PersistenceManager.AccessMode.BOTH);
                if (this.statsEnabled) {
                    this.passivations.getAndIncrement();
                }
            }
            catch (CacheException e) {
                log.unableToPassivateEntry(key, e);
            }
            this.notifier.notifyCacheEntryPassivated(key, null, false, ImmutableContext.INSTANCE, null);
        }
    }

    @Override
    public void passivateAll() throws PersistenceException {
        if (this.enabled && !this.skipOnStop) {
            long start = this.timeService.time();
            log.passivatingAllEntries();
            for (InternalCacheEntry<Object, Object> internalCacheEntry : this.container) {
                if (trace) {
                    log.tracef("Passivating %s", internalCacheEntry.getKey());
                }
                this.persistenceManager.writeToAllStores(this.marshalledEntryFactory.newMarshalledEntry(internalCacheEntry.getKey(), internalCacheEntry.getValue(), PersistenceUtil.internalMetadata(internalCacheEntry)), PersistenceManager.AccessMode.BOTH);
            }
            log.passivatedEntries(this.container.size(), Util.prettyPrintTime(this.timeService.timeDuration(start, TimeUnit.MILLISECONDS)));
        }
    }

    @Override
    public void skipPassivationOnStop(boolean skip) {
        this.skipOnStop = skip;
    }

    @Override
    public long getPassivations() {
        return this.passivations.get();
    }

    @Override
    public boolean getStatisticsEnabled() {
        return this.statsEnabled;
    }

    @Override
    public void setStatisticsEnabled(boolean enabled) {
        this.statsEnabled = enabled;
    }

    @Override
    public void resetStatistics() {
        this.passivations.set(0L);
    }
}

