/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.parsing;

import java.util.Properties;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.infinispan.commons.util.StringPropertyReplacer;
import org.infinispan.configuration.cache.AbstractStoreConfigurationBuilder;
import org.infinispan.configuration.cache.AsyncStoreConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.infinispan.configuration.parsing.Attribute;
import org.infinispan.configuration.parsing.Element;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.configuration.parsing.XMLExtendedStreamReader;

public class Parser {
    public static Properties parseProperties(XMLExtendedStreamReader reader) throws XMLStreamException {
        Properties properties = new Properties();
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTY: {
                    Parser.parseProperty(reader, properties);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
        return properties;
    }

    public static void parseProperty(XMLExtendedStreamReader reader, Properties properties) throws XMLStreamException {
        int attributes = reader.getAttributeCount();
        ParseUtils.requireAttributes(reader, Attribute.NAME.getLocalName());
        String key = null;
        block3: for (int i = 0; i < attributes; ++i) {
            String value = StringPropertyReplacer.replaceProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    key = value;
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        String propertyValue = StringPropertyReplacer.replaceProperties(reader.getElementText());
        properties.setProperty(key, propertyValue);
    }

    public static void parseStoreAttribute(XMLExtendedStreamReader reader, int index, AbstractStoreConfigurationBuilder<?, ?> storeBuilder) throws XMLStreamException {
        String value = StringPropertyReplacer.replaceProperties(reader.getAttributeValue(index));
        Attribute attribute = Attribute.forName(reader.getAttributeLocalName(index));
        switch (attribute) {
            case SHARED: {
                storeBuilder.shared(Boolean.parseBoolean(value));
                break;
            }
            case READ_ONLY: {
                storeBuilder.ignoreModifications(Boolean.valueOf(value));
                break;
            }
            case PRELOAD: {
                storeBuilder.preload(Boolean.parseBoolean(value));
                break;
            }
            case FETCH_STATE: {
                storeBuilder.fetchPersistentState(Boolean.parseBoolean(value));
                break;
            }
            case PURGE: {
                storeBuilder.purgeOnStartup(Boolean.parseBoolean(value));
                break;
            }
            case SINGLETON: {
                storeBuilder.singleton().enabled(Boolean.parseBoolean(value));
                break;
            }
            default: {
                throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, index);
            }
        }
    }

    public static void parseStoreElement(XMLExtendedStreamReader reader, StoreConfigurationBuilder<?, ?> storeBuilder) throws XMLStreamException {
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case WRITE_BEHIND: {
                Parser.parseStoreWriteBehind(reader, storeBuilder.async().enable());
                break;
            }
            case PROPERTY: {
                Parser.parseStoreProperty(reader, storeBuilder);
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement(reader);
            }
        }
    }

    public static void parseStoreWriteBehind(XMLExtendedStreamReader reader, AsyncStoreConfigurationBuilder<?> storeBuilder) throws XMLStreamException {
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = StringPropertyReplacer.replaceProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case FLUSH_LOCK_TIMEOUT: {
                    storeBuilder.flushLockTimeout(Long.parseLong(value));
                    continue block6;
                }
                case MODIFICATION_QUEUE_SIZE: {
                    storeBuilder.modificationQueueSize(Integer.parseInt(value));
                    continue block6;
                }
                case SHUTDOWN_TIMEOUT: {
                    storeBuilder.shutdownTimeout(Long.parseLong(value));
                    continue block6;
                }
                case THREAD_POOL_SIZE: {
                    storeBuilder.threadPoolSize(Integer.parseInt(value));
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    public static void parseStoreProperty(XMLExtendedStreamReader reader, StoreConfigurationBuilder<?, ?> storeBuilder) throws XMLStreamException {
        String property = ParseUtils.requireSingleAttribute(reader, Attribute.NAME.getLocalName());
        String value = reader.getElementText();
        storeBuilder.addProperty(property, value);
    }
}

