/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.concurrent.TimeUnit;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;

public class L1Configuration {
    public static final AttributeDefinition<Boolean> ENABLED = AttributeDefinition.builder("enabled", false).immutable().build();
    public static final AttributeDefinition<Integer> INVALIDATION_THRESHOLD = AttributeDefinition.builder("invalidationThreshold", 0).immutable().build();
    public static final AttributeDefinition<Long> LIFESPAN = AttributeDefinition.builder("lifespan", TimeUnit.MINUTES.toMillis(10L)).immutable().build();
    public static final AttributeDefinition<Long> CLEANUP_TASK_FREQUENCY = AttributeDefinition.builder("cleanupTaskFrequency", TimeUnit.MINUTES.toMillis(1L)).immutable().build();
    private final Attribute<Boolean> enabled;
    private final Attribute<Integer> invalidationThreshold;
    private final Attribute<Long> lifespan;
    private final Attribute<Long> cleanupTaskFrequency;
    private final AttributeSet attributes;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(L1Configuration.class, ENABLED, INVALIDATION_THRESHOLD, LIFESPAN, CLEANUP_TASK_FREQUENCY);
    }

    L1Configuration(AttributeSet attributes) {
        this.attributes = attributes.checkProtection();
        this.enabled = attributes.attribute(ENABLED);
        this.invalidationThreshold = attributes.attribute(INVALIDATION_THRESHOLD);
        this.lifespan = attributes.attribute(LIFESPAN);
        this.cleanupTaskFrequency = attributes.attribute(CLEANUP_TASK_FREQUENCY);
    }

    public boolean enabled() {
        return this.enabled.get();
    }

    public int invalidationThreshold() {
        return this.invalidationThreshold.get();
    }

    public long cleanupTaskFrequency() {
        return this.cleanupTaskFrequency.get();
    }

    public long lifespan() {
        return this.lifespan.get();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public String toString() {
        return "L1Configuration [attributes=" + this.attributes + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        L1Configuration other = (L1Configuration)obj;
        return !(this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        return result;
    }
}

