/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.HashSet;
import java.util.Set;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeInitializer;
import org.infinispan.commons.configuration.attributes.AttributeSet;

public class AuthorizationConfiguration {
    public static final AttributeDefinition<Boolean> ENABLED = AttributeDefinition.builder("enabled", false).immutable().build();
    public static final AttributeDefinition<Set> ROLES = AttributeDefinition.builder("roles", null, Set.class).initializer(new AttributeInitializer<Set>(){

        @Override
        public Set initialize() {
            return new HashSet();
        }
    }).build();
    private final Attribute<Boolean> enabled;
    private final Attribute<Set> roles;
    private final AttributeSet attributes;

    static final AttributeSet attributeDefinitionSet() {
        return new AttributeSet(AuthorizationConfiguration.class, ENABLED, ROLES);
    }

    AuthorizationConfiguration(AttributeSet attributes) {
        this.attributes = attributes.checkProtection();
        this.enabled = attributes.attribute(ENABLED);
        this.roles = attributes.attribute(ROLES);
    }

    public boolean enabled() {
        return this.enabled.get();
    }

    public Set<String> roles() {
        return this.roles.get();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public String toString() {
        return "AuthorizationConfiguration [attributes=" + this.attributes + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AuthorizationConfiguration other = (AuthorizationConfiguration)obj;
        return !(this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        return result;
    }
}

