/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.remote;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.List;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.BaseRpcInvokingCommand;
import org.infinispan.commands.tx.TransactionBoundaryCommand;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.context.InvocationContext;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class MultipleRpcCommand
extends BaseRpcInvokingCommand {
    public static final byte COMMAND_ID = 2;
    private static final Log log = LogFactory.getLog(MultipleRpcCommand.class);
    private static final boolean trace = log.isTraceEnabled();
    private ReplicableCommand[] commands;

    private MultipleRpcCommand() {
        super(null);
    }

    public MultipleRpcCommand(List<ReplicableCommand> modifications, String cacheName) {
        super(cacheName);
        this.commands = modifications.toArray(new ReplicableCommand[modifications.size()]);
    }

    public MultipleRpcCommand(String cacheName) {
        super(cacheName);
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        if (trace) {
            log.tracef("Executing remotely originated commands: %d", this.commands.length);
        }
        for (ReplicableCommand command : this.commands) {
            if (command instanceof TransactionBoundaryCommand) {
                command.perform(null);
                continue;
            }
            this.processVisitableCommand(command);
        }
        return null;
    }

    @Override
    public byte getCommandId() {
        return 2;
    }

    public ReplicableCommand[] getCommands() {
        return this.commands;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        MarshallUtil.marshallArray(this.commands, output);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.commands = (ReplicableCommand[])MarshallUtil.unmarshallArray(input, ReplicableCommand[]::new);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MultipleRpcCommand)) {
            return false;
        }
        MultipleRpcCommand that = (MultipleRpcCommand)o;
        if (this.cacheName != null ? !this.cacheName.equals(that.cacheName) : that.cacheName != null) {
            return false;
        }
        if (!Arrays.equals(this.commands, that.commands)) {
            return false;
        }
        return !(this.interceptorChain != null ? !this.interceptorChain.equals(that.interceptorChain) : that.interceptorChain != null);
    }

    public int hashCode() {
        int result = this.interceptorChain != null ? this.interceptorChain.hashCode() : 0;
        result = 31 * result + (this.commands != null ? Arrays.hashCode(this.commands) : 0);
        result = 31 * result + (this.cacheName != null ? this.cacheName.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "MultipleRpcCommand{commands=" + (this.commands == null ? null : Arrays.asList(this.commands)) + ", cacheName='" + this.cacheName + '\'' + '}';
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public boolean canBlock() {
        for (ReplicableCommand command : this.commands) {
            if (!command.canBlock()) continue;
            return true;
        }
        return false;
    }
}

