/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.functional;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import java.util.function.Function;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.functional.AbstractWriteKeyCommand;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commons.api.functional.EntryView;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.functional.impl.EntryViews;
import org.infinispan.functional.impl.Params;

public final class ReadWriteKeyCommand<K, V, R>
extends AbstractWriteKeyCommand<K, V> {
    public static final byte COMMAND_ID = 50;
    private Function<EntryView.ReadWriteEntryView<K, V>, R> f;

    public ReadWriteKeyCommand(K key, Function<EntryView.ReadWriteEntryView<K, V>, R> f, CommandInvocationId id, ValueMatcher valueMatcher, Params params) {
        super(key, valueMatcher, id, params);
        this.f = f;
    }

    public ReadWriteKeyCommand() {
    }

    @Override
    public byte getCommandId() {
        return 50;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.key);
        output.writeObject(this.f);
        MarshallUtil.marshallEnum(this.valueMatcher, output);
        Params.writeObject(output, this.params);
        output.writeObject(Flag.copyWithoutRemotableFlags(this.flags));
        output.writeObject(this.commandInvocationId);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.key = input.readObject();
        this.f = (Function)input.readObject();
        this.valueMatcher = MarshallUtil.unmarshallEnum(input, ValueMatcher::valueOf);
        this.params = Params.readObject(input);
        this.flags = (Set)input.readObject();
        this.commandInvocationId = (CommandInvocationId)input.readObject();
    }

    @Override
    public boolean isConditional() {
        return true;
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        if (this.valueMatcher == ValueMatcher.MATCH_NEVER) {
            this.successful = false;
            return null;
        }
        CacheEntry e = ctx.lookupEntry(this.key);
        if (e == null) {
            return null;
        }
        R ret = this.f.apply(EntryViews.readWrite(e));
        return EntryViews.snapshot(ret);
    }

    @Override
    public void updateStatusFromRemoteResponse(Object remoteResponse) {
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitReadWriteKeyCommand(ctx, this);
    }

    @Override
    public boolean readsExistingValues() {
        return true;
    }

    @Override
    public boolean alwaysReadsExistingValues() {
        return false;
    }
}

