/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.component.processor;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.NoSuchFileException;
import java.time.Instant;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.infinispan.component.processor.Model;
import org.infinispan.factories.annotations.InfinispanModule;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.jmx.annotations.DataType;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;

public class Generator {
    private static final String MODULE_METADATA_BUILDER_SERVICE_NAME = "META-INF/services/org.infinispan.factories.impl.ModuleMetadataBuilder";
    private final Model model;
    private final Filer filer;

    public Generator(Model model, Filer filer) {
        this.model = model;
        this.filer = filer;
    }

    public void writePackageClasses() throws IOException {
        for (Model.Package p : this.model.packages.values()) {
            this.writePackageClass(p);
        }
    }

    private void writePackageClass(Model.Package p) throws IOException {
        String packageClassName = String.format("%s.%sPackageImpl", p.packageName, this.model.module.classPrefix);
        JavaFileObject packageFile = this.filer.createSourceFile(packageClassName, new Element[0]);
        try (PrintWriter writer = new PrintWriter(packageFile.openWriter(), false);){
            writer.printf("package %s;%n%n", p.packageName);
            writer.printf("import java.util.Arrays;%n", new Object[0]);
            writer.printf("import java.util.Collections;%n", new Object[0]);
            writer.printf("import javax.annotation.processing.Generated;%n", new Object[0]);
            writer.printf("%n", new Object[0]);
            writer.printf("import org.infinispan.factories.impl.ComponentAccessor;%n", new Object[0]);
            writer.printf("import org.infinispan.factories.impl.ModuleMetadataBuilder;%n", new Object[0]);
            writer.printf("import org.infinispan.factories.impl.MBeanMetadata;%n", new Object[0]);
            writer.printf("import org.infinispan.factories.impl.MBeanMetadata.AttributeMetadata;%n", new Object[0]);
            writer.printf("import org.infinispan.factories.impl.MBeanMetadata.OperationMetadata;%n", new Object[0]);
            writer.printf("import org.infinispan.factories.impl.MBeanMetadata.OperationParameterMetadata;%n", new Object[0]);
            writer.printf("import org.infinispan.factories.impl.WireContext;%n", new Object[0]);
            writer.printf("import org.infinispan.lifecycle.ModuleLifecycle;%n", new Object[0]);
            writer.printf("%n", new Object[0]);
            writer.printf("/**%n * @api.private %n */%n", new Object[0]);
            writer.printf("@Generated(value = \"%s\", date = \"%s\")%n", this.getClass().getName(), Instant.now().toString());
            writer.printf("public final class %sPackageImpl {%n", this.model.module.classPrefix);
            writer.printf("   public static void registerMetadata(ModuleMetadataBuilder.ModuleBuilder builder) {%n", new Object[0]);
            for (Model.AnnotatedType c : p.annotatedTypes) {
                writer.printf("//start %s%n", c.typeElement.getQualifiedName());
                if (c.component != null) {
                    this.writeComponentAccessor(writer, c);
                    writer.printf("%n", new Object[0]);
                }
                if (c.mComponent == null) continue;
                this.writeMBeanMetadata(writer, c);
                writer.printf("%n", new Object[0]);
            }
            for (Model.ParsedType parsedType : p.parsedTypes) {
                for (String line : parsedType.code) {
                    writer.println(line);
                }
            }
            writer.printf("//end%n", new Object[0]);
            writer.printf("   }%n", new Object[0]);
            writer.printf("}%n", new Object[0]);
        }
    }

    private void writeComponentAccessor(PrintWriter writer, Model.AnnotatedType annotatedType) {
        String simpleClassName = annotatedType.qualifiedName.substring(annotatedType.packageName.length() + 1);
        String binaryName = annotatedType.binaryName;
        Model.Component c = annotatedType.component;
        Scopes scope = c.scope.value();
        String scopeLiteral = String.valueOf(scope.ordinal());
        boolean survivesRestarts = c.survivesRestarts;
        boolean autoInstantiable = c.autoInstantiable;
        CharSequence superAccessor = this.stringLiteral(c.superBinaryName);
        CharSequence eagerDependencies = this.listLiteral(this.getEagerDependencies(c));
        CharSequence factoryComponents = this.listLiteral(c.factoryComponentNames);
        writer.printf("      builder.registerComponentAccessor(\"%s\",%n", binaryName);
        writer.printf("         %s,%n", factoryComponents);
        if (!c.hasDependenciesOrLifecycle() && !autoInstantiable) {
            writer.printf("         new ComponentAccessor<%s>(\"%s\",%n            %s, %s, %s,%n            %s));%n", simpleClassName, binaryName, scopeLiteral, survivesRestarts, superAccessor, eagerDependencies);
            return;
        }
        writer.printf("         new ComponentAccessor<%s>(\"%s\",%n            %s, %s, %s,%n            %s) {%n", simpleClassName, binaryName, scopeLiteral, survivesRestarts, superAccessor, eagerDependencies);
        if (!c.injectFields.isEmpty() || !c.injectMethods.isEmpty()) {
            writer.printf("         protected void wire(%s instance, WireContext context, boolean start) {%n", simpleClassName);
            for (Model.InjectField injectField : c.injectFields) {
                String componentType = injectField.typeName;
                String componentName = injectField.componentName;
                String lazy = injectField.isComponentRef ? "Lazy" : "";
                writer.printf("            instance.%s = context.get%s(\"%s\", %s.class, start);%n", injectField.name, lazy, componentName, componentType);
            }
            for (Model.InjectMethod injectMethod : c.injectMethods) {
                writer.printf("            instance.%s(%n", injectMethod.name);
                List<Model.InjectField> parameters = injectMethod.parameters;
                for (int i = 0; i < parameters.size(); ++i) {
                    Model.InjectField parameter = parameters.get(i);
                    String componentType = parameter.typeName;
                    String componentName = parameter.componentName;
                    String lazy = parameter.isComponentRef ? "Lazy" : "";
                    writer.printf("               context.get%s(\"%s\", %s.class, start)%s%n", lazy, componentName, componentType, this.optionalComma(i, parameters.size()));
                }
                writer.printf("            );%n", new Object[0]);
            }
            writer.printf("         }%n", new Object[0]);
            writer.printf("%n", new Object[0]);
        }
        if (!c.startMethods.isEmpty()) {
            writer.printf("         protected void start(%s instance) throws Exception {%n", simpleClassName);
            this.writeLifecycleMethodInvocations(writer, c.startMethods);
            writer.printf("         }%n", new Object[0]);
            writer.printf("%n", new Object[0]);
        }
        if (!c.stopMethods.isEmpty()) {
            writer.printf("         protected void stop(%s instance) throws Exception {%n", simpleClassName);
            this.writeLifecycleMethodInvocations(writer, c.stopMethods);
            writer.printf("         }%n", new Object[0]);
            writer.printf("%n", new Object[0]);
        }
        if (autoInstantiable) {
            writer.printf("         protected %s newInstance() {%n", simpleClassName);
            writer.printf("            return new %s();%n", simpleClassName);
            writer.printf("         }%n", new Object[0]);
            writer.printf("%n", new Object[0]);
        }
        writer.printf("      });%n", new Object[0]);
    }

    private void writeLifecycleMethodInvocations(PrintWriter writer, List<Model.LifecycleMethod> methods) {
        for (Model.LifecycleMethod method : this.sortByPriority(methods)) {
            writer.printf("            instance.%s();%n", method.name);
        }
    }

    private List<Model.LifecycleMethod> sortByPriority(List<Model.LifecycleMethod> methods) {
        ArrayList<Model.LifecycleMethod> result = new ArrayList<Model.LifecycleMethod>(methods);
        result.sort(Comparator.comparing(method -> method.priority));
        return result;
    }

    private List<CharSequence> getEagerDependencies(Model.Component c) {
        ArrayList<CharSequence> eagerDependencies = new ArrayList<CharSequence>();
        for (Model.InjectField injectField : c.injectFields) {
            if (injectField.isComponentRef) continue;
            eagerDependencies.add(injectField.componentName);
        }
        for (Model.InjectMethod injectMethod : c.injectMethods) {
            for (Model.InjectField parameter : injectMethod.parameters) {
                if (parameter.isComponentRef) continue;
                eagerDependencies.add(parameter.componentName);
            }
        }
        return eagerDependencies;
    }

    private void writeMBeanMetadata(PrintWriter writer, Model.AnnotatedType c) {
        String binaryName = c.binaryName;
        Model.MComponent m = c.mComponent;
        MBean mbean = m.mbean;
        CharSequence superMBeanName = this.stringLiteral(m.superBinaryName);
        List<Model.MAttribute> attributes = m.attributes;
        List<Model.MOperation> operations = m.operations;
        writer.printf("      builder.registerMBeanMetadata(\"%s\",%n", binaryName);
        int count = attributes.size() + operations.size();
        writer.printf("         MBeanMetadata.of(\"%s\", \"%s\", %s%s%n", mbean.objectName(), mbean.description(), superMBeanName, this.optionalComma(-1, count));
        int i = 0;
        for (Model.MAttribute attribute : attributes) {
            this.writeManagedAttribute(writer, attribute.name, attribute.attribute, attribute.useSetter, attribute.type, attribute.is, this.makeGetterFunction(c, attribute), this.makeSetterFunction(c, attribute), this.optionalComma(i++, count));
        }
        for (Model.MOperation method : operations) {
            ManagedOperation operation = method.operation;
            List<Model.MParameter> parameters = method.parameters;
            writer.printf("            new OperationMetadata(\"%s\", \"%s\", \"%s\", \"%s\"%s%n", method.name, operation.name(), operation.description(), method.returnType, this.optionalComma(-1, parameters.size()));
            for (int j = 0; j < parameters.size(); ++j) {
                Model.MParameter parameter = parameters.get(j);
                writer.printf("               new OperationParameterMetadata(\"%s\", \"%s\", \"%s\")%s%n", parameter.name, parameter.type, parameter.description, this.optionalComma(j, parameters.size()));
            }
            writer.printf("            )%s%n", this.optionalComma(i++, count));
        }
        writer.printf("      ));%n", new Object[0]);
    }

    private String makeGetterFunction(Model.AnnotatedType clazz, Model.MAttribute attribute) {
        if (attribute.attribute.dataType() == DataType.MEASUREMENT && (attribute.boxedType.equals("java.lang.Integer") || attribute.boxedType.equals("java.lang.Long") || attribute.boxedType.equals("java.lang.Short") || attribute.boxedType.equals("java.lang.Byte") || attribute.boxedType.equals("java.lang.Float") || attribute.boxedType.equals("java.lang.Double") || attribute.boxedType.equals("java.math.BigDecimal") || attribute.boxedType.equals("java.math.BigInteger"))) {
            return "(java.util.function.Function<" + clazz.qualifiedName + ", ?>) " + (String)(attribute.useSetter ? clazz.qualifiedName + "::" : "_x -> _x.") + attribute.propertyAccessor;
        }
        return "null";
    }

    private String makeSetterFunction(Model.AnnotatedType clazz, Model.MAttribute attribute) {
        if (attribute.attribute.dataType() == DataType.HISTOGRAM || attribute.attribute.dataType() == DataType.TIMER) {
            return "(" + clazz.qualifiedName + " _x, Object _y) -> _x." + attribute.propertyAccessor + (attribute.useSetter ? "((" + attribute.boxedType + ") _y)" : " = (" + attribute.boxedType + ") _y");
        }
        return "null";
    }

    private void writeManagedAttribute(PrintWriter writer, CharSequence name, ManagedAttribute attribute, boolean useSetter, String type, boolean is, String getterFunction, String setterFunction, String comma) {
        writer.printf("            new AttributeMetadata(\"%s\", \"%s\", %b, %b, \"%s\", %s, %s, %s, %b)%s%n", name, attribute.description(), attribute.writable(), useSetter, type, is, getterFunction, setterFunction, attribute.clusterWide(), comma);
    }

    public void writeModuleClass(TypeElement[] sourceElements) throws IOException {
        InfinispanModule moduleAnnotation = this.model.module.moduleAnnotation;
        Model.Module module = this.model.module;
        String moduleClassName = String.format("%s.%sModuleImpl", module.packageName, module.classPrefix);
        JavaFileObject moduleFile = this.filer.createSourceFile(moduleClassName, sourceElements);
        try (PrintWriter writer = new PrintWriter(moduleFile.openWriter(), false);){
            writer.printf("package %s;%n%n", module.packageName);
            writer.printf("import java.util.Arrays;%n", new Object[0]);
            writer.printf("import java.util.Collection;%n", new Object[0]);
            writer.printf("import java.util.Collections;%n", new Object[0]);
            writer.printf("import javax.annotation.processing.Generated;%n", new Object[0]);
            writer.printf("%n", new Object[0]);
            writer.printf("import org.infinispan.factories.impl.ModuleMetadataBuilder;%n", new Object[0]);
            writer.printf("import org.infinispan.lifecycle.ModuleLifecycle;%n", new Object[0]);
            writer.printf("import org.infinispan.manager.ModuleRepository;%n", new Object[0]);
            writer.printf("%n", new Object[0]);
            writer.printf("/**%n * @api.private %n */%n", new Object[0]);
            writer.printf("@Generated(value = \"%s\", date = \"%s\")%n", this.getClass().getName(), Instant.now().toString());
            writer.printf("public final class %sModuleImpl implements ModuleMetadataBuilder {%n", module.classPrefix);
            writer.printf("//module %s%n", module.moduleClassName);
            writer.printf("   public String getModuleName() {%n", new Object[0]);
            writer.printf("      return \"%s\";%n", moduleAnnotation.name());
            writer.printf("   }%n", new Object[0]);
            writer.printf("%n", new Object[0]);
            writer.printf("   public Collection<String> getRequiredDependencies() {%n", new Object[0]);
            writer.printf("      return %s;%n", this.listLiteral(Arrays.asList(moduleAnnotation.requiredModules())));
            writer.printf("   }%n", new Object[0]);
            writer.printf("%n", new Object[0]);
            writer.printf("   public Collection<String> getOptionalDependencies() {%n", new Object[0]);
            writer.printf("      return %s;%n", this.listLiteral(Arrays.asList(moduleAnnotation.optionalModules())));
            writer.printf("   }%n", new Object[0]);
            writer.printf("%n", new Object[0]);
            writer.printf("   public ModuleLifecycle newModuleLifecycle() {%n", new Object[0]);
            writer.printf("      return new %s();%n", module.moduleClassName);
            writer.printf("   }%n", new Object[0]);
            writer.printf("%n", new Object[0]);
            writer.printf("   public void registerMetadata(ModuleBuilder builder) {%n", new Object[0]);
            for (String packageName : this.model.packages.keySet()) {
                writer.printf("//package %s%n", packageName);
                writer.printf("      %s.%sPackageImpl.registerMetadata(builder);%n", packageName, module.classPrefix);
            }
            writer.printf("   }%n", new Object[0]);
            writer.printf("}%n", new Object[0]);
        }
    }

    public void writeServiceFile(TypeElement[] sourceElements) throws IOException {
        FileObject serviceFile = this.filer.createResource(StandardLocation.CLASS_OUTPUT, "", MODULE_METADATA_BUILDER_SERVICE_NAME, sourceElements);
        try (PrintWriter writer = new PrintWriter(serviceFile.openWriter(), false);){
            writer.printf("%s.%sModuleImpl", this.model.module.packageName, this.model.module.classPrefix);
        }
    }

    public static String readServiceFile(Filer filer) throws IOException {
        String string;
        FileObject serviceFile = filer.getResource(StandardLocation.CLASS_OUTPUT, "", MODULE_METADATA_BUILDER_SERVICE_NAME);
        BufferedReader reader = new BufferedReader(serviceFile.openReader(false));
        try {
            string = reader.readLine();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException | NoSuchFileException e) {
                return null;
            }
        }
        reader.close();
        return string;
    }

    public static Map.Entry<String, Set<String>> readModuleClass(Filer filer, String moduleImplementationName) throws IOException {
        AbstractMap.SimpleEntry simpleEntry;
        String moduleImplPath = String.format("%s.java", moduleImplementationName.replace(".", "/"));
        FileObject sourceFile = filer.getResource(StandardLocation.SOURCE_OUTPUT, "", moduleImplPath);
        BufferedReader reader = new BufferedReader(sourceFile.openReader(false));
        try {
            String line;
            String moduleClass = null;
            HashSet<String> packages = new HashSet<String>();
            while ((line = reader.readLine()) != null) {
                Matcher matcher = Pattern.compile("//(module|package) (.*)").matcher(line);
                if (!matcher.matches()) continue;
                if (matcher.group(1).equals("module")) {
                    moduleClass = matcher.group(2);
                    continue;
                }
                packages.add(matcher.group(2));
            }
            simpleEntry = new AbstractMap.SimpleEntry(moduleClass, packages);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException | NoSuchFileException e) {
                return null;
            }
        }
        reader.close();
        return simpleEntry;
    }

    public static Map<String, List<String>> readPackageClass(Filer filer, String packageName, CharSequence classPrefix) throws IOException {
        HashMap<String, List<String>> hashMap;
        String packageImplPath = String.format("%s/%sPackageImpl.java", packageName.replace(".", "/"), classPrefix);
        FileObject sourceFile = filer.getResource(StandardLocation.SOURCE_OUTPUT, "", packageImplPath);
        BufferedReader reader = new BufferedReader(sourceFile.openReader(false));
        try {
            String line;
            HashMap<String, List<String>> components = new HashMap<String, List<String>>();
            String currentComponent = null;
            ArrayList<String> currentSource = null;
            while ((line = reader.readLine()) != null) {
                Matcher matcher = Pattern.compile("//(start |end)(.*)").matcher(line);
                if (matcher.matches()) {
                    if (matcher.group(1).equals("start ")) {
                        if (currentComponent != null) {
                            components.put(currentComponent, (List<String>)currentSource);
                        }
                        currentComponent = matcher.group(2);
                        currentSource = new ArrayList<String>();
                        currentSource.add(line);
                        continue;
                    }
                    components.put(currentComponent, (List<String>)currentSource);
                    currentComponent = null;
                    currentSource = null;
                    continue;
                }
                if (currentComponent == null) continue;
                currentSource.add(line);
            }
            hashMap = components;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException | NoSuchFileException e) {
                return null;
            }
        }
        reader.close();
        return hashMap;
    }

    private CharSequence stringLiteral(String value) {
        return value == null ? null : "\"" + value + "\"";
    }

    private CharSequence listLiteral(List<? extends CharSequence> list) {
        if (list == null || list.isEmpty()) {
            return "Collections.emptyList()";
        }
        StringBuilder sb = new StringBuilder("Arrays.asList(");
        boolean first = true;
        for (CharSequence charSequence : list) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append('\"').append(charSequence).append('\"');
        }
        sb.append(')');
        return sb;
    }

    private String optionalComma(int index, int size) {
        return index + 1 < size ? "," : "";
    }
}

