/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.io;

import java.io.OutputStream;
import java.util.Arrays;
import org.infinispan.commons.util.Util;

public final class LazyByteArrayOutputStream
extends OutputStream {
    public static final int DEFAULT_SIZE = 32;
    public static final int DEFAULT_DOUBLING_SIZE = 0x400000;
    private byte[] buf;
    private int count;
    private int maxDoublingSize = 0x400000;

    public LazyByteArrayOutputStream() {
        this.buf = null;
    }

    public LazyByteArrayOutputStream(int size) {
        this.buf = new byte[size];
    }

    public LazyByteArrayOutputStream(int size, int maxDoublingSize) {
        this(size);
        this.maxDoublingSize = maxDoublingSize;
    }

    public byte[] getRawBuffer() {
        if (this.buf == null) {
            return Util.EMPTY_BYTE_ARRAY;
        }
        return this.buf;
    }

    public byte[] getTrimmedBuffer() {
        if (this.buf == null) {
            return Util.EMPTY_BYTE_ARRAY;
        }
        if (this.buf.length == this.count) {
            return this.buf;
        }
        return Arrays.copyOf(this.buf, this.count);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int newcount = this.count + len;
        this.ensureCapacity(newcount);
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count = newcount;
    }

    @Override
    public void write(int b) {
        int newcount = this.count + 1;
        this.ensureCapacity(newcount);
        this.buf[this.count] = (byte)b;
        this.count = newcount;
    }

    private void ensureCapacity(int newcount) {
        if (this.buf == null) {
            this.buf = new byte[Math.max(32, newcount)];
        } else if (newcount > this.buf.length) {
            byte[] newbuf = new byte[this.getNewBufferSize(this.buf.length, newcount)];
            System.arraycopy(this.buf, 0, newbuf, 0, this.count);
            this.buf = newbuf;
        }
    }

    public final int getMaxDoublingSize() {
        return this.maxDoublingSize;
    }

    public int getNewBufferSize(int curSize, int minNewSize) {
        if (curSize <= this.maxDoublingSize) {
            return Math.max(curSize << 1, minNewSize);
        }
        return Math.max(curSize + (curSize >> 2), minNewSize);
    }

    public int size() {
        return this.count;
    }
}

