/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.configuration.io;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import org.infinispan.commons.configuration.io.ConfigurationWriter;
import org.infinispan.commons.configuration.io.NamingStrategy;
import org.infinispan.commons.util.Util;

public abstract class AbstractConfigurationWriter
implements ConfigurationWriter {
    protected final Writer writer;
    protected final Deque<Tag> tagStack = new ArrayDeque<Tag>();
    protected final Map<String, String> namespaces = new HashMap<String, String>();
    protected int currentIndent = 0;
    private final int indent;
    protected final boolean prettyPrint;
    protected final boolean clearTextSecrets;
    protected final boolean namespaceAware;
    protected final NamingStrategy naming;

    protected AbstractConfigurationWriter(ConfigurationWriter.Builder builder, NamingStrategy naming) {
        this.writer = builder.writer();
        this.indent = builder.indent();
        this.prettyPrint = builder.prettyPrint();
        this.clearTextSecrets = builder.clearTextSecrets();
        this.namespaceAware = builder.namespaceAware();
        this.naming = naming;
    }

    @Override
    public boolean clearTextSecrets() {
        return this.clearTextSecrets;
    }

    @Override
    public boolean namespaceAware() {
        return this.namespaceAware;
    }

    @Override
    public void writeStartElement(Enum<?> name) {
        this.writeStartElement(name.toString());
    }

    @Override
    public void writeStartElement(String prefix, String namespace, Enum<?> name) {
        this.writeStartElement(prefix, namespace, name.toString());
    }

    @Override
    public void writeStartArrayElement(Enum<?> name) {
        this.writeStartArrayElement(name.toString());
    }

    @Override
    public void writeArrayElement(Enum<?> outer, Enum<?> inner, Enum<?> attribute, Iterable<String> values) {
        this.writeArrayElement(outer.toString(), inner.toString(), attribute != null ? attribute.toString() : null, values);
    }

    @Override
    public void writeStartListElement(Enum<?> name, boolean explicit) {
        this.writeStartListElement(name.toString(), explicit);
    }

    @Override
    public void writeStartListElement(String prefix, String namespace, Enum<?> name, boolean explicit) {
        this.writeStartListElement(prefix, namespace, name.toString(), explicit);
    }

    @Override
    public void writeEndListElement() {
        this.writeEndElement();
    }

    @Override
    public void writeAttribute(Enum<?> name, String value) {
        this.writeAttribute(name.toString(), value);
    }

    @Override
    public void writeAttribute(Enum<?> name, Iterable<String> value) {
        this.writeAttribute(name.toString(), value);
    }

    @Override
    public void writeAttribute(Enum<?> name, boolean value) {
        this.writeAttribute(name.toString(), value);
    }

    @Override
    public void writeAttribute(String name, boolean value) {
        this.writeAttribute(name, String.valueOf(value));
    }

    @Override
    public void writeEmptyElement(Enum<?> name) {
        this.writeEmptyElement(name.toString());
    }

    @Override
    public void writeStartMap(Enum<?> name) {
        this.writeStartMap(name.toString());
    }

    @Override
    public void writeMapItem(Enum<?> element, Enum<?> name, String key, String value) {
        this.writeMapItem(element.toString(), name.toString(), key, value);
    }

    @Override
    public void writeMapItem(Enum<?> element, Enum<?> name, String key) {
        this.writeMapItem(element.toString(), name.toString(), key);
    }

    protected void nl() throws IOException {
        if (this.prettyPrint) {
            this.writer.write(System.lineSeparator());
        }
    }

    protected void tab() throws IOException {
        if (this.prettyPrint) {
            for (int i = 0; i < this.currentIndent; ++i) {
                this.writer.write(32);
            }
        }
    }

    protected void indent() {
        this.currentIndent += this.indent;
    }

    protected void outdent() {
        this.currentIndent -= this.indent;
    }

    @Override
    public void close() {
        Util.close((AutoCloseable)this.writer);
    }

    public record Tag(String name, boolean repeating, boolean explicitOuter, boolean explicitInner) {
        public Tag(String name) {
            this(name, false, false, true);
        }
    }
}

