/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.math.BigDecimal;
import java.time.Duration;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.infinispan.commons.configuration.attributes.AttributeParser;
import org.infinispan.commons.configuration.attributes.Matchable;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;

public class TimeQuantity
extends Number
implements Matchable<TimeQuantity> {
    private static final TimeQuantity ZERO = new TimeQuantity(null, 0L);
    private static final Pattern REGEX_PATTERN = Pattern.compile("^(-?\\d*\\.?\\d+)\\s*(ms|s|m|h|d)?$");
    private static final Log log = LogFactory.getLog(TimeQuantity.class);
    public static AttributeParser<TimeQuantity> PARSER = new TimeQuantityAttributeParser();
    private final String s;
    private final long l;

    private TimeQuantity(String s, long l) {
        this.s = s;
        this.l = l;
    }

    @Override
    public long longValue() {
        return this.l;
    }

    @Override
    public int intValue() {
        return (int)this.l;
    }

    @Override
    public float floatValue() {
        return this.l;
    }

    @Override
    public double doubleValue() {
        return this.l;
    }

    public Duration toDuration() {
        return Duration.ofMillis(this.l);
    }

    public String toString() {
        return this.s != null ? this.s : Long.toString(this.l);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeQuantity that = (TimeQuantity)o;
        return this.l == that.l;
    }

    public int hashCode() {
        return Objects.hashCode(this.l);
    }

    public static TimeQuantity valueOf(String s) throws IllegalArgumentException {
        return TimeQuantity.valueOf(s, 0L);
    }

    public static TimeQuantity valueOf(long l) {
        return TimeQuantity.valueOf(null, l);
    }

    public static TimeQuantity valueOf(String s, long defaultValue) throws IllegalArgumentException {
        if (s == null) {
            return defaultValue == 0L ? ZERO : new TimeQuantity(null, defaultValue);
        }
        Matcher matcher = REGEX_PATTERN.matcher(s);
        if (!matcher.find()) {
            throw log.cannotParseQuantity(s);
        }
        try {
            long value;
            String numberPart = matcher.group(1);
            String unit = matcher.group(2);
            BigDecimal number = new BigDecimal(numberPart);
            if (unit == null) {
                if (numberPart.contains(".")) {
                    throw log.cannotParseQuantity(s);
                }
                value = number.longValueExact();
            } else {
                value = Unit.valueOf(unit).toMilliseconds(number);
            }
            return new TimeQuantity(s, value);
        }
        catch (ArithmeticException e) {
            throw log.cannotParseQuantity(s);
        }
    }

    public static enum Unit {
        ms(1L),
        s(1000L),
        m(60000L),
        h(3600000L),
        d(86400000L);

        final BigDecimal factor;

        private Unit(long factor) {
            this.factor = BigDecimal.valueOf(factor);
        }

        public long toMilliseconds(BigDecimal quantity) {
            return quantity.multiply(this.factor).longValue();
        }
    }

    static class TimeQuantityAttributeParser
    implements AttributeParser<TimeQuantity> {
        TimeQuantityAttributeParser() {
        }

        @Override
        public TimeQuantity parse(Class<?> klass, String value) {
            return TimeQuantity.valueOf(value);
        }
    }
}

