/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.test;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InaccessibleObjectException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.infinispan.commons.test.PolarionJUnitTest;
import org.infinispan.commons.test.PolarionJUnitXMLWriter;
import org.infinispan.commons.test.TestSuiteProgress;
import org.jboss.logging.Logger;

public class ThreadLeakChecker {
    private static final Pattern IGNORED_THREADS_REGEX = Pattern.compile("(testng-|RunningTestsRegistry-Worker|test-timeout-thread|Time-limited test|ForkJoinPool.commonPool-|HttpClient|RxCachedWorkerPoolEvictor|RxSchedulerPurge|globalEventExecutor|Transaction Reaper|Generate Seed|Keep-Alive-Timer|Attach Listener|Hibernate Search sync consumer thread for index|NioConnection.Reader|process reaper|XNIO-1 |ExpiringMapExpirer|Reference Reaper|remoting-jmx client|management-client-thread|ClassCache Reaper|SecurityDomain ThreadGroup|ducttape|testcontainers|mysql-cj-abandoned-connection-cleanup|CompletableFutureDelayScheduler|ForkJoinPool|Write-Updater|Write-Poller|VirtualThread-unparker|Read-Updater|Read-Poller|Listener:[0-9]|JVMCI-native CompilerThread[0-9]).*");
    private static final String ARQUILLIAN_CONSOLE_CONSUMER = "org.jboss.as.arquillian.container.CommonManagedDeployableContainer$ConsoleConsumer";
    private static final boolean ENABLED = "true".equalsIgnoreCase(System.getProperty("infinispan.test.checkThreadLeaks", "true"));
    private static final Logger log = Logger.getLogger(ThreadLeakChecker.class);
    private static final Map<Thread, LeakInfo> runningThreads = new ConcurrentHashMap<Thread, LeakInfo>();
    private static final Lock lock = new ReentrantLock();
    private static final LeakException IGNORED = new LeakException("IGNORED");
    private static final LeakException UNKNOWN = new LeakException("UNKNOWN");
    private static final ThreadInfoLocal threadInfo = new ThreadInfoLocal();

    public static void testStarted(String testName) {
        threadInfo.set(new LeakException(testName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveInitialThreads() {
        lock.lock();
        try {
            Set<Thread> currentThreads = ThreadLeakChecker.getThreadsSnapshot();
            for (Thread thread : currentThreads) {
                LeakInfo leakInfo = new LeakInfo(thread, IGNORED);
                runningThreads.putIfAbsent(thread, leakInfo);
            }
        }
        finally {
            lock.unlock();
        }
        threadInfo.set(UNKNOWN);
    }

    public static void testFinished(String testName) {
        threadInfo.set(new LeakException("after-" + testName));
    }

    private static void updateThreadOwnership(String testName) {
        Field valueField;
        Method getEntryMethod;
        Field threadLocalsField;
        Set<Thread> currentThreads = ThreadLeakChecker.getThreadsSnapshot();
        runningThreads.keySet().retainAll(currentThreads);
        try {
            threadLocalsField = Thread.class.getDeclaredField("inheritableThreadLocals");
            threadLocalsField.setAccessible(true);
            getEntryMethod = Class.forName("java.lang.ThreadLocal$ThreadLocalMap").getDeclaredMethod("getEntry", ThreadLocal.class);
            getEntryMethod.setAccessible(true);
            valueField = Class.forName("java.lang.ThreadLocal$ThreadLocalMap$Entry").getDeclaredField("value");
            valueField.setAccessible(true);
        }
        catch (ClassNotFoundException | NoSuchFieldException | NoSuchMethodException | InaccessibleObjectException e) {
            log.error((Object)"Error obtaining thread local accessors, ignoring thread leaks", (Throwable)e);
            return;
        }
        for (Thread thread : currentThreads) {
            if (runningThreads.containsKey(thread)) continue;
            try {
                Object threadLocalsMap = threadLocalsField.get(thread);
                Object entry = threadLocalsMap != null ? getEntryMethod.invoke(threadLocalsMap, threadInfo) : null;
                LeakException stacktrace = entry != null ? (LeakException)valueField.get(entry) : new LeakException(testName);
                runningThreads.putIfAbsent(thread, new LeakInfo(thread, stacktrace));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                log.error((Object)("Error extracting backtrace of leaked thread " + thread.getName()));
            }
        }
    }

    public static void checkForLeaks(String lastTestName) {
        if (!ENABLED) {
            return;
        }
        lock.lock();
        try {
            ThreadLeakChecker.performCheck(lastTestName);
        }
        finally {
            lock.unlock();
        }
    }

    private static void performCheck(String lastTestName) {
        String ownerTest = "UNKNOWN[" + lastTestName + "]";
        ThreadLeakChecker.updateThreadOwnership(ownerTest);
        List<LeakInfo> leaks = ThreadLeakChecker.computeLeaks();
        if (!leaks.isEmpty()) {
            try {
                Thread.sleep(1500L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            ThreadLeakChecker.updateThreadOwnership(ownerTest);
            leaks = ThreadLeakChecker.computeLeaks();
        }
        if (!leaks.isEmpty()) {
            try {
                File reportsDir = new File("target/surefire-reports");
                if (!reportsDir.exists() && !reportsDir.mkdirs()) {
                    throw new IOException("Cannot create report directory " + reportsDir.getAbsolutePath());
                }
                PolarionJUnitXMLWriter writer = new PolarionJUnitXMLWriter(new File(reportsDir, "TEST-ThreadLeakChecker" + lastTestName + ".xml"));
                String property = System.getProperty("infinispan.modulesuffix");
                String moduleName = property != null ? property.substring(1) : "";
                writer.start(moduleName, leaks.size(), 0L, leaks.size(), 0L, false);
                for (LeakInfo leakInfo : leaks) {
                    String testName = "ThreadLeakChecker";
                    for (Throwable cause = leakInfo.stacktrace; cause != null; cause = cause.getCause()) {
                        testName = cause.getMessage();
                    }
                    LeakException exception = new LeakException("Leaked thread: " + leakInfo.thread.getName(), leakInfo.stacktrace);
                    exception.setStackTrace(leakInfo.thread.getStackTrace());
                    TestSuiteProgress.fakeTestFailure(testName + ".ThreadLeakChecker", exception);
                    writer.writeTestCase(new PolarionJUnitTest("ThreadLeakChecker", testName, exception));
                    leakInfo.markReported();
                }
                writer.close();
            }
            catch (Exception e) {
                throw new RuntimeException("Error reporting thread leaks", e);
            }
        }
    }

    private static List<LeakInfo> computeLeaks() {
        ArrayList<LeakInfo> leaks = new ArrayList<LeakInfo>();
        for (LeakInfo leakInfo : runningThreads.values()) {
            if (!leakInfo.shouldReport() || !leakInfo.thread.isAlive() || ThreadLeakChecker.ignore(leakInfo.thread)) continue;
            leaks.add(leakInfo);
        }
        return leaks;
    }

    private static boolean ignore(Thread thread) {
        String threadName = thread.getName();
        if (IGNORED_THREADS_REGEX.matcher(threadName).matches()) {
            return true;
        }
        if (thread.getName().startsWith("Thread-")) {
            StackTraceElement[] s;
            if (thread.getClass().getName().equals("org.jboss.byteman.agent.TransformListener")) {
                return true;
            }
            for (StackTraceElement ste : s = thread.getStackTrace()) {
                if (!ste.getClassName().equals(ARQUILLIAN_CONSOLE_CONSUMER)) continue;
                return true;
            }
        }
        return false;
    }

    private static String prettyPrintStacktrace(StackTraceElement[] stackTraceElements) {
        StringBuilder sb = new StringBuilder();
        for (StackTraceElement ste : stackTraceElements) {
            sb.append("\tat ").append(ste).append('\n');
        }
        return sb.toString();
    }

    private static Set<Thread> getThreadsSnapshot() {
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        while (group.getParent() != null) {
            group = group.getParent();
        }
        int capacity = group.activeCount() * 2;
        Thread[] threadsArray;
        int count;
        while ((count = group.enumerate(threadsArray = new Thread[capacity], true)) >= capacity) {
            capacity = count * 2;
        }
        return Arrays.stream(threadsArray, 0, count).collect(Collectors.toSet());
    }

    public static void ignoreThreadsMatching(Predicate<Thread> filter) {
        Set<Thread> currentThreads = ThreadLeakChecker.getThreadsSnapshot();
        for (Thread thread : currentThreads) {
            if (!filter.test(thread)) continue;
            ThreadLeakChecker.ignoreThread(thread);
        }
    }

    public static void ignoreThread(Thread thread) {
        runningThreads.computeIfAbsent(thread, k -> new LeakInfo(thread, IGNORED));
    }

    public static void ignoreThreadsContaining(String threadNameRegex) {
        Pattern pattern = Pattern.compile(".*" + threadNameRegex + ".*");
        ThreadLeakChecker.ignoreThreadsMatching(thread -> pattern.matcher(thread.getName()).matches());
    }

    private static class ThreadInfoLocal
    extends InheritableThreadLocal<LeakException> {
        private ThreadInfoLocal() {
        }

        @Override
        protected LeakException childValue(LeakException parentValue) {
            return new LeakException(Thread.currentThread().getName(), parentValue);
        }
    }

    private static class LeakException
    extends Exception {
        private static final long serialVersionUID = 2192447894828825555L;

        LeakException(String testName) {
            super(testName, null, false, false);
        }

        LeakException(String message, LeakException parent) {
            super(message + " << " + parent.getMessage(), parent, false, true);
        }
    }

    private static class LeakInfo {
        final Thread thread;
        final LeakException stacktrace;
        boolean reported;

        LeakInfo(Thread thread, LeakException stacktrace) {
            this.thread = thread;
            this.stacktrace = stacktrace;
        }

        void markReported() {
            this.reported = true;
        }

        boolean shouldReport() {
            return this.stacktrace != IGNORED && !this.reported;
        }

        public String toString() {
            Object owners = this.stacktrace == IGNORED ? "ignored" : "created by " + this.stacktrace.getMessage();
            return "{" + this.thread.getName() + ": " + (String)owners + "}";
        }
    }
}

