/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.rest.impl.jdk.auth;

import java.net.http.HttpClient;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.infinispan.client.rest.configuration.AuthenticationConfiguration;
import org.infinispan.client.rest.impl.jdk.auth.BasicAuthenticator;
import org.infinispan.client.rest.impl.jdk.auth.BearerAuthenticator;
import org.infinispan.client.rest.impl.jdk.auth.DigestAuthenticator;
import org.infinispan.client.rest.impl.jdk.auth.HttpAuthenticator;
import org.infinispan.client.rest.impl.jdk.auth.NegotiateAuthenticator;

public class AutoDetectAuthenticator
extends HttpAuthenticator {
    private final BasicAuthenticator basic;
    private final BearerAuthenticator bearer;
    private final DigestAuthenticator digest;
    private final NegotiateAuthenticator negotiate;

    public AutoDetectAuthenticator(HttpClient client, AuthenticationConfiguration configuration) {
        super(client, configuration);
        this.basic = new BasicAuthenticator(client, configuration);
        this.bearer = new BearerAuthenticator(client, configuration);
        this.digest = new DigestAuthenticator(client, configuration);
        this.negotiate = new NegotiateAuthenticator(client, configuration);
    }

    @Override
    public <T> CompletionStage<HttpResponse<T>> authenticate(HttpResponse<T> response, HttpResponse.BodyHandler<?> bodyHandler) {
        List<String> headers = response.headers().allValues("www-authenticate");
        for (String header : headers) {
            String mech;
            int space = header.indexOf(32);
            switch (mech = header.substring(0, space)) {
                case "Digest": {
                    return this.digest.authenticate(response, bodyHandler);
                }
                case "Basic": {
                    return this.basic.authenticate(response, bodyHandler);
                }
                case "Bearer": {
                    return this.bearer.authenticate(response, bodyHandler);
                }
                case "Negotiate": {
                    return this.negotiate.authenticate(response, bodyHandler);
                }
            }
        }
        return null;
    }
}

