/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.rest.configuration;

import org.infinispan.client.rest.configuration.AbstractConfigurationChildBuilder;
import org.infinispan.client.rest.configuration.AuthenticationConfigurationBuilder;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.client.rest.configuration.SecurityConfiguration;
import org.infinispan.client.rest.configuration.SslConfigurationBuilder;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.AttributeSet;

public class SecurityConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<SecurityConfiguration> {
    private final AuthenticationConfigurationBuilder authentication = new AuthenticationConfigurationBuilder(this);
    private final SslConfigurationBuilder ssl = new SslConfigurationBuilder(this);

    SecurityConfigurationBuilder(RestClientConfigurationBuilder builder) {
        super(builder);
    }

    public AttributeSet attributes() {
        return AttributeSet.EMPTY;
    }

    public AuthenticationConfigurationBuilder authentication() {
        return this.authentication;
    }

    public SslConfigurationBuilder ssl() {
        return this.ssl;
    }

    public SecurityConfiguration create() {
        return new SecurityConfiguration(this.authentication.create(), this.ssl.create());
    }

    public Builder<?> read(SecurityConfiguration template, Combine combine) {
        this.authentication.read(template.authentication(), combine);
        this.ssl.read(template.ssl(), combine);
        return this;
    }

    public void validate() {
        this.authentication.validate();
        this.ssl.validate();
    }

    RestClientConfigurationBuilder getBuilder() {
        return this.builder;
    }
}

