/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.rest.impl.jdk;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.infinispan.client.rest.IpFilterRule;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.client.rest.RestLoggingClient;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.RestServerClient;
import org.infinispan.client.rest.impl.jdk.RestLoggingClientJDK;
import org.infinispan.client.rest.impl.jdk.RestRawClientJDK;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.internal.Json;

public class RestServerClientJDK
implements RestServerClient {
    private final RestRawClientJDK client;
    private final String path;

    RestServerClientJDK(RestRawClientJDK restClient) {
        this.client = restClient;
        this.path = restClient.getConfiguration().contextPath() + "/v2/server";
    }

    @Override
    public CompletionStage<RestResponse> configuration() {
        return this.client.get(this.path + "/config");
    }

    @Override
    public CompletionStage<RestResponse> stop() {
        return this.client.post(this.path + "?action=stop");
    }

    @Override
    public CompletionStage<RestResponse> overviewReport() {
        return this.client.get(this.path + "/overview-report");
    }

    @Override
    public CompletionStage<RestResponse> threads() {
        return this.client.get(this.path + "/threads");
    }

    @Override
    public CompletionStage<RestResponse> info() {
        return this.client.get(this.path);
    }

    @Override
    public CompletionStage<RestResponse> memory() {
        return this.client.get(this.path + "/memory");
    }

    @Override
    public CompletionStage<RestResponse> heapDump(boolean live) {
        return this.client.post(this.path + "/memory?action=heap-dump&live=" + live);
    }

    @Override
    public CompletionStage<RestResponse> env() {
        return this.client.get(this.path + "/env");
    }

    @Override
    public CompletionStage<RestResponse> report() {
        return this.client.get(this.path + "/report", Map.of("Accept", "application/gzip", "Accept-Encoding", "gzip"));
    }

    @Override
    public CompletionStage<RestResponse> report(String node) {
        return this.client.get(this.path + "/report/" + node, Map.of("Accept", "application/gzip", "Accept-Encoding", "gzip"));
    }

    @Override
    public CompletionStage<RestResponse> ignoreCache(String cacheName) {
        return this.client.post(this.path + "/ignored-caches/" + cacheName);
    }

    @Override
    public CompletionStage<RestResponse> unIgnoreCache(String cacheName) {
        return this.client.delete(this.path + "/ignored-caches/" + cacheName);
    }

    @Override
    public CompletionStage<RestResponse> listIgnoredCaches() {
        return this.client.get(this.path + "/ignored-caches");
    }

    @Override
    public RestLoggingClient logging() {
        return new RestLoggingClientJDK(this.client);
    }

    @Override
    public CompletionStage<RestResponse> listConnections(boolean global) {
        return this.client.get(this.path + "/connections?global=" + global);
    }

    @Override
    public CompletionStage<RestResponse> connectorNames() {
        return this.client.get(this.path + "/connectors");
    }

    @Override
    public CompletionStage<RestResponse> connectorStart(String name) {
        return this.client.post(this.path + "/connectors/" + name + "?action=start");
    }

    @Override
    public CompletionStage<RestResponse> connectorStop(String name) {
        return this.client.post(this.path + "/connectors/" + name + "?action=stop");
    }

    @Override
    public CompletionStage<RestResponse> connector(String name) {
        return this.client.get(this.path + "/connectors/" + name);
    }

    @Override
    public CompletionStage<RestResponse> connectorIpFilters(String name) {
        return this.client.get(this.path + "/connectors/" + name + "/ip-filter");
    }

    @Override
    public CompletionStage<RestResponse> connectorIpFiltersClear(String name) {
        return this.client.delete(this.path + "/connectors/" + name + "/ip-filter");
    }

    @Override
    public CompletionStage<RestResponse> connectorIpFilterSet(String name, List<IpFilterRule> rules) {
        String url = String.format("%s/connectors/%s/ip-filter", this.path, name);
        Json json = Json.array();
        for (IpFilterRule rule : rules) {
            json.add(Json.object().set("type", (Object)rule.getType().name()).set("cidr", (Object)rule.getCidr()));
        }
        return this.client.post(url, RestEntity.create(MediaType.APPLICATION_JSON, json.toString()));
    }

    @Override
    public CompletionStage<RestResponse> dataSourceNames() {
        return this.client.get(this.path + "/datasources");
    }

    @Override
    public CompletionStage<RestResponse> dataSourceTest(String name) {
        return this.client.post(this.path + "/datasources/" + name + "?action=test");
    }

    @Override
    public CompletionStage<RestResponse> cacheConfigDefaults() {
        return this.client.get(this.path + "/caches/defaults");
    }
}

