/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.rest.impl.okhttp;

import java.util.concurrent.CompletionStage;
import okhttp3.FormBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.infinispan.client.rest.RestLoggingClient;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.RestServerClient;
import org.infinispan.client.rest.impl.okhttp.RestClientOkHttp;
import org.infinispan.client.rest.impl.okhttp.RestLoggingClientOkHttp;

public class RestServerClientOkHttp
implements RestServerClient {
    private final RestClientOkHttp client;
    private final String baseServerURL;

    RestServerClientOkHttp(RestClientOkHttp restClient) {
        this.client = restClient;
        this.baseServerURL = String.format("%s%s/v2/server", restClient.getBaseURL(), restClient.getConfiguration().contextPath()).replaceAll("//", "/");
    }

    @Override
    public CompletionStage<RestResponse> configuration() {
        return this.client.execute(this.baseServerURL, "config");
    }

    @Override
    public CompletionStage<RestResponse> stop() {
        Request.Builder builder = new Request.Builder().post(RestClientOkHttp.EMPTY_BODY).url(this.baseServerURL + "?action=stop");
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> threads() {
        return this.client.execute(this.baseServerURL, "threads");
    }

    @Override
    public CompletionStage<RestResponse> info() {
        return this.client.execute(this.baseServerURL, new String[0]);
    }

    @Override
    public CompletionStage<RestResponse> memory() {
        return this.client.execute(this.baseServerURL, "memory");
    }

    @Override
    public CompletionStage<RestResponse> env() {
        return this.client.execute(this.baseServerURL, "env");
    }

    @Override
    public CompletionStage<RestResponse> report() {
        return this.client.execute(this.baseServerURL, "report");
    }

    @Override
    public CompletionStage<RestResponse> ignoreCache(String cacheManagerName, String cacheName) {
        return this.ignoreCacheOp(cacheManagerName, cacheName, "POST");
    }

    @Override
    public CompletionStage<RestResponse> unIgnoreCache(String cacheManagerName, String cacheName) {
        return this.ignoreCacheOp(cacheManagerName, cacheName, "DELETE");
    }

    private CompletionStage<RestResponse> ignoreCacheOp(String cacheManagerName, String cacheName, String method) {
        String url = String.format("%s/ignored-caches/%s/%s", this.baseServerURL, cacheManagerName, cacheName);
        Request.Builder builder = new Request.Builder().url(url).method(method, (RequestBody)new FormBody.Builder().build());
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> listIgnoredCaches(String cacheManagerName) {
        String url = String.format("%s/ignored-caches/%s", this.baseServerURL, cacheManagerName);
        return this.client.execute(new Request.Builder().url(url));
    }

    @Override
    public RestLoggingClient logging() {
        return new RestLoggingClientOkHttp(this.client);
    }
}

