/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.rest.configuration;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.infinispan.client.rest.configuration.Protocol;
import org.infinispan.client.rest.configuration.RestClientConfiguration;
import org.infinispan.client.rest.configuration.RestClientConfigurationChildBuilder;
import org.infinispan.client.rest.configuration.SecurityConfigurationBuilder;
import org.infinispan.client.rest.configuration.ServerConfiguration;
import org.infinispan.client.rest.configuration.ServerConfigurationBuilder;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.util.TypedProperties;

public class RestClientConfigurationBuilder
implements RestClientConfigurationChildBuilder,
Builder<RestClientConfiguration> {
    private static final Pattern ADDRESS_PATTERN = Pattern.compile("(\\[([0-9A-Fa-f:]+)\\]|([^:/?#]*))(?::(\\d*))?");
    private long connectionTimeout = 60000L;
    private long socketTimeout = 60000L;
    private final List<ServerConfigurationBuilder> servers;
    private final SecurityConfigurationBuilder security;
    private boolean tcpNoDelay = true;
    private boolean tcpKeepAlive = false;
    private Protocol protocol = Protocol.HTTP_11;
    private String contextPath = "/rest";
    private boolean priorKnowledge;
    private boolean followRedirects = true;

    public RestClientConfigurationBuilder() {
        this.security = new SecurityConfigurationBuilder(this);
        this.servers = new ArrayList<ServerConfigurationBuilder>();
    }

    @Override
    public ServerConfigurationBuilder addServer() {
        ServerConfigurationBuilder builder = new ServerConfigurationBuilder(this);
        this.servers.add(builder);
        return builder;
    }

    @Override
    public RestClientConfigurationBuilder addServers(String servers) {
        RestClientConfigurationBuilder.parseServers(servers, (host, port) -> this.addServer().host((String)host).port((int)port));
        return this;
    }

    public static final void parseServers(String servers, BiConsumer<String, Integer> c) {
        for (String server : servers.split(";")) {
            Matcher matcher = ADDRESS_PATTERN.matcher(server.trim());
            if (!matcher.matches()) {
                throw new IllegalArgumentException(server);
            }
            String v6host = matcher.group(2);
            String v4host = matcher.group(3);
            String host = v6host != null ? v6host : v4host;
            String portString = matcher.group(4);
            int port = portString == null ? 11222 : Integer.parseInt(portString);
            c.accept(host, port);
        }
    }

    @Override
    public RestClientConfigurationBuilder protocol(Protocol protocol) {
        this.protocol = protocol;
        return this;
    }

    @Override
    public RestClientConfigurationBuilder priorKnowledge(boolean enabled) {
        this.priorKnowledge = enabled;
        return this;
    }

    @Override
    public RestClientConfigurationBuilder followRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
        return this;
    }

    @Override
    public RestClientConfigurationBuilder connectionTimeout(long connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    @Override
    public SecurityConfigurationBuilder security() {
        return this.security;
    }

    @Override
    public RestClientConfigurationBuilder socketTimeout(long socketTimeout) {
        this.socketTimeout = socketTimeout;
        return this;
    }

    @Override
    public RestClientConfigurationBuilder tcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
        return this;
    }

    @Override
    public RestClientConfigurationBuilder tcpKeepAlive(boolean keepAlive) {
        this.tcpKeepAlive = keepAlive;
        return this;
    }

    public RestClientConfigurationBuilder contextPath(String contextPath) {
        this.contextPath = contextPath;
        return this;
    }

    @Override
    public RestClientConfigurationBuilder withProperties(Properties properties) {
        TypedProperties typed = TypedProperties.toTypedProperties((Properties)properties);
        this.protocol((Protocol)typed.getEnumProperty("infinispan.client.rest.protocol", Protocol.class, (Enum)this.protocol, true));
        this.connectionTimeout(typed.getLongProperty("infinispan.client.rest.connect_timeout", this.connectionTimeout, true));
        String serverList = typed.getProperty("infinispan.client.rest.server_list", null, true);
        if (serverList != null) {
            this.servers.clear();
            this.addServers(serverList);
        }
        this.contextPath(typed.getProperty("infinispan.client.rest.context_path", this.contextPath, true));
        this.socketTimeout(typed.getLongProperty("infinispan.client.rest.socket_timeout", this.socketTimeout, true));
        this.tcpNoDelay(typed.getBooleanProperty("infinispan.client.rest.tcp_no_delay", this.tcpNoDelay, true));
        this.tcpKeepAlive(typed.getBooleanProperty("infinispan.client.rest.tcp_keep_alive", this.tcpKeepAlive, true));
        this.security.ssl().withProperties(properties);
        this.security.authentication().withProperties(properties);
        return this;
    }

    public void validate() {
        this.security.validate();
    }

    public RestClientConfiguration create() {
        ArrayList<ServerConfiguration> servers = new ArrayList<ServerConfiguration>();
        if (this.servers.size() > 0) {
            for (ServerConfigurationBuilder server : this.servers) {
                servers.add(server.create());
            }
        } else {
            servers.add(new ServerConfiguration("127.0.0.1", 11222));
        }
        return new RestClientConfiguration(servers, this.protocol, this.connectionTimeout, this.socketTimeout, this.security.create(), this.tcpNoDelay, this.tcpKeepAlive, this.contextPath, this.priorKnowledge, this.followRedirects);
    }

    @Override
    public RestClientConfiguration build() {
        return this.build(true);
    }

    public RestClientConfiguration build(boolean validate) {
        if (validate) {
            this.validate();
        }
        return this.create();
    }

    public RestClientConfigurationBuilder read(RestClientConfiguration template) {
        this.connectionTimeout = template.connectionTimeout();
        this.servers.clear();
        for (ServerConfiguration server : template.servers()) {
            this.addServer().host(server.host()).port(server.port());
        }
        this.socketTimeout = template.socketTimeout();
        this.security.read(template.security());
        this.tcpNoDelay = template.tcpNoDelay();
        this.tcpKeepAlive = template.tcpKeepAlive();
        return this;
    }
}

