/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.rest.configuration;

import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.infinispan.client.rest.configuration.Protocol;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.client.rest.configuration.SecurityConfiguration;
import org.infinispan.client.rest.configuration.ServerConfiguration;
import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.util.TypedProperties;

@BuiltBy(value=RestClientConfigurationBuilder.class)
public class RestClientConfiguration {
    private final long connectionTimeout;
    private final List<ServerConfiguration> servers;
    private final long socketTimeout;
    private final SecurityConfiguration security;
    private final boolean tcpNoDelay;
    private final boolean tcpKeepAlive;
    private final Protocol protocol;
    private final String contextPath;
    private final boolean priorKnowledge;
    private final boolean followRedirects;

    RestClientConfiguration(List<ServerConfiguration> servers, Protocol protocol, long connectionTimeout, long socketTimeout, SecurityConfiguration security, boolean tcpNoDelay, boolean tcpKeepAlive, String contextPath, boolean priorKnowledge, boolean followRedirects) {
        this.servers = Collections.unmodifiableList(servers);
        this.protocol = protocol;
        this.connectionTimeout = connectionTimeout;
        this.socketTimeout = socketTimeout;
        this.security = security;
        this.tcpNoDelay = tcpNoDelay;
        this.tcpKeepAlive = tcpKeepAlive;
        this.contextPath = contextPath;
        this.priorKnowledge = priorKnowledge;
        this.followRedirects = followRedirects;
    }

    public Protocol protocol() {
        return this.protocol;
    }

    public boolean priorKnowledge() {
        return this.priorKnowledge;
    }

    public boolean followRedirects() {
        return this.followRedirects;
    }

    public long connectionTimeout() {
        return this.connectionTimeout;
    }

    public List<ServerConfiguration> servers() {
        return this.servers;
    }

    public long socketTimeout() {
        return this.socketTimeout;
    }

    public SecurityConfiguration security() {
        return this.security;
    }

    public boolean tcpNoDelay() {
        return this.tcpNoDelay;
    }

    public boolean tcpKeepAlive() {
        return this.tcpKeepAlive;
    }

    public String contextPath() {
        return this.contextPath;
    }

    public Properties properties() {
        TypedProperties properties = new TypedProperties();
        properties.setProperty("infinispan.client.rest.protocol", this.protocol().name());
        properties.setProperty("infinispan.client.rest.connect_timeout", Long.toString(this.connectionTimeout()));
        properties.setProperty("infinispan.client.rest.socket_timeout", this.socketTimeout());
        properties.setProperty("infinispan.client.rest.tcp_no_delay", this.tcpNoDelay());
        properties.setProperty("infinispan.client.rest.tcp_keep_alive", this.tcpKeepAlive());
        properties.setProperty("infinispan.client.rest.context_path", this.tcpKeepAlive());
        StringBuilder servers = new StringBuilder();
        for (ServerConfiguration server : this.servers()) {
            if (servers.length() > 0) {
                servers.append(";");
            }
            servers.append(server.host()).append(":").append(server.port());
        }
        properties.setProperty("infinispan.client.rest.server_list", servers.toString());
        properties.setProperty("infinispan.client.rest.use_ssl", Boolean.toString(this.security.ssl().enabled()));
        if (this.security.ssl().keyStoreFileName() != null) {
            properties.setProperty("infinispan.client.rest.key_store_file_name", this.security.ssl().keyStoreFileName());
        }
        if (this.security.ssl().keyStorePassword() != null) {
            properties.setProperty("infinispan.client.rest.key_store_password", new String(this.security.ssl().keyStorePassword()));
        }
        if (this.security.ssl().keyStoreCertificatePassword() != null) {
            properties.setProperty("infinispan.client.rest.key_store_certificate_password", new String(this.security.ssl().keyStoreCertificatePassword()));
        }
        if (this.security.ssl().trustStoreFileName() != null) {
            properties.setProperty("infinispan.client.rest.trust_store_file_name", this.security.ssl().trustStoreFileName());
        }
        if (this.security.ssl().trustStorePassword() != null) {
            properties.setProperty("infinispan.client.rest.trust_store_password", new String(this.security.ssl().trustStorePassword()));
        }
        if (this.security.ssl().sniHostName() != null) {
            properties.setProperty("infinispan.client.rest.sni_host_name", this.security.ssl().sniHostName());
        }
        if (this.security.ssl().protocol() != null) {
            properties.setProperty("infinispan.client.rest.ssl_protocol", this.security.ssl().protocol());
        }
        if (this.security.ssl().sslContext() != null) {
            properties.put((Object)"infinispan.client.rest.ssl_context", (Object)this.security.ssl().sslContext());
        }
        if (this.security.ssl().trustManagers() != null) {
            properties.put((Object)"infinispan.client.rest.trust_managers", (Object)this.security.ssl().trustManagers());
        }
        properties.setProperty("infinispan.client.rest.use_auth", Boolean.toString(this.security.authentication().enabled()));
        if (this.security.authentication().mechanism() != null) {
            properties.setProperty("infinispan.client.rest.sasl_mechanism", this.security.authentication().mechanism());
        }
        return properties;
    }
}

