/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.benchmark;

import io.lettuce.core.RedisClient;
import io.lettuce.core.api.sync.RedisCommands;
import io.lettuce.core.codec.ByteArrayCodec;
import io.lettuce.core.codec.RedisCodec;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.commons.util.Util;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.infra.Blackhole;

@State(value=Scope.Thread)
public class RespBenchmark {
    RedisClient client;
    RedisCommands<byte[], byte[]> connection;
    @Param(value={"redis://127.0.0.1:11222"})
    public String uri;
    @Param(value={"16"})
    public int keySize;
    @Param(value={"1000"})
    public int valueSize;
    @Param(value={"1000"})
    public int keySetSize;
    byte[] value;
    List<byte[]> keySet;
    AtomicInteger nextIndex;

    @Setup
    public void setup() {
        this.client = RedisClient.create((String)this.uri);
        this.connection = this.client.connect((RedisCodec)ByteArrayCodec.INSTANCE).sync();
        this.value = new byte[this.valueSize];
        this.keySet = new ArrayList<byte[]>(this.keySetSize);
        Random r = new Random(17L);
        for (int i = 0; i < this.keySetSize; ++i) {
            byte[] key = new byte[this.keySize];
            r.nextBytes(key);
            this.keySet.add(key);
            this.connection.set((Object)key, (Object)this.value);
        }
        this.nextIndex = new AtomicInteger();
    }

    @Benchmark
    public void get(Blackhole bh) {
        bh.consume(this.connection.get((Object)this.nextKey()));
    }

    @Benchmark
    public void put() {
        this.connection.set((Object)this.nextKey(), (Object)this.value);
    }

    @TearDown
    public void teardown() {
        Util.close((AutoCloseable)this.client);
    }

    private byte[] nextKey() {
        return this.keySet.get(this.nextIndex.getAndIncrement() % this.keySetSize);
    }
}

