/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.commands.troubleshoot.log;

import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.HdrHistogram.Histogram;
import org.infinispan.cli.commands.troubleshoot.log.AccessLogEntry;

interface AccessLogResult {
    public String prettyPrint();

    public static final class RecursiveAggregationResult
    implements AccessLogResult {
        private final Map<String, AccessLogResult> results;

        RecursiveAggregationResult(Map<String, AccessLogResult> results) {
            this.results = results;
        }

        @Override
        public String prettyPrint() {
            StringBuilder sb = new StringBuilder();
            sb.append("Total results: ").append(this.results.size()).append(System.lineSeparator());
            for (Map.Entry<String, AccessLogResult> entry : this.results.entrySet()) {
                sb.append("Element: ").append(entry.getKey()).append(System.lineSeparator());
                sb.append(entry.getValue().prettyPrint()).append(System.lineSeparator());
                sb.append("==============================================================").append(System.lineSeparator()).append(System.lineSeparator());
            }
            return sb.toString();
        }
    }

    public static final class OperationCollectionResult
    implements AccessLogResult {
        private final Collection<AccessLogEntry> entries;

        OperationCollectionResult(Collection<AccessLogEntry> entries) {
            this.entries = entries;
        }

        @Override
        public String prettyPrint() {
            StringBuilder sb = new StringBuilder();
            sb.append("Displaying ").append(this.entries.size()).append(" elements").append(System.lineSeparator());
            sb.append("==============================================================").append(System.lineSeparator());
            String s = this.entries.stream().map(Record::toString).collect(Collectors.joining(System.lineSeparator()));
            sb.append(s).append(System.lineSeparator());
            return sb.toString();
        }
    }

    public static final class ResultByOperation
    implements AccessLogResult {
        private final Map<String, Histogram> results;

        public ResultByOperation(Map<String, Histogram> results) {
            this.results = results;
        }

        @Override
        public String prettyPrint() {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, Histogram> entry : this.results.entrySet()) {
                Histogram h = entry.getValue();
                sb.append("Operation: ").append(entry.getKey()).append(" (").append(h.getTotalCount()).append(")").append(System.lineSeparator());
                sb.append('\t');
                sb.append("min/avg/max: ");
                sb.append(h.getMinValue()).append("/").append(String.format("%.5f", h.getMean())).append("/").append(h.getMaxValue()).append(" ms").append(System.lineSeparator());
                sb.append("\tp50: ").append(h.getValueAtPercentile(50.0)).append(" ms").append(System.lineSeparator());
                sb.append("\tp90: ").append(h.getValueAtPercentile(90.0)).append(" ms").append(System.lineSeparator());
                sb.append("\tp99: ").append(h.getValueAtPercentile(99.0)).append(" ms").append(System.lineSeparator());
                sb.append(System.lineSeparator());
            }
            return sb.toString();
        }
    }
}

