/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.commands.troubleshoot.log;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;

record AccessLogEntry(String file, String client, String operation, long duration, LocalDateTime date) {
    private static final DateTimeFormatter PARSER = DateTimeFormatter.ofPattern("dd/MMM/yyyy:HH:mm:ss");

    public static AccessLogEntry newInstance(String file, String line) {
        String[] split = line.split(" ");
        String client = split[0];
        String operation = split[4].replace("\"", "");
        long duration = Long.parseLong(split[split.length - 1]);
        LocalDateTime execution = AccessLogEntry.parseDate(split[2].replace("[", ""));
        return new AccessLogEntry(file, client, operation, duration, execution);
    }

    public static Predicate<AccessLogEntry> filterByOperation(String operation) {
        return ale -> operation == null || operation.equals(ale.operation);
    }

    public static Predicate<AccessLogEntry> ignoreOperations(List<String> operations) {
        if (operations == null) {
            return ignore -> true;
        }
        HashSet<String> ops = new HashSet<String>(operations);
        return ale -> !ops.contains(ale.operation);
    }

    public static Predicate<AccessLogEntry> filterExecutionAfter(LocalDateTime start) {
        if (start == null) {
            return ignore -> true;
        }
        return ale -> ale.date.equals(start) || ale.date.isAfter(start);
    }

    public static Predicate<AccessLogEntry> filterExecutionBefore(LocalDateTime end) {
        if (end == null) {
            return ignore -> true;
        }
        Predicate<AccessLogEntry> predicate = AccessLogEntry.filterExecutionAfter(end);
        return ale -> !predicate.test((AccessLogEntry)ale);
    }

    public static Predicate<AccessLogEntry> filterByDuration(long d) {
        return ale -> ale.duration >= d;
    }

    private static LocalDateTime parseDate(String value) {
        return PARSER.parse((CharSequence)value, LocalDateTime::from);
    }
}

