/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.commands;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Locale;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.impl.completer.FileOptionCompleter;
import org.aesh.command.option.Arguments;
import org.aesh.command.option.Option;
import org.aesh.io.FileResource;
import org.aesh.io.Resource;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.infinispan.cli.commands.CLI;
import org.infinispan.cli.commands.CliCommand;
import org.infinispan.cli.impl.ContextAwareCommandInvocation;
import org.infinispan.cli.impl.ExitCodeResultHandler;
import org.infinispan.cli.logging.Messages;
import org.infinispan.cli.util.Utils;
import org.infinispan.commons.maven.Artifact;
import org.infinispan.commons.maven.MavenSettings;
import org.infinispan.commons.util.Util;

@CommandDefinition(name="install", description="Downloads and installs artifacts into the lib folder of the server.", resultHandler=ExitCodeResultHandler.class)
public class Install
extends CliCommand {
    @Arguments(description="Specifies one or more artifacts as URLs or Maven GAV coordinates.", required=true)
    List<String> artifacts;
    @Option(completer=FileOptionCompleter.class, description="Sets the path to the server installation.", name="server-home")
    FileResource serverHome;
    @Option(description="Sets the server root directory relative to the server home.", name="server-root", defaultValue={"server"})
    String serverRoot = "server";
    @Option(description="Sets the path to a Maven settings file that resolves Maven artifacts. Can be either a local path or a URL.", name="maven-settings")
    String mavenSettings;
    @Option(shortName=104, hasValue=false, overrideRequired=true)
    protected boolean help;
    @Option(description="Overwrites artifacts in the lib folder. By default installation fails if artifacts already exist.", shortName=111, hasValue=false)
    boolean overwrite;
    @Option(description="Show verbose information about installation progress.", shortName=118, hasValue=false)
    boolean verbose;
    @Option(description="Forces download of artifacts, ignoring any previously cached versions.", shortName=102, hasValue=false)
    boolean force;
    @Option(description="Number of download retries in case artifacts do not match the supplied checksums.", shortName=114, defaultValue={"0"})
    int retries;
    @Option(description="Deletes all contents from the lib directory before downloading artifacts.", hasValue=false)
    boolean clean;

    @Override
    public boolean isHelp() {
        return this.help;
    }

    @Override
    public CommandResult exec(ContextAwareCommandInvocation invocation) throws CommandException {
        try {
            CopyOption[] copyOptionArray;
            if (this.overwrite) {
                StandardCopyOption[] standardCopyOptionArray = new StandardCopyOption[1];
                copyOptionArray = standardCopyOptionArray;
                standardCopyOptionArray[0] = StandardCopyOption.REPLACE_EXISTING;
            } else {
                copyOptionArray = new StandardCopyOption[]{};
            }
            CopyOption[] options = copyOptionArray;
            MavenSettings.init(this.mavenSettings == null ? null : Artifact.fromString((String)this.mavenSettings).resolveArtifact());
            Path serverLib = CLI.getServerHome((Resource)this.serverHome).resolve(this.serverRoot).resolve("lib");
            if (this.clean) {
                if (this.verbose) {
                    System.out.printf("Removing all files from %s%n", serverLib);
                }
                Util.recursiveFileRemove((Path)serverLib);
                Files.createDirectories(serverLib, new FileAttribute[0]);
            }
            for (String artifact : this.artifacts) {
                String resolvedFilename;
                String[] parts = artifact.split("\\|");
                String path = parts[0];
                Path resolved = null;
                for (int retry = 0; retry <= this.retries; ++retry) {
                    resolved = Artifact.fromString((String)path).verbose(this.verbose).force(retry != 0 || this.force).resolveArtifact();
                    if (resolved == null) {
                        throw Messages.MSG.artifactNotFound(path);
                    }
                    if (parts.length <= 1) break;
                    String checksum = parts.length == 3 ? parts[2].toUpperCase(Locale.ROOT) : parts[1].toUpperCase(Locale.ROOT);
                    String algorithm = parts.length == 3 ? parts[1].toUpperCase(Locale.ROOT) : "SHA-256";
                    String computed = Utils.digest(resolved, algorithm);
                    if (!computed.equals(checksum)) {
                        if (retry < this.retries) {
                            if (!this.verbose) continue;
                            System.err.printf("%s. %s%n", Messages.MSG.checksumFailed(path, checksum, computed).getMessage(), Messages.MSG.retryDownload(retry + 1, this.retries));
                            continue;
                        }
                        throw Messages.MSG.checksumFailed(path, checksum, computed);
                    }
                    if (!this.verbose) continue;
                    System.out.println(Messages.MSG.checksumVerified(path));
                    break;
                }
                if ((resolvedFilename = resolved.getFileName().toString()).endsWith(".zip")) {
                    Install.extractZip(resolved, serverLib, options);
                    continue;
                }
                if (resolvedFilename.endsWith(".tgz") || resolvedFilename.endsWith(".tar.gz")) {
                    Install.extractTgz(resolved, serverLib, options);
                    continue;
                }
                if (resolvedFilename.endsWith(".tar")) {
                    Install.extractTar(resolved, serverLib, options);
                    continue;
                }
                Files.copy(resolved, serverLib.resolve(resolved.getFileName()), options);
            }
            return CommandResult.SUCCESS;
        }
        catch (IOException e) {
            throw new CommandException((Throwable)e);
        }
    }

    private static void extractZip(Path zip, Path dest, CopyOption ... options) throws IOException {
        try (ZipInputStream zis = new ZipInputStream(Files.newInputStream(zip, new OpenOption[0]));){
            ZipEntry zipEntry = zis.getNextEntry();
            while (zipEntry != null) {
                Path entryPath = dest.resolve(zipEntry.getName());
                if (!entryPath.startsWith(dest)) {
                    throw new IOException("Illegal relative path " + zipEntry.getName());
                }
                if (zipEntry.isDirectory()) {
                    Files.createDirectories(entryPath, new FileAttribute[0]);
                } else {
                    Files.createDirectories(entryPath.getParent(), new FileAttribute[0]);
                    Files.copy(zis, entryPath, options);
                }
                zis.closeEntry();
                zipEntry = zis.getNextEntry();
            }
        }
    }

    private static void extractTgz(Path tar, Path dest, CopyOption ... options) throws IOException {
        try (TarArchiveInputStream tis = new TarArchiveInputStream((InputStream)new GZIPInputStream(Files.newInputStream(tar, new OpenOption[0])));){
            Install.extractTarEntries(dest, tis, options);
        }
    }

    private static void extractTar(Path tar, Path dest, CopyOption ... options) throws IOException {
        try (TarArchiveInputStream tis = new TarArchiveInputStream(Files.newInputStream(tar, new OpenOption[0]));){
            Install.extractTarEntries(dest, tis, options);
        }
    }

    private static void extractTarEntries(Path dest, TarArchiveInputStream tis, CopyOption ... options) throws IOException {
        TarArchiveEntry tarEntry = tis.getNextTarEntry();
        while (tarEntry != null) {
            Path entryPath = dest.resolve(tarEntry.getName());
            if (!entryPath.startsWith(dest)) {
                throw new IOException("Illegal relative path " + tarEntry.getName());
            }
            if (tarEntry.isDirectory()) {
                Files.createDirectories(entryPath, new FileAttribute[0]);
            } else {
                Files.createDirectories(entryPath.getParent(), new FileAttribute[0]);
                Files.copy((InputStream)tis, entryPath, options);
            }
            tarEntry = tis.getNextTarEntry();
        }
    }
}

