/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.commands.rest;

import java.io.IOException;
import java.util.concurrent.CompletionStage;
import org.aesh.command.CommandDefinition;
import org.aesh.command.option.Argument;
import org.aesh.command.option.Option;
import org.infinispan.cli.activators.ConnectionActivator;
import org.infinispan.cli.commands.rest.RestCliCommand;
import org.infinispan.cli.completers.CdContextCompleter;
import org.infinispan.cli.impl.ContextAwareCommandInvocation;
import org.infinispan.cli.logging.Messages;
import org.infinispan.cli.resources.CacheResource;
import org.infinispan.cli.resources.ContainerResource;
import org.infinispan.cli.resources.Resource;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestResponse;

@CommandDefinition(name="stats", description="Shows cache and container statistics", activator=ConnectionActivator.class)
public class Stats
extends RestCliCommand {
    @Argument(description="The path of the resource", completer=CdContextCompleter.class)
    String name;
    @Option(shortName=104, hasValue=false, overrideRequired=true)
    protected boolean help;
    @Option(hasValue=false)
    protected boolean reset;

    @Override
    public boolean isHelp() {
        return this.help;
    }

    @Override
    protected CompletionStage<RestResponse> exec(ContextAwareCommandInvocation invocation, RestClient client, Resource activeResource) {
        try {
            Resource resource = activeResource.getResource(this.name);
            if (resource instanceof CacheResource) {
                return this.reset ? client.cache(resource.getName()).statsReset() : client.cache(resource.getName()).stats();
            }
            if (resource instanceof ContainerResource) {
                return this.reset ? client.container().statsReset() : client.container().stats();
            }
            if (this.reset) {
                throw Messages.MSG.cannotResetIndividualStat();
            }
            String name = resource.getName();
            throw Messages.MSG.invalidResource(name.isEmpty() ? "/" : name);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

