/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.commands.kubernetes;

import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import io.fabric8.kubernetes.api.model.GenericKubernetesResourceList;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.FilterWatchListMultiDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.base.ResourceDefinitionContext;
import java.util.List;
import java.util.Optional;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandResult;
import org.aesh.command.option.Option;
import org.aesh.command.option.OptionList;
import org.infinispan.cli.commands.CliCommand;
import org.infinispan.cli.commands.kubernetes.Kube;
import org.infinispan.cli.impl.ContextAwareCommandInvocation;
import org.infinispan.cli.impl.KubernetesContext;
import org.infinispan.cli.logging.Messages;
import org.infinispan.commons.util.Version;

@CommandDefinition(name="install", description="Installs the Operator.")
public class Install
extends CliCommand {
    @Option(shortName=110, description="Specifies a namespace for the Operator. Defaults to installing the Operator in the default Operator namespace.")
    String namespace;
    @Option(shortName=99, description="Selects the channel to install and subscribes to upgrades for that release stream. If not specified, the latest stable channel is installed.")
    String channel;
    @Option(defaultValue={"false"}, name="manual", shortName=109, description="Requires approval before applying upgrades from the Operator subscription. Defaults to automatic approval.")
    boolean manual;
    @Option(description="Specifies the CatalogSource for the Operator subscription. Selects an environment-dependent CatalogSource by default.")
    String source;
    @Option(name="source-namespace", description="Specifies the namespace of the subscription source. Selects an environment-dependent namespace by default.")
    String sourceNamespace;
    @OptionList(name="target-namespaces", description="Specifies the namespaces that the Operator watches. You must set a target namespace if you install the Operator in a specific namespace.")
    List<String> targetNamespaces;
    @Option(shortName=104, hasValue=false, overrideRequired=true)
    protected boolean help;

    @Override
    public boolean isHelp() {
        return this.help;
    }

    @Override
    public CommandResult exec(ContextAwareCommandInvocation invocation) {
        if (this.namespace != null && (this.targetNamespaces == null || this.targetNamespaces.isEmpty())) {
            throw Messages.MSG.noTargetNamespaces();
        }
        KubernetesClient client = KubernetesContext.getClient(invocation);
        if (this.source == null) {
            List sources = ((GenericKubernetesResourceList)((FilterWatchListMultiDeletable)client.genericKubernetesResources((ResourceDefinitionContext)Kube.OPERATOR_CATALOGSOURCE_CRD).inAnyNamespace()).list()).getItems();
            Optional<GenericKubernetesResource> catalog = sources.stream().filter(cs -> Version.getProperty((String)"infinispan.olm.k8s.source").equals(cs.getMetadata().getName())).findFirst();
            if (!catalog.isPresent()) {
                catalog = sources.stream().filter(cs -> Version.getProperty((String)"infinispan.olm.openshift.source").equals(cs.getMetadata().getName())).findFirst();
            }
            if (catalog.isPresent()) {
                GenericKubernetesResource catalogSource = catalog.get();
                this.source = catalogSource.getMetadata().getName();
                this.sourceNamespace = catalogSource.getMetadata().getNamespace();
            } else {
                throw Messages.MSG.noCatalog();
            }
        }
        String olmName = Version.getProperty((String)"infinispan.olm.name");
        if (this.namespace == null) {
            this.namespace = Kube.defaultOperatorNamespace(client);
        } else {
            GenericKubernetesResource group = new GenericKubernetesResource();
            group.setKind(Kube.OPERATOR_OPERATORGROUP_CRD.getKind());
            ObjectMeta groupMetadata = new ObjectMeta();
            groupMetadata.setName(olmName);
            groupMetadata.setNamespace(this.namespace);
            group.setMetadata(groupMetadata);
            GenericKubernetesResource groupSpec = new GenericKubernetesResource();
            groupSpec.setAdditionalProperty("targetNamespaces", this.targetNamespaces);
            group.setAdditionalProperty("spec", (Object)groupSpec);
            ((NonNamespaceOperation)client.genericKubernetesResources((ResourceDefinitionContext)Kube.OPERATOR_OPERATORGROUP_CRD).inNamespace(this.namespace)).createOrReplace((Object[])new GenericKubernetesResource[]{group});
        }
        GenericKubernetesResource subscription = new GenericKubernetesResource();
        subscription.setKind(Kube.OPERATOR_SUBSCRIPTION_CRD.getKind());
        ObjectMeta subscriptionMetadata = new ObjectMeta();
        subscriptionMetadata.setName(olmName);
        subscriptionMetadata.setNamespace(this.namespace);
        subscription.setMetadata(subscriptionMetadata);
        GenericKubernetesResource subscriptionSpec = new GenericKubernetesResource();
        subscriptionSpec.setAdditionalProperty("name", (Object)olmName);
        subscriptionSpec.setAdditionalProperty("installPlanApproval", (Object)(this.manual ? "Manual" : "Automatic"));
        subscriptionSpec.setAdditionalProperty("source", (Object)this.source);
        subscriptionSpec.setAdditionalProperty("sourceNamespace", (Object)this.sourceNamespace);
        if (this.channel != null) {
            subscriptionSpec.setAdditionalProperty("channel", (Object)this.channel);
        }
        subscription.setAdditionalProperty("spec", (Object)subscriptionSpec);
        ((NonNamespaceOperation)client.genericKubernetesResources((ResourceDefinitionContext)Kube.OPERATOR_SUBSCRIPTION_CRD).inNamespace(this.namespace)).createOrReplace((Object[])new GenericKubernetesResource[]{subscription});
        return CommandResult.SUCCESS;
    }
}

