/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cdi.embedded;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessBean;
import jakarta.enterprise.inject.spi.ProcessProducer;
import jakarta.enterprise.inject.spi.Producer;
import jakarta.enterprise.util.TypeLiteral;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.cdi.common.util.AnyLiteral;
import org.infinispan.cdi.common.util.Arrays2;
import org.infinispan.cdi.common.util.BeanBuilder;
import org.infinispan.cdi.common.util.Beans;
import org.infinispan.cdi.common.util.ContextualLifecycle;
import org.infinispan.cdi.common.util.ContextualReference;
import org.infinispan.cdi.common.util.DefaultLiteral;
import org.infinispan.cdi.common.util.Reflections;
import org.infinispan.cdi.embedded.AdvancedCacheProducer;
import org.infinispan.cdi.embedded.ConfigureCache;
import org.infinispan.cdi.embedded.event.cachemanager.CacheManagerEventBridge;
import org.infinispan.cdi.embedded.util.logging.EmbeddedLog;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listenable;

public class InfinispanExtensionEmbedded
implements Extension {
    private static final String CACHE_NAME = "CDIExtensionDefaultCacheManager";
    private static final EmbeddedLog LOGGER = EmbeddedLog.getLog(InfinispanExtensionEmbedded.class);
    private final Set<ConfigurationHolder> configurations;
    private volatile boolean registered = false;
    private final Object registerLock = new Object();
    private final Set<Set<Annotation>> installedEmbeddedCacheManagers = new HashSet<Set<Annotation>>();

    public InfinispanExtensionEmbedded() {
        new ConfigurationBuilder();
        this.configurations = new HashSet<ConfigurationHolder>();
    }

    void observeConfigurationProducers(@Observes ProcessProducer<?, Configuration> event, BeanManager beanManager) {
        ConfigureCache annotation = (ConfigureCache)event.getAnnotatedMember().getAnnotation(ConfigureCache.class);
        String configurationName = "";
        if (annotation != null) {
            configurationName = annotation.value();
        }
        this.configurations.add(new ConfigurationHolder((Producer<Configuration>)event.getProducer(), configurationName, (Set<Annotation>)Reflections.getQualifiers((BeanManager)beanManager, (Iterable)event.getAnnotatedMember().getAnnotations())));
    }

    public void observeEmbeddedCacheManagerBean(@Observes ProcessBean<?> processBean) {
        if (processBean.getBean().getTypes().contains(EmbeddedCacheManager.class)) {
            this.installedEmbeddedCacheManagers.add(processBean.getBean().getQualifiers());
        }
    }

    <T, X> void registerBeans(@Observes AfterBeanDiscovery event, final BeanManager beanManager) {
        if (beanManager.getBeans(Configuration.class, new Annotation[0]).isEmpty()) {
            LOGGER.addDefaultEmbeddedConfiguration();
            Configuration defaultConfiguration = new ConfigurationBuilder().build();
            this.configurations.add(new ConfigurationHolder(defaultConfiguration, "", this.defaultQualifiers()));
            event.addBean(this.createDefaultEmbeddedConfigurationBean(beanManager, defaultConfiguration));
        }
        for (final ConfigurationHolder holder : this.configurations) {
            Bean advancedCacheBean = new BeanBuilder(beanManager).readFromType(beanManager.createAnnotatedType(AdvancedCache.class)).qualifiers(Beans.buildQualifiers(holder.getQualifiers())).addType(new TypeLiteral<AdvancedCache<T, X>>(){}.getType()).addType(new TypeLiteral<Cache<T, X>>(){}.getType()).passivationCapable(true).id(InfinispanExtensionEmbedded.class.getSimpleName() + "#" + AdvancedCache.class.getSimpleName() + "#" + Cache.class.getSimpleName()).beanLifecycle(new ContextualLifecycle<AdvancedCache<?, ?>>(){
                final /* synthetic */ InfinispanExtensionEmbedded this$0;
                {
                    this.this$0 = this$0;
                }

                public AdvancedCache<?, ?> create(Bean<AdvancedCache<?, ?>> bean, CreationalContext<AdvancedCache<?, ?>> creationalContext) {
                    return ((AdvancedCacheProducer)new ContextualReference(beanManager, AdvancedCacheProducer.class, new Annotation[0]).create((CreationalContext)Reflections.cast(creationalContext)).get()).getAdvancedCache(holder.getName(), holder.getQualifiers());
                }
            }).create();
            event.addBean(advancedCacheBean);
        }
        if (beanManager.getBeans(EmbeddedCacheManager.class, new Annotation[0]).isEmpty()) {
            LOGGER.addDefaultEmbeddedCacheManager();
            event.addBean(this.createDefaultEmbeddedCacheManagerBean(beanManager));
        }
    }

    public Set<InstalledCacheManager> getInstalledEmbeddedCacheManagers(BeanManager beanManager) {
        HashSet<InstalledCacheManager> installedCacheManagers = new HashSet<InstalledCacheManager>();
        for (Set<Annotation> qualifiers : this.installedEmbeddedCacheManagers) {
            Bean b = beanManager.resolve(beanManager.getBeans(EmbeddedCacheManager.class, qualifiers.toArray(Reflections.EMPTY_ANNOTATION_ARRAY)));
            EmbeddedCacheManager cm = (EmbeddedCacheManager)beanManager.getReference(b, EmbeddedCacheManager.class, beanManager.createCreationalContext((Contextual)b));
            installedCacheManagers.add(new InstalledCacheManager(cm, qualifiers.contains(DefaultLiteral.INSTANCE)));
        }
        return installedCacheManagers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCacheConfigurations(CacheManagerEventBridge eventBridge, Instance<EmbeddedCacheManager> cacheManagers, BeanManager beanManager) {
        if (!this.registered) {
            Object object = this.registerLock;
            synchronized (object) {
                if (!this.registered) {
                    CreationalContext ctx = beanManager.createCreationalContext(null);
                    EmbeddedCacheManager defaultCacheManager = (EmbeddedCacheManager)cacheManagers.select(new Annotation[]{DefaultLiteral.INSTANCE}).get();
                    for (ConfigurationHolder holder : this.configurations) {
                        EmbeddedCacheManager cacheManager;
                        String cacheName = holder.getName();
                        Configuration cacheConfiguration = holder.getConfiguration((CreationalContext<Configuration>)ctx);
                        Set<Annotation> cacheQualifiers = holder.getQualifiers();
                        Instance specificCacheManager = cacheManagers.select(cacheQualifiers.toArray(new Annotation[cacheQualifiers.size()]));
                        EmbeddedCacheManager embeddedCacheManager = cacheManager = specificCacheManager.isUnsatisfied() ? defaultCacheManager : (EmbeddedCacheManager)specificCacheManager.get();
                        if (!cacheName.trim().isEmpty()) {
                            if (cacheConfiguration != null) {
                                cacheManager.defineConfiguration(cacheName, cacheConfiguration);
                                LOGGER.cacheConfigurationDefined(cacheName, cacheManager);
                            } else if (!cacheManager.getCacheNames().contains(cacheName)) {
                                cacheManager.defineConfiguration(cacheName, cacheManager.getDefaultCacheConfiguration());
                                LOGGER.cacheConfigurationDefined(cacheName, cacheManager);
                            }
                        }
                        eventBridge.registerObservers(cacheQualifiers, cacheName, (Listenable)cacheManager);
                    }
                    this.registered = true;
                }
            }
        }
    }

    private Bean<Configuration> createDefaultEmbeddedConfigurationBean(BeanManager beanManager, final Configuration configuration) {
        return new BeanBuilder(beanManager).beanClass(InfinispanExtensionEmbedded.class).addTypes(new Type[]{Object.class, Configuration.class}).scope(Dependent.class).qualifiers(this.defaultQualifiers()).passivationCapable(true).id(InfinispanExtensionEmbedded.class.getSimpleName() + "#" + Configuration.class.getSimpleName()).beanLifecycle((ContextualLifecycle)new ContextualLifecycle<Configuration>(){
            final /* synthetic */ InfinispanExtensionEmbedded this$0;
            {
                this.this$0 = this$0;
            }

            public Configuration create(Bean<Configuration> bean, CreationalContext<Configuration> creationalContext) {
                return configuration;
            }
        }).create();
    }

    private Bean<EmbeddedCacheManager> createDefaultEmbeddedCacheManagerBean(final BeanManager beanManager) {
        return new BeanBuilder(beanManager).beanClass(InfinispanExtensionEmbedded.class).addTypes(new Type[]{Object.class, EmbeddedCacheManager.class}).scope(ApplicationScoped.class).qualifiers(this.defaultQualifiers()).passivationCapable(true).id(InfinispanExtensionEmbedded.class.getSimpleName() + "#" + EmbeddedCacheManager.class.getSimpleName()).beanLifecycle((ContextualLifecycle)new ContextualLifecycle<EmbeddedCacheManager>(){
            final /* synthetic */ InfinispanExtensionEmbedded this$0;
            {
                this.this$0 = this$0;
            }

            public EmbeddedCacheManager create(Bean<EmbeddedCacheManager> bean, CreationalContext<EmbeddedCacheManager> creationalContext) {
                ConfigurationBuilderHolder holder = new ConfigurationBuilderHolder();
                holder.getGlobalConfigurationBuilder().cacheManagerName(InfinispanExtensionEmbedded.CACHE_NAME).defaultCacheName("default");
                Bean configurationBean = beanManager.resolve(beanManager.getBeans(Configuration.class, new Annotation[0]));
                Configuration defaultConfiguration = (Configuration)beanManager.getReference(configurationBean, Configuration.class, beanManager.createCreationalContext((Contextual)configurationBean));
                ConfigurationBuilder builder = new ConfigurationBuilder();
                builder.read(defaultConfiguration);
                holder.getNamedConfigurationBuilders().put("default", builder);
                return new DefaultCacheManager(holder, true);
            }

            public void destroy(Bean<EmbeddedCacheManager> bean, EmbeddedCacheManager instance, CreationalContext<EmbeddedCacheManager> creationalContext) {
                instance.stop();
            }
        }).create();
    }

    private Set<Annotation> defaultQualifiers() {
        return Arrays2.asSet((Object[])new Annotation[]{DefaultLiteral.INSTANCE, AnyLiteral.INSTANCE});
    }

    static class ConfigurationHolder {
        private final Producer<Configuration> producer;
        private final Set<Annotation> qualifiers;
        private final String name;
        private final Configuration configuration;

        ConfigurationHolder(Producer<Configuration> producer, String name, Set<Annotation> qualifiers) {
            this(producer, qualifiers, name, null);
        }

        ConfigurationHolder(Configuration configuration, String name, Set<Annotation> qualifiers) {
            this(null, qualifiers, name, configuration);
        }

        private ConfigurationHolder(Producer<Configuration> producer, Set<Annotation> qualifiers, String name, Configuration configuration) {
            this.producer = producer;
            this.qualifiers = qualifiers;
            this.name = name;
            this.configuration = configuration;
        }

        public Producer<Configuration> getProducer() {
            return this.producer;
        }

        public String getName() {
            return this.name;
        }

        public Set<Annotation> getQualifiers() {
            return this.qualifiers;
        }

        Configuration getConfiguration(CreationalContext<Configuration> ctx) {
            return this.configuration != null ? this.configuration : (Configuration)this.producer.produce(ctx);
        }
    }

    public static class InstalledCacheManager {
        final EmbeddedCacheManager cacheManager;
        final boolean isDefault;

        InstalledCacheManager(EmbeddedCacheManager cacheManager, boolean aDefault) {
            this.cacheManager = cacheManager;
            this.isDefault = aDefault;
        }

        public EmbeddedCacheManager getCacheManager() {
            return this.cacheManager;
        }

        public boolean isDefault() {
            return this.isDefault;
        }
    }
}

