/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.$generator$;

import com.sun.tools.javac.code.Symbol;
import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.eclipse.jdt.internal.compiler.apt.model.ElementImpl;
import org.eclipse.jdt.internal.compiler.apt.model.ExecutableElementImpl;
import org.eclipse.jdt.internal.compiler.apt.model.TypeElementImpl;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.immutables.value.internal.$generator$.$Compiler;
import org.immutables.value.internal.$generator$.$PostprocessingMachine;
import org.immutables.value.internal.$generator$.$SourceTypes;
import org.immutables.value.internal.$guava$.base.$CharMatcher;
import org.immutables.value.internal.$guava$.base.$MoreObjects;
import org.immutables.value.internal.$guava$.collect.$ImmutableMap;
import org.immutables.value.internal.$guava$.collect.$ImmutableSet;
import org.immutables.value.internal.$guava$.collect.$Lists;
import org.immutables.value.internal.$guava$.collect.$Maps;
import org.immutables.value.internal.$guava$.io.$CharStreams;

public final class $SourceExtraction {
    private static final SourceExtractor EXTRACTOR = $SourceExtraction.createExtractor();
    private static final boolean moreDiagnostic = false;

    private $SourceExtraction() {
    }

    public static CharSequence headerFrom(CharSequence source) {
        if (source.length() != 0) {
            return $PostprocessingMachine.collectHeader(source);
        }
        return SourceExtractor.UNABLE_TO_EXTRACT;
    }

    public static Imports importsFrom(CharSequence source) {
        if (source.length() != 0) {
            return $PostprocessingMachine.collectImports(source);
        }
        return Imports.empty();
    }

    public static CharSequence extract(ProcessingEnvironment processing, TypeElement element) {
        try {
            return EXTRACTOR.extract(processing, element);
        }
        catch (IllegalArgumentException | UnsupportedOperationException runtimeException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return SourceExtractor.UNABLE_TO_EXTRACT;
    }

    private static SourceExtractor createExtractor() {
        if ($Compiler.ECJ.isPresent() || $Compiler.JAVAC.isPresent()) {
            ArrayList<SourceExtractor> extractors = $Lists.newArrayListWithCapacity(2);
            if ($Compiler.ECJ.isPresent()) {
                extractors.add(new EclipseSourceExtractor());
            }
            if ($Compiler.JAVAC.isPresent()) {
                extractors.add(new JavacSourceExtractor());
            }
            if (extractors.size() == 1) {
                return (SourceExtractor)extractors.get(0);
            }
            return new CompositeExtractor(extractors);
        }
        return DefaultExtractor.INSTANCE;
    }

    public static CharSequence getReturnTypeString(ExecutableElement method) {
        return EXTRACTOR.extractReturnType(method);
    }

    public static String getSuperclassString(TypeElement element) {
        if ($Compiler.ECJ.isPresent() && element instanceof TypeElementImpl) {
            TypeElementImpl elementImpl = (TypeElementImpl)element;
            if (elementImpl._binding instanceof SourceTypeBinding) {
                return EclipseSourceExtractor.extractSuperclass((SourceTypeBinding)elementImpl._binding).toString();
            }
        }
        return element.getSuperclass().toString();
    }

    private static final class CompositeExtractor
    implements SourceExtractor {
        private final SourceExtractor[] extractors;

        CompositeExtractor(List<SourceExtractor> extractors) {
            this.extractors = extractors.toArray(new SourceExtractor[0]);
        }

        @Override
        public boolean claim(Element element) {
            return false;
        }

        @Override
        public CharSequence extract(ProcessingEnvironment environment, TypeElement typeElement) throws IOException {
            for (SourceExtractor extractor : this.extractors) {
                CharSequence source = extractor.extract(environment, typeElement);
                if (!source.equals(UNABLE_TO_EXTRACT)) {
                    return source;
                }
                if (!extractor.claim(typeElement)) continue;
                return UNABLE_TO_EXTRACT;
            }
            return DefaultExtractor.INSTANCE.extract(environment, typeElement);
        }

        @Override
        public CharSequence extractReturnType(ExecutableElement executableElement) {
            for (SourceExtractor extractor : this.extractors) {
                CharSequence source = extractor.extractReturnType(executableElement);
                if (!source.equals(UNABLE_TO_EXTRACT)) {
                    return source;
                }
                if (!extractor.claim(executableElement)) continue;
                return UNABLE_TO_EXTRACT;
            }
            return DefaultExtractor.INSTANCE.extractReturnType(executableElement);
        }
    }

    private static final class EclipseSourceExtractor
    implements SourceExtractor {
        private EclipseSourceExtractor() {
        }

        @Override
        public boolean claim(Element element) {
            return element instanceof ElementImpl;
        }

        @Override
        public CharSequence extract(ProcessingEnvironment environment, TypeElement typeElement) throws IOException {
            Binding binding;
            if (typeElement instanceof ElementImpl && (binding = ((ElementImpl)typeElement)._binding) instanceof SourceTypeBinding) {
                CompilationUnitDeclaration unit = ((SourceTypeBinding)binding).scope.referenceCompilationUnit();
                char[] contents = unit.compilationResult.compilationUnit.getContents();
                return CharBuffer.wrap(contents);
            }
            return UNABLE_TO_EXTRACT;
        }

        @Override
        public CharSequence extractReturnType(ExecutableElement executableElement) {
            MethodBinding methodBinding;
            AbstractMethodDeclaration sourceMethod;
            Binding binding;
            if (executableElement instanceof ExecutableElementImpl && (binding = ((ExecutableElementImpl)executableElement)._binding) instanceof MethodBinding && (sourceMethod = (methodBinding = (MethodBinding)binding).sourceMethod()) != null) {
                CharSequence rawType = EclipseSourceExtractor.getRawType(methodBinding);
                char[] content = sourceMethod.compilationResult.compilationUnit.getContents();
                int sourceEnd = methodBinding.sourceStart();
                int sourceStart = this.scanForTheSourceStart(content, sourceEnd);
                char[] methodTest = Arrays.copyOfRange(content, sourceStart, sourceEnd);
                Map.Entry<String, List<String>> extracted = $SourceTypes.extract(String.valueOf(methodTest));
                return $SourceTypes.stringify($Maps.immutableEntry(rawType.toString(), extracted.getValue()));
            }
            return UNABLE_TO_EXTRACT;
        }

        private int scanForTheSourceStart(char[] content, int sourceEnd) {
            int i;
            for (i = sourceEnd; i >= 0; --i) {
                char c = content[i];
                if (c != '\n') continue;
                return i;
            }
            return i;
        }

        private static CharSequence extractSuperclass(SourceTypeBinding binding) {
            CharSequence declaration = EclipseSourceExtractor.readSourceDeclaration(binding);
            StringTokenizer tokenizer = new StringTokenizer(declaration.toString(), "<>, \t\n\r", true);
            int genericsOpened = 0;
            while (tokenizer.hasMoreTokens()) {
                String t = tokenizer.nextToken();
                if (t.equals("<")) {
                    ++genericsOpened;
                    continue;
                }
                if (t.equals(">")) {
                    --genericsOpened;
                    continue;
                }
                if (genericsOpened > 0 || !t.equals("extends")) continue;
                return EclipseSourceExtractor.readSourceSuperclass(tokenizer);
            }
            return UNABLE_TO_EXTRACT;
        }

        private static CharSequence readSourceSuperclass(StringTokenizer tokenizer) {
            StringBuilder superclass = new StringBuilder();
            while (tokenizer.hasMoreTokens()) {
                String part = tokenizer.nextToken();
                if ($CharMatcher.whitespace().matchesAllOf(part)) continue;
                if (superclass.length() != 0 && part.charAt(0) != '.' && superclass.charAt(superclass.length() - 1) != '.') break;
                superclass.append(part);
            }
            return superclass;
        }

        private static CharSequence readSourceDeclaration(SourceTypeBinding binding) {
            char c;
            TypeDeclaration referenceContext = binding.scope.referenceContext;
            char[] content = referenceContext.compilationResult.compilationUnit.getContents();
            int start = referenceContext.declarationSourceStart;
            int end = referenceContext.declarationSourceEnd;
            StringBuilder declaration = new StringBuilder();
            for (int p = start; p <= end && (c = content[p]) != '{'; ++p) {
                declaration.append(c);
            }
            return declaration;
        }

        private static CharSequence getRawType(MethodBinding methodBinding) {
            TypeBinding returnType = methodBinding.returnType;
            char[] sourceName = returnType.sourceName();
            if (sourceName == null) {
                sourceName = new char[]{};
            }
            return CharBuffer.wrap(sourceName);
        }
    }

    private static final class JavacSourceExtractor
    implements SourceExtractor {
        private JavacSourceExtractor() {
        }

        @Override
        public boolean claim(Element element) {
            return element instanceof Symbol.ClassSymbol || element instanceof Symbol.MethodSymbol || element instanceof Symbol.VarSymbol;
        }

        @Override
        public CharSequence extract(ProcessingEnvironment environment, TypeElement typeElement) throws IOException {
            if (typeElement instanceof Symbol.ClassSymbol) {
                Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)typeElement;
                if (classSymbol.sourcefile != null) {
                    try (Reader r = classSymbol.sourcefile.openReader(true);){
                        String string = $CharStreams.toString(r);
                        return string;
                    }
                }
            }
            return UNABLE_TO_EXTRACT;
        }

        @Override
        public CharSequence extractReturnType(ExecutableElement executableElement) {
            return UNABLE_TO_EXTRACT;
        }
    }

    private static final class DefaultExtractor
    implements SourceExtractor {
        static final DefaultExtractor INSTANCE = new DefaultExtractor();

        private DefaultExtractor() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public CharSequence extract(ProcessingEnvironment environment, TypeElement element) throws IOException {
            try {
                FileObject resource = environment.getFiler().getResource(StandardLocation.SOURCE_PATH, "", this.toFilename(element));
                try (Reader r = resource.openReader(true);){
                    String string = $CharStreams.toString(r);
                    return string;
                }
            }
            catch (IllegalArgumentException | UnsupportedOperationException ex) {
                return UNABLE_TO_EXTRACT;
            }
        }

        private String toFilename(TypeElement element) {
            return element.getQualifiedName().toString().replace('.', '/') + ".java";
        }

        @Override
        public CharSequence extractReturnType(ExecutableElement executableElement) {
            return UNABLE_TO_EXTRACT;
        }

        @Override
        public boolean claim(Element element) {
            return false;
        }
    }

    static interface SourceExtractor {
        public static final CharSequence UNABLE_TO_EXTRACT = "";

        public boolean claim(Element var1);

        public CharSequence extract(ProcessingEnvironment var1, TypeElement var2) throws IOException;

        public CharSequence extractReturnType(ExecutableElement var1);
    }

    public static final class Imports {
        private static final Imports EMPTY = new Imports($ImmutableSet.of(), $ImmutableMap.of());
        public final $ImmutableSet<String> all;
        public final $ImmutableMap<String, String> classes;

        private Imports(Set<String> all, Map<String, String> classes) {
            this.all = $ImmutableSet.copyOf(all);
            this.classes = $ImmutableMap.copyOf(classes);
        }

        public static Imports of(Set<String> all, Map<String, String> classes) {
            if (all.isEmpty() && classes.isEmpty()) {
                return EMPTY;
            }
            if (!all.containsAll(classes.values())) {
                // empty if block
            }
            return new Imports(all, classes);
        }

        public static Imports empty() {
            return EMPTY;
        }

        public boolean isEmpty() {
            return this == EMPTY;
        }

        public String toString() {
            return $MoreObjects.toStringHelper(this).add("all", this.all).add("classes", this.classes).toString();
        }
    }
}

