/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.$generator$;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.immutables.extgenerator.GeneratedImportsModifier;
import org.immutables.value.internal.$guava$.collect.$ImmutableList;

public class $ImportRewriter {
    private final CharSequence source;
    static final $ImmutableList<GeneratedImportsModifier> importsModifiers = $ImmutableList.copyOf(ServiceLoader.load(GeneratedImportsModifier.class, $ImportRewriter.class.getClassLoader()));
    private final int len;
    private int at;
    private String thisPackage;
    private String thisPackagePrefix;
    private int beforeImportPosition;
    private int afterPackagePosition;
    private final List<Import> imports = new ArrayList<Import>();
    private final List<Declaration> declarations = new ArrayList<Declaration>();
    private final List<MaybeQualified> occurrences = new ArrayList<MaybeQualified>();
    private final Map<String, String> usages = new HashMap<String, String>();
    private final Set<String> newImports = new TreeSet<String>();
    private final StringBuilder segmentBuffer = new StringBuilder();
    private static final String USE_DECLARED = "!DECLARED!";
    private static final String USE_UNKNOWN = "!UNKNOWN!";
    private static final List<String> JAVA_LANG = Arrays.asList("java", "lang");

    private $ImportRewriter(CharSequence source) {
        this.source = source;
        this.len = source.length();
    }

    public static CharSequence rewrite(CharSequence content) {
        $ImportRewriter rewriter = new $ImportRewriter(content);
        rewriter.process();
        rewriter.rewrite();
        return rewriter.replace();
    }

    private String replace() {
        int sourceAt = 0;
        StringBuilder result = new StringBuilder(this.len);
        if (this.source.charAt(sourceAt) == '\n') {
            ++sourceAt;
        }
        LinkedHashSet<String> rewrittenImports = new LinkedHashSet<String>(this.newImports);
        for (Import import_ : this.imports) {
            if (!import_.isStatic && !import_.isStar && import_.classSegments.size() == 1 && import_.packageSegments.equals(JAVA_LANG)) continue;
            rewrittenImports.add(import_.toString());
        }
        for (GeneratedImportsModifier generatedImportsModifier : importsModifiers) {
            generatedImportsModifier.modify(this.thisPackage, rewrittenImports);
        }
        if (!rewrittenImports.isEmpty()) {
            int insertAt = Math.max(this.beforeImportPosition, this.afterPackagePosition);
            result.append(this.source, sourceAt, insertAt);
            sourceAt = insertAt;
            for (String n : rewrittenImports) {
                result.append("import ").append(n).append(";\n");
            }
            result.append("\n");
        }
        if (!this.imports.isEmpty()) {
            Import first = this.imports.get(0);
            Import import_ = this.imports.get(this.imports.size() - 1);
            result.append(this.source, sourceAt, first.at);
            sourceAt = import_.at + import_.len;
        }
        for (MaybeQualified maybeQualified : this.occurrences) {
            if (!maybeQualified.rewritten) continue;
            result.append(this.source, sourceAt, maybeQualified.at);
            sourceAt = maybeQualified.at + maybeQualified.len;
            this.printMaybeQualified(maybeQualified, result);
        }
        result.append(this.source, sourceAt, this.source.length());
        return result.toString();
    }

    private void rewrite() {
        this.occurrences.forEach(this::recordUnknownUsages);
        this.occurrences.forEach(this::maybeRewrite);
    }

    private void recordUnknownUsages(MaybeQualified q) {
        for (AnnotationUse a : q.markerTypeAnnotations) {
            this.recordUnknownUsages(a.name);
        }
        for (AnnotationUse a : q.typeAnnotations) {
            this.recordUnknownUsages(a.name);
        }
        if (q.packageSegments.isEmpty()) {
            String local = q.classSegments.getFirst();
            this.usages.putIfAbsent(local, USE_UNKNOWN);
        }
    }

    private void maybeRewrite(MaybeQualified q) {
        this.mergeNonConflictingMarkerTypeuseAnnotation(q);
        this.maybeRewriteQualifiedName(q);
        for (AnnotationUse a : q.typeAnnotations) {
            this.maybeRewriteQualifiedName(a.name);
            q.rewritten |= a.name.rewritten;
        }
    }

    private void maybeRewriteQualifiedName(MaybeQualified q) {
        String qualified;
        String localSegment;
        String existing;
        if (q.packageSegments.isEmpty()) {
            return;
        }
        String packagePrefix = String.join((CharSequence)".", q.packageSegments) + ".";
        LinkedList<String> topClassSegments = new LinkedList<String>(q.classSegments);
        do {
            if ((existing = this.usages.get(localSegment = topClassSegments.removeLast())) == null || existing == USE_DECLARED || existing == USE_UNKNOWN) continue;
            qualified = packagePrefix;
            if (!topClassSegments.isEmpty()) {
                qualified = qualified + String.join((CharSequence)".", topClassSegments) + ".";
            }
            if (!existing.equals(qualified = qualified + localSegment)) continue;
            q.rewritten = true;
            assert (topClassSegments.size() <= q.classSegments.size());
            while (!topClassSegments.isEmpty() && q.classSegments.getFirst().equals(topClassSegments.getFirst())) {
                q.classSegments.removeFirst();
                topClassSegments.removeFirst();
            }
            q.packageSegments.clear();
            return;
        } while (!topClassSegments.isEmpty());
        existing = this.usages.get(localSegment);
        qualified = packagePrefix + localSegment;
        if (existing == null) {
            this.usages.put(localSegment, qualified);
            if (!packagePrefix.equals("java.lang.") && !packagePrefix.equals(this.thisPackagePrefix)) {
                this.newImports.add(qualified);
            }
            q.rewritten = true;
            q.packageSegments.clear();
        } else if (packagePrefix.equals(this.thisPackagePrefix)) {
            if (existing == USE_DECLARED) {
                q.rewritten = true;
                q.packageSegments.clear();
            } else if (existing == USE_UNKNOWN || existing.equals(qualified)) {
                if (existing == USE_UNKNOWN) {
                    this.usages.put(localSegment, qualified);
                }
                q.rewritten = true;
                q.packageSegments.clear();
            }
        }
    }

    private void mergeNonConflictingMarkerTypeuseAnnotation(MaybeQualified q) {
        if (!q.markerTypeAnnotations.isEmpty()) {
            for (AnnotationUse markerAnnotation : q.markerTypeAnnotations) {
                if (this.potentialConflictTypeName(markerAnnotation, q.typeAnnotations)) continue;
                q.typeAnnotations.add(markerAnnotation);
                q.rewritten = true;
            }
        }
    }

    private boolean potentialConflictTypeName(AnnotationUse annotation, List<AnnotationUse> annotations) {
        for (AnnotationUse a : annotations) {
            if (!a.name.classSegments.getLast().equals(annotation.name.classSegments.getLast()) || a.name.classSegments.size() == annotation.name.classSegments.size() && a.name.classSegments.size() > 1 && !a.name.classSegments.equals(annotation.name.classSegments) || !a.name.packageSegments.isEmpty() && !annotation.name.packageSegments.isEmpty() && (!a.name.packageSegments.equals(annotation.name.packageSegments) || !a.name.classSegments.equals(annotation.name.classSegments))) continue;
            return true;
        }
        return false;
    }

    private void printMaybeQualified(MaybeQualified q, StringBuilder buffer) {
        if (q.packageSegments.isEmpty() && q.classSegments.size() == 1 && !q.typeAnnotations.isEmpty()) {
            for (AnnotationUse a : q.typeAnnotations) {
                buffer.append('@');
                this.printMaybeQualified(a.name, buffer);
                buffer.append(' ');
            }
            buffer.append(q.classSegments.getFirst());
        } else {
            for (String p : q.packageSegments) {
                buffer.append(p).append('.');
            }
            String lastType = q.classSegments.removeLast();
            for (String c : q.classSegments) {
                buffer.append(c).append('.');
            }
            for (AnnotationUse a : q.typeAnnotations) {
                buffer.append('@');
                this.printMaybeQualified(a.name, buffer);
                buffer.append(' ');
            }
            buffer.append(lastType);
        }
    }

    private void process() {
        block12: while (this.at < this.len) {
            char c = this.source.charAt(this.at);
            switch (c) {
                case '\"': {
                    this.consumeStringLiteral();
                    continue block12;
                }
                case '\'': {
                    this.consumeCharLiteral();
                    continue block12;
                }
                case '/': {
                    if (!this.processTypeUseMarker() && !this.consumeEndOfLineComment() && !this.consumeBlockComment()) break;
                    continue block12;
                }
                default: {
                    char previous;
                    if (Character.isWhitespace(c) && this.consumeWhitespace()) continue block12;
                    char c2 = previous = this.at > 0 ? this.source.charAt(this.at - 1) : (char)'\u0000';
                    if (!Character.isJavaIdentifierStart(c) || Character.isJavaIdentifierPart(previous) && previous != '\u0000') break;
                    switch (c) {
                        case 'p': {
                            if (!this.processPackage()) break;
                            continue block12;
                        }
                        case 'i': {
                            if (!this.processImport() && !this.processInterface()) break;
                            continue block12;
                        }
                        case 'c': {
                            if (!this.processClass()) break;
                            continue block12;
                        }
                        case 'r': {
                            if (!this.processRecord()) break;
                            continue block12;
                        }
                        case 'e': {
                            if (!this.processEnum()) break;
                            continue block12;
                        }
                    }
                    if (this.processIdentifier()) continue block12;
                }
            }
            ++this.at;
        }
    }

    private boolean processTypeUseMarker() {
        int begin;
        block6: {
            begin = this.at;
            if (this.consumeKeyword('/', '*', '!', 't', 'y', 'p', 'e', 'u', 's', 'e')) {
                MaybeQualified qualified = new MaybeQualified();
                while (this.source.charAt(this.at) == '@') {
                    ++this.at;
                    this.consumeWhitespace();
                    AnnotationUse ann = new AnnotationUse();
                    qualified.markerTypeAnnotations.add(ann);
                    if (this.consumeQualifiedName(ann.name.packageSegments::add, ann.name.classSegments::add)) {
                        if (this.source.charAt(this.at) != '(') continue;
                        if (this.consumeToMatchingClosingParen(ann.attributes)) {
                            this.consumeWhitespace();
                            continue;
                        }
                    }
                    break block6;
                }
                this.advanceUntilCommentEnd();
                if (!qualified.markerTypeAnnotations.isEmpty()) {
                    this.consumeWhitespace();
                    if (this.consumeMaybeAnnotatedQualifiedName(qualified)) {
                        qualified.range(begin, qualified.at + qualified.len - begin);
                        this.addMaybeQualified(qualified);
                        return true;
                    }
                }
            }
        }
        this.at = begin;
        return false;
    }

    private boolean processPackage() {
        int begin = this.at;
        if (this.consumeKeyword('p', 'a', 'c', 'k', 'a', 'g', 'e')) {
            ArrayList packageSegments = new ArrayList();
            this.consumeQualifiedName(packageSegments::add, a -> {});
            this.thisPackage = String.join((CharSequence)".", packageSegments);
            this.thisPackagePrefix = this.thisPackage + ".";
            this.consume(';');
            this.consumeWhitespace();
            this.afterPackagePosition = this.at;
            return true;
        }
        return false;
    }

    private boolean consume(char c) {
        if (this.source.charAt(this.at) == c) {
            ++this.at;
            return true;
        }
        return false;
    }

    private boolean consumeQualifiedName(Consumer<String> packageSegments, Consumer<String> classSegments) {
        char c = this.source.charAt(this.at);
        if (!Character.isJavaIdentifierStart(c)) {
            return false;
        }
        int beforeDot = this.at;
        boolean endsWithDot = false;
        while (this.at < this.len && Character.isJavaIdentifierStart(c = this.source.charAt(this.at)) && !Character.isUpperCase(c)) {
            this.segmentBuffer.setLength(0);
            this.consumeIdentifierSegment(this.segmentBuffer);
            packageSegments.accept(this.segmentBuffer.toString());
            endsWithDot = false;
            beforeDot = this.at;
            this.consumeWhitespace();
            if (!this.consume('.')) break;
            endsWithDot = true;
            this.consumeWhitespace();
        }
        while (this.at < this.len && Character.isJavaIdentifierStart(c = this.source.charAt(this.at)) && Character.isUpperCase(c)) {
            this.segmentBuffer.setLength(0);
            this.consumeIdentifierSegment(this.segmentBuffer);
            classSegments.accept(this.segmentBuffer.toString());
            endsWithDot = false;
            beforeDot = this.at;
            this.consumeWhitespace();
            if (!this.consume('.')) break;
            endsWithDot = true;
            this.consumeWhitespace();
        }
        if (endsWithDot) {
            this.at = beforeDot;
            this.consumeWhitespace();
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private boolean consumeMaybeAnnotatedQualifiedName(MaybeQualified qualified) {
        block10: {
            begin = this.at;
            c = this.source.charAt(this.at);
            if (!Character.isJavaIdentifierStart(c)) {
                return false;
            }
            beforeWhitespace = this.at;
            qualifyingType = false;
            while (this.at < this.len && Character.isJavaIdentifierStart(c = this.source.charAt(this.at))) {
                isTypeCase = Character.isUpperCase(c);
                this.segmentBuffer.setLength(0);
                this.consumeIdentifierSegment(this.segmentBuffer);
                ((qualifyingType |= isTypeCase) != false ? qualified.classSegments : qualified.packageSegments).add(this.segmentBuffer.toString());
                beforeWhitespace = this.at;
                this.consumeWhitespace();
                if (!this.consume('.')) ** GOTO lbl60
                this.consumeWhitespace();
                hadTypeUseAnnotations = false;
                while (this.source.charAt(this.at) == '@') {
                    ++this.at;
                    hadTypeUseAnnotations = true;
                    this.consumeWhitespace();
                    ann = new AnnotationUse();
                    qualified.typeAnnotations.add(ann);
                    if (this.consumeQualifiedName((Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, add(E ), (Ljava/lang/String;)V)(ann.name.packageSegments), (Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, add(E ), (Ljava/lang/String;)V)(ann.name.classSegments))) {
                        if (this.source.charAt(this.at) != '(') continue;
                        if (this.consumeToMatchingClosingParen(ann.attributes)) {
                            beforeWhitespace = this.at;
                            this.consumeWhitespace();
                            continue;
                        }
                    }
                    break block10;
                }
                if (hadTypeUseAnnotations) {
                    this.segmentBuffer.setLength(0);
                    c = this.source.charAt(this.at);
                    if (Character.isJavaIdentifierStart(c) && Character.isUpperCase(c) && this.consumeIdentifierSegment(this.segmentBuffer)) {
                        beforeWhitespace = this.at;
                        qualified.classSegments.add(this.segmentBuffer.toString());
                        qualified.range(begin, beforeWhitespace - begin);
                        this.consumeWhitespace();
                        return true;
                    }
                } else {
                    if (!isTypeCase || this.at >= this.len || (!Character.isJavaIdentifierStart(c = this.source.charAt(this.at)) || Character.isUpperCase(c)) && c != '<') continue;
                    qualified.range(begin, beforeWhitespace - begin);
                    this.consumeWhitespace();
                    return true;
lbl60:
                    // 1 sources

                    if (isTypeCase) {
                        break;
                    }
                }
                break block10;
            }
            if (!qualified.classSegments.isEmpty()) {
                qualified.range(begin, beforeWhitespace - begin);
                this.consumeWhitespace();
                return true;
            }
        }
        this.at = begin;
        return false;
    }

    private boolean consumeToMatchingClosingParen(StringBuilder attributes) {
        int begin = this.at;
        assert (this.source.charAt(this.at) == '(');
        ++this.at;
        int open = 1;
        block6: while (this.at < this.len) {
            char c = this.source.charAt(this.at);
            switch (c) {
                case '(': {
                    ++open;
                    break;
                }
                case ')': {
                    if (--open != 0) break;
                    ++this.at;
                    attributes.append(this.source, begin, this.at);
                    return true;
                }
                case '\'': {
                    this.consumeCharLiteral();
                    continue block6;
                }
                case '\"': {
                    this.consumeStringLiteral();
                    continue block6;
                }
                default: {
                    attributes.append(c);
                }
            }
            ++this.at;
        }
        this.at = begin;
        return false;
    }

    private boolean consumeIdentifierSegment(StringBuilder into) {
        if (Character.isJavaIdentifierStart(this.source.charAt(this.at))) {
            char c;
            while (Character.isJavaIdentifierPart(c = this.source.charAt(this.at))) {
                into.append(c);
                ++this.at;
            }
            return true;
        }
        return false;
    }

    private boolean processImport() {
        int begin = this.at;
        if (this.consumeKeyword('i', 'm', 'p', 'o', 'r', 't')) {
            if (this.beforeImportPosition == 0) {
                this.beforeImportPosition = begin;
            }
            Import imp = new Import();
            imp.isStatic = this.consumeKeyword('s', 't', 'a', 't', 'i', 'c');
            this.consumeQualifiedName(imp.packageSegments::add, imp.classSegments::add);
            if (this.consume(';')) {
                this.consumeWhitespace();
                imp.range(begin, this.at - begin);
                this.addImport(imp);
            } else if (this.consume('.')) {
                this.consumeWhitespace();
                if (this.consume('*')) {
                    this.consumeWhitespace();
                    if (this.consume(';')) {
                        imp.isStar = true;
                        imp.range(begin, this.at - begin);
                        this.addImport(imp);
                    }
                } else {
                    int moreAt = this.at;
                    this.consumeUntilOnSameLine(';');
                    imp.more = this.source.subSequence(moreAt, this.at - 1).toString();
                    imp.range(begin, this.at - begin);
                    this.addImport(imp);
                }
            } else if (this.consume('*')) {
                this.consumeWhitespace();
                if (this.consume(';')) {
                    imp.isStar = true;
                    imp.range(begin, this.at - begin);
                    this.addImport(imp);
                }
            } else {
                int moreAt = this.at;
                this.consumeUntilOnSameLine(';');
                imp.more = this.source.subSequence(moreAt, this.at - 1).toString();
                imp.range(begin, this.at - begin);
                this.addImport(imp);
            }
            return true;
        }
        this.at = begin;
        return false;
    }

    private void consumeUntilOnSameLine(char c1) {
        char c;
        while ((c = this.source.charAt(this.at++)) != c1 && c != '\n') {
        }
    }

    private void addImport(Import imp) {
        this.imports.add(imp);
        if (!imp.classSegments.isEmpty()) {
            this.usages.put(imp.local(), imp.asKey());
        }
    }

    private boolean processRecord() {
        if (this.consumeKeyword('r', 'e', 'c', 'o', 'r', 'd')) {
            this.consumeDeclared();
            return true;
        }
        return false;
    }

    private boolean processInterface() {
        if (this.consumeKeyword('i', 'n', 't', 'e', 'r', 'f', 'a', 'c', 'e')) {
            this.consumeDeclared();
            return true;
        }
        return false;
    }

    private boolean processEnum() {
        if (this.consumeKeyword('e', 'n', 'u', 'm')) {
            this.consumeDeclared();
            return true;
        }
        return false;
    }

    private boolean processClass() {
        if (this.consumeKeyword('c', 'l', 'a', 's', 's')) {
            this.consumeDeclared();
            return true;
        }
        return false;
    }

    private void consumeDeclared() {
        int begin = this.at;
        Declaration declaration = new Declaration();
        this.consumeIdentifierSegment(declaration.name);
        declaration.range(begin, this.at - begin);
        this.addDeclared(declaration);
    }

    private void addDeclared(Declaration declared) {
        this.declarations.add(declared);
        this.usages.put(declared.name.toString(), USE_DECLARED);
    }

    private boolean processIdentifier() {
        MaybeQualified qualified;
        char c = this.source.charAt(this.at);
        int begin = this.at;
        if (Character.isJavaIdentifierStart(c) && this.consumeMaybeAnnotatedQualifiedName(qualified = new MaybeQualified())) {
            this.addMaybeQualified(qualified);
            return true;
        }
        this.at = begin;
        return false;
    }

    private void addMaybeQualified(MaybeQualified qualified) {
        if (qualified.packageSegments.isEmpty() && qualified.typeAnnotations.isEmpty() && qualified.markerTypeAnnotations.isEmpty()) {
            this.usages.putIfAbsent(qualified.classSegments.getFirst(), USE_UNKNOWN);
            return;
        }
        this.occurrences.add(qualified);
    }

    private void consumeStringLiteral() {
        assert (this.source.charAt(this.at) == '\"');
        int begin = this.at++;
        while (this.at < this.len) {
            if (this.source.charAt(this.at) == '\"' && this.source.charAt(this.at - 1) != '\\') {
                ++this.at;
                break;
            }
            ++this.at;
        }
    }

    private void consumeCharLiteral() {
        assert (this.source.charAt(this.at) == '\'');
        int begin = this.at++;
        while (this.at < this.len) {
            if (this.source.charAt(this.at) == '\'' && this.source.charAt(this.at - 1) != '\\') {
                ++this.at;
                break;
            }
            ++this.at;
        }
    }

    private boolean consumeWhitespace() {
        if (Character.isWhitespace(this.source.charAt(this.at))) {
            int begin = this.at;
            while (this.at < this.len && Character.isWhitespace(this.source.charAt(this.at))) {
                ++this.at;
            }
            return true;
        }
        return false;
    }

    private boolean consumeBlockComment() {
        if (this.matches('/', '*')) {
            int begin = this.at;
            this.at += 2;
            this.advanceUntilCommentEnd();
            return true;
        }
        return false;
    }

    private void advanceUntilCommentEnd() {
        while (this.at < this.len) {
            if (this.matches('*', '/')) {
                this.at += 2;
                break;
            }
            ++this.at;
        }
    }

    private boolean consumeEndOfLineComment() {
        if (this.matches('/', '/')) {
            int begin = this.at;
            this.at += 2;
            while (this.at < this.len) {
                if (this.source.charAt(this.at) == '\n') {
                    ++this.at;
                    break;
                }
                ++this.at;
            }
            return true;
        }
        return false;
    }

    private boolean matches(char c0, char c1) {
        return this.at + 2 < this.len && this.source.charAt(this.at) == c0 && this.source.charAt(this.at + 1) == c1;
    }

    private boolean consumeKeyword(char ... chars) {
        int begin = this.at;
        if (this.matches(chars) && this.at + chars.length < this.len && Character.isWhitespace(this.source.charAt(this.at + chars.length))) {
            this.at += chars.length;
            return this.consumeWhitespace();
        }
        return false;
    }

    private boolean matches(char ... chars) {
        if (this.at + chars.length >= this.len) {
            return false;
        }
        for (int i = 0; i < chars.length; ++i) {
            if (this.source.charAt(this.at + i) == chars[i]) continue;
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        String[] source = new String[]{"package some.pack;", "", "  // line comment", "  /* block comment */", "import static java.util.Collections.emptyList;", "import static java.util.List.*;", "import java.util.*;", "import java.util.Set;", "import java.lang.Integer;", "import static java.lang.Long.MIN_VALUE;", "import static java.util.Map.Entry;", "import static java.util.Map.*;", "import static java.util.Map.entry;", "import java.lang.Object; // something", "import java.lang.String; // another", "  ", "public record Hello() {}", "class Another {", "  private enum Or {", "    ABC,", "    GHT,", "  }", "  public final Something.@pack.Nullable @quack.Nullable Something goes() { return null; }", "  public final p1.p2.@Empty @els.bor.Or(value = {true, false}) Epty goes2() { return null; }", "  public final p1.p3.Yaz vock(int a) { return null; }", "  public final p1.p3.Nop lock(int a, String b) { return null; }", "  public /*!typeuse @hoppy.Jully */ java.lang.@hoppy.Jully String ask;", "  public /*!typeuse @Nully */ p1.p3.Nop nock(int a, String b) { return null; }", "  public /*!typeuse @stl.Nully @Other(\"ABV\")*/ Nop lock(int a, String b) {", "    char c = '\"';", "    int[] x = acc.some.Be.EMPTY;", "    java.util.List.<String>of();", "    java.util.Collections.emptySet();", "    something.to.Impo.RT;", "    java.lang.Long.MIN_VALUE.oops;", "    java.lang.Integer.MAX_VALUE.oops;", "    java.lang.String.format(\"%d\", 1);", "    return java.util.Collections::sort;", "  }", "  /*private void Another() {}*/", "}"};
        CharSequence[] source2 = new String[]{"/*!typeuse @hoppy.Jully */ java.lang.@hoppy.Jully String ask;"};
        CharSequence result = $ImportRewriter.rewrite(String.join((CharSequence)"\n", source2));
        System.out.println(result);
    }

    private static final class AnnotationUse {
        final MaybeQualified name = new MaybeQualified();
        final StringBuilder attributes = new StringBuilder();

        private AnnotationUse() {
        }

        public String toString() {
            return "@" + this.name + this.attributes;
        }
    }

    private static final class MaybeQualified
    extends Occurrence {
        final LinkedList<String> packageSegments = new LinkedList();
        final LinkedList<String> classSegments = new LinkedList();
        final StringBuilder name = new StringBuilder();
        final List<AnnotationUse> markerTypeAnnotations = new ArrayList<AnnotationUse>();
        final List<AnnotationUse> typeAnnotations = new ArrayList<AnnotationUse>();
        @Nullable
        private String importKey;
        boolean rewritten;

        private MaybeQualified() {
        }

        public String toString() {
            return (this.packageSegments.isEmpty() ? "" : "[" + String.join((CharSequence)".", this.packageSegments) + "]") + String.join((CharSequence)".", this.classSegments) + (this.typeAnnotations.isEmpty() ? "" : " :: " + this.typeAnnotations.stream().map(Objects::toString).collect(Collectors.joining(", "))) + (this.markerTypeAnnotations.isEmpty() ? "" : " !: " + this.markerTypeAnnotations.stream().map(Objects::toString).collect(Collectors.joining(", ")));
        }
    }

    private static final class Declaration
    extends Occurrence {
        final StringBuilder name = new StringBuilder();

        private Declaration() {
        }

        public String toString() {
            return this.name.toString();
        }
    }

    private static final class Import
    extends Occurrence {
        final LinkedList<String> packageSegments = new LinkedList();
        final LinkedList<String> classSegments = new LinkedList();
        @Nullable
        String more;
        boolean isStatic;
        boolean isStar;

        private Import() {
        }

        public String toString() {
            return (this.isStatic ? "static " : "") + this.asKey() + (this.more != null ? "." + this.more : "") + (this.isStar ? ".*" : "");
        }

        String asKey() {
            return (this.packageSegments.isEmpty() ? "" : String.join((CharSequence)".", this.packageSegments) + (this.classSegments.isEmpty() ? "" : ".")) + String.join((CharSequence)".", this.classSegments);
        }

        String local() {
            return this.classSegments.getLast();
        }
    }

    private static abstract class Occurrence {
        int at;
        int len;

        private Occurrence() {
        }

        void range(int at, int len) {
            this.at = at;
            this.len = len;
        }
    }
}

